/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCuratedEnvironmentImagesResponse extends CodeBuildResponse implements
        ToCopyableBuilder<ListCuratedEnvironmentImagesResponse.Builder, ListCuratedEnvironmentImagesResponse> {
    private static final SdkField<List<EnvironmentPlatform>> PLATFORMS_FIELD = SdkField
            .<List<EnvironmentPlatform>> builder(MarshallingType.LIST)
            .memberName("platforms")
            .getter(getter(ListCuratedEnvironmentImagesResponse::platforms))
            .setter(setter(Builder::platforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platforms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentPlatform> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentPlatform::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORMS_FIELD));

    private final List<EnvironmentPlatform> platforms;

    private ListCuratedEnvironmentImagesResponse(BuilderImpl builder) {
        super(builder);
        this.platforms = builder.platforms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Platforms property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPlatforms() {
        return platforms != null && !(platforms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about supported platforms for Docker images that are managed by CodeBuild.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlatforms} method.
     * </p>
     * 
     * @return Information about supported platforms for Docker images that are managed by CodeBuild.
     */
    public final List<EnvironmentPlatform> platforms() {
        return platforms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPlatforms() ? platforms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCuratedEnvironmentImagesResponse)) {
            return false;
        }
        ListCuratedEnvironmentImagesResponse other = (ListCuratedEnvironmentImagesResponse) obj;
        return hasPlatforms() == other.hasPlatforms() && Objects.equals(platforms(), other.platforms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCuratedEnvironmentImagesResponse").add("Platforms", hasPlatforms() ? platforms() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "platforms":
            return Optional.ofNullable(clazz.cast(platforms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCuratedEnvironmentImagesResponse, T> g) {
        return obj -> g.apply((ListCuratedEnvironmentImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCuratedEnvironmentImagesResponse> {
        /**
         * <p>
         * Information about supported platforms for Docker images that are managed by CodeBuild.
         * </p>
         * 
         * @param platforms
         *        Information about supported platforms for Docker images that are managed by CodeBuild.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platforms(Collection<EnvironmentPlatform> platforms);

        /**
         * <p>
         * Information about supported platforms for Docker images that are managed by CodeBuild.
         * </p>
         * 
         * @param platforms
         *        Information about supported platforms for Docker images that are managed by CodeBuild.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platforms(EnvironmentPlatform... platforms);

        /**
         * <p>
         * Information about supported platforms for Docker images that are managed by CodeBuild.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform.Builder#build()} is called
         * immediately and its result is passed to {@link #platforms(List<EnvironmentPlatform>)}.
         * 
         * @param platforms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platforms(java.util.Collection<EnvironmentPlatform>)
         */
        Builder platforms(Consumer<EnvironmentPlatform.Builder>... platforms);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<EnvironmentPlatform> platforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCuratedEnvironmentImagesResponse model) {
            super(model);
            platforms(model.platforms);
        }

        public final List<EnvironmentPlatform.Builder> getPlatforms() {
            List<EnvironmentPlatform.Builder> result = EnvironmentPlatformsCopier.copyToBuilder(this.platforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatforms(Collection<EnvironmentPlatform.BuilderImpl> platforms) {
            this.platforms = EnvironmentPlatformsCopier.copyFromBuilder(platforms);
        }

        @Override
        public final Builder platforms(Collection<EnvironmentPlatform> platforms) {
            this.platforms = EnvironmentPlatformsCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(EnvironmentPlatform... platforms) {
            platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(Consumer<EnvironmentPlatform.Builder>... platforms) {
            platforms(Stream.of(platforms).map(c -> EnvironmentPlatform.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCuratedEnvironmentImagesResponse build() {
            return new ListCuratedEnvironmentImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
