/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the origin restrictions set on the package. The package origin restrictions determine how new versions
 * of a package can be added to a specific repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageOriginRestrictions implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageOriginRestrictions.Builder, PackageOriginRestrictions> {
    private static final SdkField<String> PUBLISH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("publish")
            .getter(getter(PackageOriginRestrictions::publishAsString)).setter(setter(Builder::publish))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publish").build()).build();

    private static final SdkField<String> UPSTREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstream").getter(getter(PackageOriginRestrictions::upstreamAsString)).setter(setter(Builder::upstream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PUBLISH_FIELD, UPSTREAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String publish;

    private final String upstream;

    private PackageOriginRestrictions(BuilderImpl builder) {
        this.publish = builder.publish;
        this.upstream = builder.upstream;
    }

    /**
     * <p>
     * The package origin configuration that determines if new versions of the package can be published directly to the
     * repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publish} will
     * return {@link AllowPublish#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #publishAsString}.
     * </p>
     * 
     * @return The package origin configuration that determines if new versions of the package can be published directly
     *         to the repository.
     * @see AllowPublish
     */
    public final AllowPublish publish() {
        return AllowPublish.fromValue(publish);
    }

    /**
     * <p>
     * The package origin configuration that determines if new versions of the package can be published directly to the
     * repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publish} will
     * return {@link AllowPublish#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #publishAsString}.
     * </p>
     * 
     * @return The package origin configuration that determines if new versions of the package can be published directly
     *         to the repository.
     * @see AllowPublish
     */
    public final String publishAsString() {
        return publish;
    }

    /**
     * <p>
     * The package origin configuration that determines if new versions of the package can be added to the repository
     * from an external connection or upstream source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upstream} will
     * return {@link AllowUpstream#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upstreamAsString}.
     * </p>
     * 
     * @return The package origin configuration that determines if new versions of the package can be added to the
     *         repository from an external connection or upstream source.
     * @see AllowUpstream
     */
    public final AllowUpstream upstream() {
        return AllowUpstream.fromValue(upstream);
    }

    /**
     * <p>
     * The package origin configuration that determines if new versions of the package can be added to the repository
     * from an external connection or upstream source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upstream} will
     * return {@link AllowUpstream#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upstreamAsString}.
     * </p>
     * 
     * @return The package origin configuration that determines if new versions of the package can be added to the
     *         repository from an external connection or upstream source.
     * @see AllowUpstream
     */
    public final String upstreamAsString() {
        return upstream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publishAsString());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageOriginRestrictions)) {
            return false;
        }
        PackageOriginRestrictions other = (PackageOriginRestrictions) obj;
        return Objects.equals(publishAsString(), other.publishAsString())
                && Objects.equals(upstreamAsString(), other.upstreamAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageOriginRestrictions").add("Publish", publishAsString())
                .add("Upstream", upstreamAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "publish":
            return Optional.ofNullable(clazz.cast(publishAsString()));
        case "upstream":
            return Optional.ofNullable(clazz.cast(upstreamAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageOriginRestrictions, T> g) {
        return obj -> g.apply((PackageOriginRestrictions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageOriginRestrictions> {
        /**
         * <p>
         * The package origin configuration that determines if new versions of the package can be published directly to
         * the repository.
         * </p>
         * 
         * @param publish
         *        The package origin configuration that determines if new versions of the package can be published
         *        directly to the repository.
         * @see AllowPublish
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowPublish
         */
        Builder publish(String publish);

        /**
         * <p>
         * The package origin configuration that determines if new versions of the package can be published directly to
         * the repository.
         * </p>
         * 
         * @param publish
         *        The package origin configuration that determines if new versions of the package can be published
         *        directly to the repository.
         * @see AllowPublish
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowPublish
         */
        Builder publish(AllowPublish publish);

        /**
         * <p>
         * The package origin configuration that determines if new versions of the package can be added to the
         * repository from an external connection or upstream source.
         * </p>
         * 
         * @param upstream
         *        The package origin configuration that determines if new versions of the package can be added to the
         *        repository from an external connection or upstream source.
         * @see AllowUpstream
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowUpstream
         */
        Builder upstream(String upstream);

        /**
         * <p>
         * The package origin configuration that determines if new versions of the package can be added to the
         * repository from an external connection or upstream source.
         * </p>
         * 
         * @param upstream
         *        The package origin configuration that determines if new versions of the package can be added to the
         *        repository from an external connection or upstream source.
         * @see AllowUpstream
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowUpstream
         */
        Builder upstream(AllowUpstream upstream);
    }

    static final class BuilderImpl implements Builder {
        private String publish;

        private String upstream;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageOriginRestrictions model) {
            publish(model.publish);
            upstream(model.upstream);
        }

        public final String getPublish() {
            return publish;
        }

        public final void setPublish(String publish) {
            this.publish = publish;
        }

        @Override
        public final Builder publish(String publish) {
            this.publish = publish;
            return this;
        }

        @Override
        public final Builder publish(AllowPublish publish) {
            this.publish(publish == null ? null : publish.toString());
            return this;
        }

        public final String getUpstream() {
            return upstream;
        }

        public final void setUpstream(String upstream) {
            this.upstream = upstream;
        }

        @Override
        public final Builder upstream(String upstream) {
            this.upstream = upstream;
            return this;
        }

        @Override
        public final Builder upstream(AllowUpstream upstream) {
            this.upstream(upstream == null ? null : upstream.toString());
            return this;
        }

        @Override
        public PackageOriginRestrictions build() {
            return new PackageOriginRestrictions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
