/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionListCopier;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionRevisionMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyPackageVersionsRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, CopyPackageVersionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::domain)).setter(CopyPackageVersionsRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::domainOwner)).setter(CopyPackageVersionsRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> SOURCE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceRepository").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::sourceRepository)).setter(CopyPackageVersionsRequest.setter(Builder::sourceRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("source-repository").build()}).build();
    private static final SdkField<String> DESTINATION_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationRepository").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::destinationRepository)).setter(CopyPackageVersionsRequest.setter(Builder::destinationRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destination-repository").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::formatAsString)).setter(CopyPackageVersionsRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::namespace)).setter(CopyPackageVersionsRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("package").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::packageValue)).setter(CopyPackageVersionsRequest.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package").build()}).build();
    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("versions").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::versions)).setter(CopyPackageVersionsRequest.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VERSION_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("versionRevisions").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::versionRevisions)).setter(CopyPackageVersionsRequest.setter(Builder::versionRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevisions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOW_OVERWRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowOverwrite").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::allowOverwrite)).setter(CopyPackageVersionsRequest.setter(Builder::allowOverwrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowOverwrite").build()}).build();
    private static final SdkField<Boolean> INCLUDE_FROM_UPSTREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeFromUpstream").getter(CopyPackageVersionsRequest.getter(CopyPackageVersionsRequest::includeFromUpstream)).setter(CopyPackageVersionsRequest.setter(Builder::includeFromUpstream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeFromUpstream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, SOURCE_REPOSITORY_FIELD, DESTINATION_REPOSITORY_FIELD, FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, VERSIONS_FIELD, VERSION_REVISIONS_FIELD, ALLOW_OVERWRITE_FIELD, INCLUDE_FROM_UPSTREAM_FIELD));
    private final String domain;
    private final String domainOwner;
    private final String sourceRepository;
    private final String destinationRepository;
    private final String format;
    private final String namespace;
    private final String packageValue;
    private final List<String> versions;
    private final Map<String, String> versionRevisions;
    private final Boolean allowOverwrite;
    private final Boolean includeFromUpstream;

    private CopyPackageVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.sourceRepository = builder.sourceRepository;
        this.destinationRepository = builder.destinationRepository;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.versions = builder.versions;
        this.versionRevisions = builder.versionRevisions;
        this.allowOverwrite = builder.allowOverwrite;
        this.includeFromUpstream = builder.includeFromUpstream;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String sourceRepository() {
        return this.sourceRepository;
    }

    public final String destinationRepository() {
        return this.destinationRepository;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final boolean hasVersions() {
        return this.versions != null && !(this.versions instanceof SdkAutoConstructList);
    }

    public final List<String> versions() {
        return this.versions;
    }

    public final boolean hasVersionRevisions() {
        return this.versionRevisions != null && !(this.versionRevisions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> versionRevisions() {
        return this.versionRevisions;
    }

    public final Boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public final Boolean includeFromUpstream() {
        return this.includeFromUpstream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersions() ? this.versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersionRevisions() ? this.versionRevisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowOverwrite());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeFromUpstream());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyPackageVersionsRequest)) {
            return false;
        }
        CopyPackageVersionsRequest other = (CopyPackageVersionsRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.sourceRepository(), other.sourceRepository()) && Objects.equals(this.destinationRepository(), other.destinationRepository()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && this.hasVersions() == other.hasVersions() && Objects.equals(this.versions(), other.versions()) && this.hasVersionRevisions() == other.hasVersionRevisions() && Objects.equals(this.versionRevisions(), other.versionRevisions()) && Objects.equals(this.allowOverwrite(), other.allowOverwrite()) && Objects.equals(this.includeFromUpstream(), other.includeFromUpstream());
    }

    public final String toString() {
        return ToString.builder((String)"CopyPackageVersionsRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("SourceRepository", (Object)this.sourceRepository()).add("DestinationRepository", (Object)this.destinationRepository()).add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("Versions", this.hasVersions() ? this.versions() : null).add("VersionRevisions", this.hasVersionRevisions() ? this.versionRevisions() : null).add("AllowOverwrite", (Object)this.allowOverwrite()).add("IncludeFromUpstream", (Object)this.includeFromUpstream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "sourceRepository": {
                return Optional.ofNullable(clazz.cast(this.sourceRepository()));
            }
            case "destinationRepository": {
                return Optional.ofNullable(clazz.cast(this.destinationRepository()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
            case "versionRevisions": {
                return Optional.ofNullable(clazz.cast(this.versionRevisions()));
            }
            case "allowOverwrite": {
                return Optional.ofNullable(clazz.cast(this.allowOverwrite()));
            }
            case "includeFromUpstream": {
                return Optional.ofNullable(clazz.cast(this.includeFromUpstream()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyPackageVersionsRequest, T> g) {
        return obj -> g.apply((CopyPackageVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String sourceRepository;
        private String destinationRepository;
        private String format;
        private String namespace;
        private String packageValue;
        private List<String> versions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> versionRevisions = DefaultSdkAutoConstructMap.getInstance();
        private Boolean allowOverwrite;
        private Boolean includeFromUpstream;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyPackageVersionsRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.sourceRepository(model.sourceRepository);
            this.destinationRepository(model.destinationRepository);
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.versions(model.versions);
            this.versionRevisions(model.versionRevisions);
            this.allowOverwrite(model.allowOverwrite);
            this.includeFromUpstream(model.includeFromUpstream);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getSourceRepository() {
            return this.sourceRepository;
        }

        public final void setSourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
        }

        @Override
        public final Builder sourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
            return this;
        }

        public final String getDestinationRepository() {
            return this.destinationRepository;
        }

        public final void setDestinationRepository(String destinationRepository) {
            this.destinationRepository = destinationRepository;
        }

        @Override
        public final Builder destinationRepository(String destinationRepository) {
            this.destinationRepository = destinationRepository;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final Collection<String> getVersions() {
            if (this.versions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.versions;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = PackageVersionListCopier.copy(versions);
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = PackageVersionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final Map<String, String> getVersionRevisions() {
            if (this.versionRevisions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.versionRevisions;
        }

        public final void setVersionRevisions(Map<String, String> versionRevisions) {
            this.versionRevisions = PackageVersionRevisionMapCopier.copy(versionRevisions);
        }

        @Override
        public final Builder versionRevisions(Map<String, String> versionRevisions) {
            this.versionRevisions = PackageVersionRevisionMapCopier.copy(versionRevisions);
            return this;
        }

        public final Boolean getAllowOverwrite() {
            return this.allowOverwrite;
        }

        public final void setAllowOverwrite(Boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
        }

        @Override
        public final Builder allowOverwrite(Boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public final Boolean getIncludeFromUpstream() {
            return this.includeFromUpstream;
        }

        public final void setIncludeFromUpstream(Boolean includeFromUpstream) {
            this.includeFromUpstream = includeFromUpstream;
        }

        @Override
        public final Builder includeFromUpstream(Boolean includeFromUpstream) {
            this.includeFromUpstream = includeFromUpstream;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyPackageVersionsRequest build() {
            return new CopyPackageVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyPackageVersionsRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder sourceRepository(String var1);

        public Builder destinationRepository(String var1);

        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);

        public Builder versionRevisions(Map<String, String> var1);

        public Builder allowOverwrite(Boolean var1);

        public Builder includeFromUpstream(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

