/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLogStreamsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DescribeLogStreamsRequest.Builder, DescribeLogStreamsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(DescribeLogStreamsRequest::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupIdentifier").getter(getter(DescribeLogStreamsRequest::logGroupIdentifier))
            .setter(setter(Builder::logGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build())
            .build();

    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamNamePrefix").getter(getter(DescribeLogStreamsRequest::logStreamNamePrefix))
            .setter(setter(Builder::logStreamNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefix").build())
            .build();

    private static final SdkField<String> ORDER_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderBy").getter(getter(DescribeLogStreamsRequest::orderByAsString)).setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()).build();

    private static final SdkField<Boolean> DESCENDING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("descending").getter(getter(DescribeLogStreamsRequest::descending)).setter(setter(Builder::descending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descending").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeLogStreamsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(DescribeLogStreamsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            LOG_GROUP_IDENTIFIER_FIELD, LOG_STREAM_NAME_PREFIX_FIELD, ORDER_BY_FIELD, DESCENDING_FIELD, NEXT_TOKEN_FIELD,
            LIMIT_FIELD));

    private final String logGroupName;

    private final String logGroupIdentifier;

    private final String logStreamNamePrefix;

    private final String orderBy;

    private final Boolean descending;

    private final String nextToken;

    private final Integer limit;

    private DescribeLogStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.orderBy = builder.orderBy;
        this.descending = builder.descending;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * <note>
     * <p>
     * You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
     * </p>
     * </note>
     * 
     * @return The name of the log group.</p> <note>
     *         <p>
     *         You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
     *         </p>
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Specify either the name or ARN of the log group to view. If the log group is in a source account and you are
     * using a monitoring account, you must use the log group ARN.
     * </p>
     * <note>
     * <p>
     * You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
     * </p>
     * </note>
     * 
     * @return Specify either the name or ARN of the log group to view. If the log group is in a source account and you
     *         are using a monitoring account, you must use the log group ARN.</p> <note>
     *         <p>
     *         You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
     *         </p>
     */
    public final String logGroupIdentifier() {
        return logGroupIdentifier;
    }

    /**
     * <p>
     * The prefix to match.
     * </p>
     * <p>
     * If <code>orderBy</code> is <code>LastEventTime</code>, you cannot specify this parameter.
     * </p>
     * 
     * @return The prefix to match.</p>
     *         <p>
     *         If <code>orderBy</code> is <code>LastEventTime</code>, you cannot specify this parameter.
     */
    public final String logStreamNamePrefix() {
        return logStreamNamePrefix;
    }

    /**
     * <p>
     * If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
     * <code>LastEventTime</code>, the results are ordered by the event time. The default value is
     * <code>LogStreamName</code>.
     * </p>
     * <p>
     * If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.
     * </p>
     * <p>
     * <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in CloudWatch
     * Logs. This number is expressed as the number of milliseconds after <code>Jan 1, 1970 00:00:00 UTC</code>.
     * <code>lastEventTimestamp</code> updates on an eventual consistency basis. It typically updates in less than an
     * hour from ingestion, but in rare situations might take longer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
     *         <code>LastEventTime</code>, the results are ordered by the event time. The default value is
     *         <code>LogStreamName</code>.</p>
     *         <p>
     *         If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code>
     *         parameter.
     *         </p>
     *         <p>
     *         <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in
     *         CloudWatch Logs. This number is expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>. <code>lastEventTimestamp</code> updates on an eventual consistency
     *         basis. It typically updates in less than an hour from ingestion, but in rare situations might take
     *         longer.
     * @see OrderBy
     */
    public final OrderBy orderBy() {
        return OrderBy.fromValue(orderBy);
    }

    /**
     * <p>
     * If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
     * <code>LastEventTime</code>, the results are ordered by the event time. The default value is
     * <code>LogStreamName</code>.
     * </p>
     * <p>
     * If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.
     * </p>
     * <p>
     * <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in CloudWatch
     * Logs. This number is expressed as the number of milliseconds after <code>Jan 1, 1970 00:00:00 UTC</code>.
     * <code>lastEventTimestamp</code> updates on an eventual consistency basis. It typically updates in less than an
     * hour from ingestion, but in rare situations might take longer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
     *         <code>LastEventTime</code>, the results are ordered by the event time. The default value is
     *         <code>LogStreamName</code>.</p>
     *         <p>
     *         If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code>
     *         parameter.
     *         </p>
     *         <p>
     *         <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in
     *         CloudWatch Logs. This number is expressed as the number of milliseconds after
     *         <code>Jan 1, 1970 00:00:00 UTC</code>. <code>lastEventTimestamp</code> updates on an eventual consistency
     *         basis. It typically updates in less than an hour from ingestion, but in rare situations might take
     *         longer.
     * @see OrderBy
     */
    public final String orderByAsString() {
        return orderBy;
    }

    /**
     * <p>
     * If the value is true, results are returned in descending order. If the value is to false, results are returned in
     * ascending order. The default value is false.
     * </p>
     * 
     * @return If the value is true, results are returned in descending order. If the value is to false, results are
     *         returned in ascending order. The default value is false.
     */
    public final Boolean descending() {
        return descending;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     * </p>
     * 
     * @return The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(orderByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(descending());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogStreamsRequest)) {
            return false;
        }
        DescribeLogStreamsRequest other = (DescribeLogStreamsRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(logGroupIdentifier(), other.logGroupIdentifier())
                && Objects.equals(logStreamNamePrefix(), other.logStreamNamePrefix())
                && Objects.equals(orderByAsString(), other.orderByAsString()) && Objects.equals(descending(), other.descending())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLogStreamsRequest").add("LogGroupName", logGroupName())
                .add("LogGroupIdentifier", logGroupIdentifier()).add("LogStreamNamePrefix", logStreamNamePrefix())
                .add("OrderBy", orderByAsString()).add("Descending", descending()).add("NextToken", nextToken())
                .add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "logGroupIdentifier":
            return Optional.ofNullable(clazz.cast(logGroupIdentifier()));
        case "logStreamNamePrefix":
            return Optional.ofNullable(clazz.cast(logStreamNamePrefix()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderByAsString()));
        case "descending":
            return Optional.ofNullable(clazz.cast(descending()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLogStreamsRequest, T> g) {
        return obj -> g.apply((DescribeLogStreamsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLogStreamsRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * <note>
         * <p>
         * You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
         * </p>
         * </note>
         * 
         * @param logGroupName
         *        The name of the log group.</p> <note>
         *        <p>
         *        You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Specify either the name or ARN of the log group to view. If the log group is in a source account and you are
         * using a monitoring account, you must use the log group ARN.
         * </p>
         * <note>
         * <p>
         * You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
         * </p>
         * </note>
         * 
         * @param logGroupIdentifier
         *        Specify either the name or ARN of the log group to view. If the log group is in a source account and
         *        you are using a monitoring account, you must use the log group ARN.</p> <note>
         *        <p>
         *        You must include either <code>logGroupIdentifier</code> or <code>logGroupName</code>, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupIdentifier(String logGroupIdentifier);

        /**
         * <p>
         * The prefix to match.
         * </p>
         * <p>
         * If <code>orderBy</code> is <code>LastEventTime</code>, you cannot specify this parameter.
         * </p>
         * 
         * @param logStreamNamePrefix
         *        The prefix to match.</p>
         *        <p>
         *        If <code>orderBy</code> is <code>LastEventTime</code>, you cannot specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefix(String logStreamNamePrefix);

        /**
         * <p>
         * If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
         * <code>LastEventTime</code>, the results are ordered by the event time. The default value is
         * <code>LogStreamName</code>.
         * </p>
         * <p>
         * If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.
         * </p>
         * <p>
         * <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in
         * CloudWatch Logs. This number is expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>. <code>lastEventTimestamp</code> updates on an eventual consistency
         * basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.
         * </p>
         * 
         * @param orderBy
         *        If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value
         *        is <code>LastEventTime</code>, the results are ordered by the event time. The default value is
         *        <code>LogStreamName</code>.</p>
         *        <p>
         *        If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code>
         *        parameter.
         *        </p>
         *        <p>
         *        <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in
         *        CloudWatch Logs. This number is expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>. <code>lastEventTimestamp</code> updates on an eventual
         *        consistency basis. It typically updates in less than an hour from ingestion, but in rare situations
         *        might take longer.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(String orderBy);

        /**
         * <p>
         * If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
         * <code>LastEventTime</code>, the results are ordered by the event time. The default value is
         * <code>LogStreamName</code>.
         * </p>
         * <p>
         * If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.
         * </p>
         * <p>
         * <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in
         * CloudWatch Logs. This number is expressed as the number of milliseconds after
         * <code>Jan 1, 1970 00:00:00 UTC</code>. <code>lastEventTimestamp</code> updates on an eventual consistency
         * basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.
         * </p>
         * 
         * @param orderBy
         *        If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value
         *        is <code>LastEventTime</code>, the results are ordered by the event time. The default value is
         *        <code>LogStreamName</code>.</p>
         *        <p>
         *        If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code>
         *        parameter.
         *        </p>
         *        <p>
         *        <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in
         *        CloudWatch Logs. This number is expressed as the number of milliseconds after
         *        <code>Jan 1, 1970 00:00:00 UTC</code>. <code>lastEventTimestamp</code> updates on an eventual
         *        consistency basis. It typically updates in less than an hour from ingestion, but in rare situations
         *        might take longer.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(OrderBy orderBy);

        /**
         * <p>
         * If the value is true, results are returned in descending order. If the value is to false, results are
         * returned in ascending order. The default value is false.
         * </p>
         * 
         * @param descending
         *        If the value is true, results are returned in descending order. If the value is to false, results are
         *        returned in ascending order. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descending(Boolean descending);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * </p>
         * 
         * @param limit
         *        The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String logGroupIdentifier;

        private String logStreamNamePrefix;

        private String orderBy;

        private Boolean descending;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogStreamsRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            logGroupIdentifier(model.logGroupIdentifier);
            logStreamNamePrefix(model.logStreamNamePrefix);
            orderBy(model.orderBy);
            descending(model.descending);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogGroupIdentifier() {
            return logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final String getOrderBy() {
            return orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        public final Boolean getDescending() {
            return descending;
        }

        public final void setDescending(Boolean descending) {
            this.descending = descending;
        }

        @Override
        public final Builder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLogStreamsRequest build() {
            return new DescribeLogStreamsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
