/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.CloudTrailServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtrail.internal.CloudTrailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudtrail.model.AccountHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AccountRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.CannotDelegateManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelExistsForEdsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailAccessNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailInvalidClientTokenIdException;
import software.amazon.awssdk.services.cloudtrail.model.CloudWatchLogsDeliveryUnavailableException;
import software.amazon.awssdk.services.cloudtrail.model.ConflictException;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DelegatedAdminAccountLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreTerminationProtectedException;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusResponse;
import software.amazon.awssdk.services.cloudtrail.model.ImportNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveEventDataStoreException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveQueryException;
import software.amazon.awssdk.services.cloudtrail.model.InsightNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientDependencyServiceAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientEncryptionPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientSnsTopicPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsLogGroupArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsRoleArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidDateRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidHomeRegionException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidImportSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidInsightSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidKmsKeyIdException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidLookupAttributesException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatementException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3PrefixException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSnsTopicNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTagParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTrailNameException;
import software.amazon.awssdk.services.cloudtrail.model.KmsException;
import software.amazon.awssdk.services.cloudtrail.model.KmsKeyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.MaxConcurrentQueriesException;
import software.amazon.awssdk.services.cloudtrail.model.MaximumNumberOfTrailsExceededException;
import software.amazon.awssdk.services.cloudtrail.model.NoManagementAccountSlrExistsException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationMasterAccountException;
import software.amazon.awssdk.services.cloudtrail.model.OperationNotPermittedException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationsNotInUseException;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.QueryIdNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ResourceArnNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.S3BucketDoesNotExistException;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.TagsLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ThrottlingException;
import software.amazon.awssdk.services.cloudtrail.model.TrailAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotProvidedException;
import software.amazon.awssdk.services.cloudtrail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CancelQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeregisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListEventDataStoresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportFailuresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.LookupEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RegisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RestoreEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateTrailRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudTrailClient
implements CloudTrailClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudTrailClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final CloudTrailServiceClientConfiguration serviceClientConfiguration;

    protected DefaultCloudTrailClient(CloudTrailServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws ResourceNotFoundException, CloudTrailArnInvalidException, EventDataStoreArnInvalidException, ChannelArnInvalidException, ResourceTypeNotSupportedException, TagsLimitExceededException, InvalidTrailNameException, InvalidTagParameterException, InactiveEventDataStoreException, EventDataStoreNotFoundException, ChannelNotFoundException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, ConflictException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            AddTagsResponse addTagsResponse = (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$addTags$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InactiveQueryException, InvalidParameterException, QueryIdNotFoundException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, ConflictException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, cancelQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelQuery");
            CancelQueryResponse cancelQueryResponse = (CancelQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$cancelQuery$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws ChannelMaxLimitExceededException, InvalidSourceException, ChannelAlreadyExistsException, EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreCategoryException, InactiveEventDataStoreException, InvalidParameterException, InvalidTagParameterException, TagsLimitExceededException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, createChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateChannel");
            CreateChannelResponse createChannelResponse = (CreateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$createChannel$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventDataStoreResponse createEventDataStore(CreateEventDataStoreRequest createEventDataStoreRequest) throws EventDataStoreAlreadyExistsException, EventDataStoreMaxLimitExceededException, InvalidEventSelectorsException, InvalidParameterException, InvalidTagParameterException, OperationNotPermittedException, UnsupportedOperationException, ConflictException, InsufficientEncryptionPolicyException, InvalidKmsKeyIdException, KmsKeyNotFoundException, KmsException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException, OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventDataStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, createEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventDataStore");
            CreateEventDataStoreResponse createEventDataStoreResponse = (CreateEventDataStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEventDataStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventDataStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$createEventDataStore$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrailResponse createTrail(CreateTrailRequest createTrailRequest) throws MaximumNumberOfTrailsExceededException, TrailAlreadyExistsException, S3BucketDoesNotExistException, InsufficientS3BucketPolicyException, InsufficientSnsTopicPolicyException, InsufficientEncryptionPolicyException, InvalidS3BucketNameException, InvalidS3PrefixException, InvalidSnsTopicNameException, InvalidKmsKeyIdException, InvalidTrailNameException, TrailNotProvidedException, TagsLimitExceededException, InvalidParameterCombinationException, KmsKeyNotFoundException, KmsException, InvalidCloudWatchLogsLogGroupArnException, InvalidCloudWatchLogsRoleArnException, CloudWatchLogsDeliveryUnavailableException, InvalidTagParameterException, UnsupportedOperationException, OperationNotPermittedException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException, OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, NoManagementAccountSlrExistsException, CloudTrailInvalidClientTokenIdException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, createTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrail");
            CreateTrailResponse createTrailResponse = (CreateTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTrailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTrailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$createTrail$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws ChannelArnInvalidException, ChannelNotFoundException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannel");
            DeleteChannelResponse deleteChannelResponse = (DeleteChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteChannel$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventDataStoreResponse deleteEventDataStore(DeleteEventDataStoreRequest deleteEventDataStoreRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, EventDataStoreTerminationProtectedException, EventDataStoreHasOngoingImportException, InactiveEventDataStoreException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, ChannelExistsForEdsException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventDataStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventDataStore");
            DeleteEventDataStoreResponse deleteEventDataStoreResponse = (DeleteEventDataStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEventDataStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventDataStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteEventDataStore$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws ResourceArnNotValidException, ResourceNotFoundException, ResourcePolicyNotFoundException, ResourceTypeNotSupportedException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteResourcePolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrailResponse deleteTrail(DeleteTrailRequest deleteTrailRequest) throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, ConflictException, ThrottlingException, InvalidHomeRegionException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrail");
            DeleteTrailResponse deleteTrailResponse = (DeleteTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTrailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTrailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteTrail$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterOrganizationDelegatedAdminResponse deregisterOrganizationDelegatedAdmin(DeregisterOrganizationDelegatedAdminRequest deregisterOrganizationDelegatedAdminRequest) throws AccountNotFoundException, AccountNotRegisteredException, CloudTrailAccessNotEnabledException, ConflictException, InsufficientDependencyServiceAccessPermissionException, InvalidParameterException, NotOrganizationManagementAccountException, OrganizationNotInAllFeaturesModeException, OrganizationsNotInUseException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterOrganizationDelegatedAdminResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterOrganizationDelegatedAdminRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deregisterOrganizationDelegatedAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterOrganizationDelegatedAdmin");
            DeregisterOrganizationDelegatedAdminResponse deregisterOrganizationDelegatedAdminResponse = (DeregisterOrganizationDelegatedAdminResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterOrganizationDelegatedAdmin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterOrganizationDelegatedAdminRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterOrganizationDelegatedAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterOrganizationDelegatedAdminResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deregisterOrganizationDelegatedAdmin$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeQueryResponse describeQuery(DescribeQueryRequest describeQueryRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InvalidParameterException, QueryIdNotFoundException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, describeQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQuery");
            DescribeQueryResponse describeQueryResponse = (DescribeQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$describeQuery$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrailsResponse describeTrails(DescribeTrailsRequest describeTrailsRequest) throws UnsupportedOperationException, OperationNotPermittedException, InvalidTrailNameException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, describeTrailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrails");
            DescribeTrailsResponse describeTrailsResponse = (DescribeTrailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTrailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$describeTrails$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChannelResponse getChannel(GetChannelRequest getChannelRequest) throws ChannelArnInvalidException, ChannelNotFoundException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChannel");
            GetChannelResponse getChannelResponse = (GetChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getChannel$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventDataStoreResponse getEventDataStore(GetEventDataStoreRequest getEventDataStoreRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventDataStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventDataStore");
            GetEventDataStoreResponse getEventDataStoreResponse = (GetEventDataStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEventDataStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEventDataStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getEventDataStore$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventSelectorsResponse getEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, UnsupportedOperationException, OperationNotPermittedException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventSelectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventSelectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getEventSelectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventSelectors");
            GetEventSelectorsResponse getEventSelectorsResponse = (GetEventSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventSelectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEventSelectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEventSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEventSelectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getEventSelectors$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetImportResponse getImport(GetImportRequest getImportRequest) throws ImportNotFoundException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImport");
            GetImportResponse getImportResponse = (GetImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getImportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getImportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getImport$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInsightSelectorsResponse getInsightSelectors(GetInsightSelectorsRequest getInsightSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, UnsupportedOperationException, OperationNotPermittedException, InsightNotEnabledException, NoManagementAccountSlrExistsException, ThrottlingException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightSelectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInsightSelectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getInsightSelectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsightSelectors");
            GetInsightSelectorsResponse getInsightSelectorsResponse = (GetInsightSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightSelectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInsightSelectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInsightSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInsightSelectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getInsightSelectors$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InvalidMaxResultsException, InvalidNextTokenException, InvalidParameterException, QueryIdNotFoundException, InsufficientEncryptionPolicyException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQueryResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryResults");
            GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getQueryResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getQueryResults$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws ResourceArnNotValidException, ResourceNotFoundException, ResourcePolicyNotFoundException, ResourceTypeNotSupportedException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getResourcePolicy$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrailResponse getTrail(GetTrailRequest getTrailRequest) throws CloudTrailArnInvalidException, TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrail");
            GetTrailResponse getTrailResponse = (GetTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTrailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTrailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getTrail$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrailStatusResponse getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) throws CloudTrailArnInvalidException, TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrailStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTrailStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getTrailStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrailStatus");
            GetTrailStatusResponse getTrailStatusResponse = (GetTrailStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrailStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTrailStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTrailStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTrailStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getTrailStatus$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws InvalidNextTokenException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChannels");
            ListChannelsResponse listChannelsResponse = (ListChannelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChannelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChannelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listChannels$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventDataStoresResponse listEventDataStores(ListEventDataStoresRequest listEventDataStoresRequest) throws InvalidMaxResultsException, InvalidNextTokenException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventDataStoresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventDataStoresRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listEventDataStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventDataStores");
            ListEventDataStoresResponse listEventDataStoresResponse = (ListEventDataStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventDataStores").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEventDataStoresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventDataStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventDataStoresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listEventDataStores$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportFailuresResponse listImportFailures(ListImportFailuresRequest listImportFailuresRequest) throws InvalidNextTokenException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportFailuresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportFailuresRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listImportFailuresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImportFailures");
            ListImportFailuresResponse listImportFailuresResponse = (ListImportFailuresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImportFailures").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listImportFailuresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportFailuresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportFailuresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listImportFailures$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws EventDataStoreArnInvalidException, InvalidNextTokenException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImports");
            ListImportsResponse listImportsResponse = (ListImportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listImportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listImports$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidTimeRangeException, UnsupportedOperationException, OperationNotPermittedException, InvalidTokenException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPublicKeysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPublicKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listPublicKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPublicKeys");
            ListPublicKeysResponse listPublicKeysResponse = (ListPublicKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPublicKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPublicKeysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPublicKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPublicKeysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listPublicKeys$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQueriesResponse listQueries(ListQueriesRequest listQueriesRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InvalidDateRangeException, InvalidMaxResultsException, InvalidNextTokenException, InvalidParameterException, InvalidQueryStatusException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQueriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listQueriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listQueriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQueries");
            ListQueriesResponse listQueriesResponse = (ListQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listQueriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listQueriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listQueries$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, CloudTrailArnInvalidException, EventDataStoreArnInvalidException, ChannelArnInvalidException, ResourceTypeNotSupportedException, InvalidTrailNameException, InactiveEventDataStoreException, EventDataStoreNotFoundException, UnsupportedOperationException, OperationNotPermittedException, InvalidTokenException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listTags$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrailsResponse listTrails(ListTrailsRequest listTrailsRequest) throws UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTrailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTrailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listTrailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrails");
            ListTrailsResponse listTrailsResponse = (ListTrailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTrailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTrailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTrailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listTrails$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupEventsResponse lookupEvents(LookupEventsRequest lookupEventsRequest) throws InvalidLookupAttributesException, InvalidTimeRangeException, InvalidMaxResultsException, InvalidNextTokenException, InvalidEventCategoryException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LookupEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)lookupEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, lookupEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LookupEvents");
            LookupEventsResponse lookupEventsResponse = (LookupEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LookupEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)lookupEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new LookupEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return lookupEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$lookupEvents$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEventSelectorsResponse putEventSelectors(PutEventSelectorsRequest putEventSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, InvalidHomeRegionException, InvalidEventSelectorsException, ConflictException, ThrottlingException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventSelectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEventSelectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, putEventSelectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEventSelectors");
            PutEventSelectorsResponse putEventSelectorsResponse = (PutEventSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEventSelectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEventSelectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEventSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEventSelectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$putEventSelectors$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutInsightSelectorsResponse putInsightSelectors(PutInsightSelectorsRequest putInsightSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, InvalidHomeRegionException, InvalidInsightSelectorsException, InsufficientS3BucketPolicyException, InsufficientEncryptionPolicyException, S3BucketDoesNotExistException, KmsException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, ThrottlingException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutInsightSelectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putInsightSelectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, putInsightSelectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutInsightSelectors");
            PutInsightSelectorsResponse putInsightSelectorsResponse = (PutInsightSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutInsightSelectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putInsightSelectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutInsightSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putInsightSelectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$putInsightSelectors$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws ResourceArnNotValidException, ResourcePolicyNotValidException, ResourceNotFoundException, ResourceTypeNotSupportedException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$putResourcePolicy$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterOrganizationDelegatedAdminResponse registerOrganizationDelegatedAdmin(RegisterOrganizationDelegatedAdminRequest registerOrganizationDelegatedAdminRequest) throws AccountRegisteredException, AccountNotFoundException, InsufficientDependencyServiceAccessPermissionException, InvalidParameterException, CannotDelegateManagementAccountException, CloudTrailAccessNotEnabledException, ConflictException, DelegatedAdminAccountLimitExceededException, NotOrganizationManagementAccountException, OrganizationNotInAllFeaturesModeException, OrganizationsNotInUseException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterOrganizationDelegatedAdminResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerOrganizationDelegatedAdminRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, registerOrganizationDelegatedAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterOrganizationDelegatedAdmin");
            RegisterOrganizationDelegatedAdminResponse registerOrganizationDelegatedAdminResponse = (RegisterOrganizationDelegatedAdminResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterOrganizationDelegatedAdmin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerOrganizationDelegatedAdminRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterOrganizationDelegatedAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerOrganizationDelegatedAdminResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$registerOrganizationDelegatedAdmin$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws ResourceNotFoundException, CloudTrailArnInvalidException, EventDataStoreArnInvalidException, ChannelArnInvalidException, ResourceTypeNotSupportedException, InvalidTrailNameException, InvalidTagParameterException, InactiveEventDataStoreException, EventDataStoreNotFoundException, ChannelNotFoundException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, removeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTags");
            RemoveTagsResponse removeTagsResponse = (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$removeTags$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreEventDataStoreResponse restoreEventDataStore(RestoreEventDataStoreRequest restoreEventDataStoreRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, EventDataStoreMaxLimitExceededException, InvalidEventDataStoreStatusException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, OrganizationsNotInUseException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, OrganizationNotInAllFeaturesModeException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreEventDataStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, restoreEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreEventDataStore");
            RestoreEventDataStoreResponse restoreEventDataStoreResponse = (RestoreEventDataStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreEventDataStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreEventDataStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$restoreEventDataStore$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartEventDataStoreIngestionResponse startEventDataStoreIngestion(StartEventDataStoreIngestionRequest startEventDataStoreIngestionRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreStatusException, InvalidParameterException, InvalidEventDataStoreCategoryException, OperationNotPermittedException, UnsupportedOperationException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEventDataStoreIngestionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEventDataStoreIngestionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, startEventDataStoreIngestionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEventDataStoreIngestion");
            StartEventDataStoreIngestionResponse startEventDataStoreIngestionResponse = (StartEventDataStoreIngestionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEventDataStoreIngestion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startEventDataStoreIngestionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartEventDataStoreIngestionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startEventDataStoreIngestionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$startEventDataStoreIngestion$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartImportResponse startImport(StartImportRequest startImportRequest) throws AccountHasOngoingImportException, EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreStatusException, InvalidEventDataStoreCategoryException, InactiveEventDataStoreException, InvalidImportSourceException, ImportNotFoundException, InvalidParameterException, InsufficientEncryptionPolicyException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartImportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, startImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartImport");
            StartImportResponse startImportResponse = (StartImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startImportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startImportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$startImport$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLoggingResponse startLogging(StartLoggingRequest startLoggingRequest) throws CloudTrailArnInvalidException, ConflictException, ThrottlingException, TrailNotFoundException, InvalidTrailNameException, InvalidHomeRegionException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartLoggingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, startLoggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartLogging");
            StartLoggingResponse startLoggingResponse = (StartLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLogging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startLoggingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartLoggingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startLoggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$startLogging$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartQueryResponse startQuery(StartQueryRequest startQueryRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InvalidParameterException, InvalidQueryStatementException, MaxConcurrentQueriesException, InsufficientEncryptionPolicyException, InvalidS3PrefixException, InvalidS3BucketNameException, InsufficientS3BucketPolicyException, S3BucketDoesNotExistException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, startQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartQuery");
            StartQueryResponse startQueryResponse = (StartQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$startQuery$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopEventDataStoreIngestionResponse stopEventDataStoreIngestion(StopEventDataStoreIngestionRequest stopEventDataStoreIngestionRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreStatusException, InvalidParameterException, InvalidEventDataStoreCategoryException, OperationNotPermittedException, UnsupportedOperationException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEventDataStoreIngestionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopEventDataStoreIngestionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, stopEventDataStoreIngestionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopEventDataStoreIngestion");
            StopEventDataStoreIngestionResponse stopEventDataStoreIngestionResponse = (StopEventDataStoreIngestionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEventDataStoreIngestion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopEventDataStoreIngestionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopEventDataStoreIngestionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopEventDataStoreIngestionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$stopEventDataStoreIngestion$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopImportResponse stopImport(StopImportRequest stopImportRequest) throws ImportNotFoundException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopImportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, stopImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopImport");
            StopImportResponse stopImportResponse = (StopImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopImportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopImportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$stopImport$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopLoggingResponse stopLogging(StopLoggingRequest stopLoggingRequest) throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, ConflictException, ThrottlingException, InvalidHomeRegionException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopLoggingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, stopLoggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopLogging");
            StopLoggingResponse stopLoggingResponse = (StopLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopLogging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopLoggingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopLoggingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopLoggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$stopLogging$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws ChannelArnInvalidException, ChannelNotFoundException, ChannelAlreadyExistsException, EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreCategoryException, InactiveEventDataStoreException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChannelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, updateChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateChannel");
            UpdateChannelResponse updateChannelResponse = (UpdateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$updateChannel$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEventDataStoreResponse updateEventDataStore(UpdateEventDataStoreRequest updateEventDataStoreRequest) throws EventDataStoreAlreadyExistsException, EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventSelectorsException, EventDataStoreHasOngoingImportException, InactiveEventDataStoreException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, InsufficientEncryptionPolicyException, InvalidKmsKeyIdException, KmsKeyNotFoundException, KmsException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, OrganizationsNotInUseException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, OrganizationNotInAllFeaturesModeException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEventDataStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, updateEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEventDataStore");
            UpdateEventDataStoreResponse updateEventDataStoreResponse = (UpdateEventDataStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateEventDataStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEventDataStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$updateEventDataStore$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrailResponse updateTrail(UpdateTrailRequest updateTrailRequest) throws S3BucketDoesNotExistException, InsufficientS3BucketPolicyException, InsufficientSnsTopicPolicyException, InsufficientEncryptionPolicyException, TrailNotFoundException, InvalidS3BucketNameException, InvalidS3PrefixException, InvalidSnsTopicNameException, InvalidKmsKeyIdException, InvalidTrailNameException, TrailNotProvidedException, InvalidEventSelectorsException, CloudTrailArnInvalidException, ConflictException, ThrottlingException, InvalidParameterCombinationException, InvalidHomeRegionException, KmsKeyNotFoundException, KmsException, InvalidCloudWatchLogsLogGroupArnException, InvalidCloudWatchLogsRoleArnException, CloudWatchLogsDeliveryUnavailableException, UnsupportedOperationException, OperationNotPermittedException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, OrganizationsNotInUseException, NotOrganizationMasterAccountException, OrganizationNotInAllFeaturesModeException, NoManagementAccountSlrExistsException, CloudTrailInvalidClientTokenIdException, InvalidParameterException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTrailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, updateTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrail");
            UpdateTrailResponse updateTrailResponse = (UpdateTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTrailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTrailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$updateTrail$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "cloudtrail";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        CloudTrailServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = CloudTrailServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudTrailException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").exceptionBuilderSupplier(ResourceArnNotValidException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSourceException").exceptionBuilderSupplier(InvalidSourceException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").exceptionBuilderSupplier(InvalidLookupAttributesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").exceptionBuilderSupplier(OrganizationsNotInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").exceptionBuilderSupplier(ChannelExistsForEdsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").exceptionBuilderSupplier(InvalidEventSelectorsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").exceptionBuilderSupplier(AccountNotRegisteredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").exceptionBuilderSupplier(InvalidTrailNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").exceptionBuilderSupplier(InvalidImportSourceException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").exceptionBuilderSupplier(InvalidS3PrefixException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").exceptionBuilderSupplier(InvalidHomeRegionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").exceptionBuilderSupplier(ChannelArnInvalidException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").exceptionBuilderSupplier(QueryIdNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").exceptionBuilderSupplier(InactiveEventDataStoreException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").exceptionBuilderSupplier(TrailNotProvidedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").exceptionBuilderSupplier(InvalidQueryStatusException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").exceptionBuilderSupplier(InvalidEventCategoryException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KmsException").exceptionBuilderSupplier(KmsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").exceptionBuilderSupplier(TagsLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").exceptionBuilderSupplier(KmsKeyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountRegisteredException").exceptionBuilderSupplier(AccountRegisteredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").exceptionBuilderSupplier(AccountHasOngoingImportException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTokenException").exceptionBuilderSupplier(InvalidTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").exceptionBuilderSupplier(InvalidQueryStatementException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").exceptionBuilderSupplier(InvalidTimeRangeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImportNotFoundException").exceptionBuilderSupplier(ImportNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountNotFoundException").exceptionBuilderSupplier(AccountNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").exceptionBuilderSupplier(InvalidMaxResultsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").exceptionBuilderSupplier(InvalidS3BucketNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InactiveQueryException").exceptionBuilderSupplier(InactiveQueryException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").exceptionBuilderSupplier(InvalidTagParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrailNotFoundException").exceptionBuilderSupplier(TrailNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").exceptionBuilderSupplier(InvalidDateRangeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").exceptionBuilderSupplier(ChannelNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").exceptionBuilderSupplier(TrailAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").exceptionBuilderSupplier(InsightNotEnabledException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final CloudTrailServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTrail$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEventDataStore$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateChannel$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopLogging$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopImport$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopEventDataStoreIngestion$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startQuery$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startLogging$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startImport$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEventDataStoreIngestion$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreEventDataStore$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTags$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerOrganizationDelegatedAdmin$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putInsightSelectors$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEventSelectors$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$lookupEvents$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrails$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listQueries$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPublicKeys$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImports$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImportFailures$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventDataStores$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChannels$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTrailStatus$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTrail$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryResults$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInsightSelectors$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getImport$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEventSelectors$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEventDataStore$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChannel$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTrails$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeQuery$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterOrganizationDelegatedAdmin$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTrail$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventDataStore$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteChannel$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTrail$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEventDataStore$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createChannel$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelQuery$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTags$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

