/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClientBuilder;
import software.amazon.awssdk.services.cloudtrail.CloudTrailServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtrail.DefaultCloudTrailBaseClientBuilder;
import software.amazon.awssdk.services.cloudtrail.DefaultCloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.endpoints.CloudTrailEndpointProvider;

@SdkInternalApi
final class DefaultCloudTrailClientBuilder
extends DefaultCloudTrailBaseClientBuilder<CloudTrailClientBuilder, CloudTrailClient>
implements CloudTrailClientBuilder {
    DefaultCloudTrailClientBuilder() {
    }

    @Override
    public DefaultCloudTrailClientBuilder endpointProvider(CloudTrailEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudTrailClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudTrailClientBuilder.validateClientOptions(clientConfiguration);
        CloudTrailServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudTrailClient client = new DefaultCloudTrailClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudTrailServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudTrailServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

