/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single selector statement in an advanced event selector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedFieldSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<AdvancedFieldSelector.Builder, AdvancedFieldSelector> {
    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Field")
            .getter(getter(AdvancedFieldSelector::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()).build();

    private static final SdkField<List<String>> EQUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Equals")
            .getter(getter(AdvancedFieldSelector::equalsValue))
            .setter(setter(Builder::equalsValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STARTS_WITH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StartsWith")
            .getter(getter(AdvancedFieldSelector::startsWith))
            .setter(setter(Builder::startsWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartsWith").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENDS_WITH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EndsWith")
            .getter(getter(AdvancedFieldSelector::endsWith))
            .setter(setter(Builder::endsWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndsWith").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_EQUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotEquals")
            .getter(getter(AdvancedFieldSelector::notEquals))
            .setter(setter(Builder::notEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_STARTS_WITH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotStartsWith")
            .getter(getter(AdvancedFieldSelector::notStartsWith))
            .setter(setter(Builder::notStartsWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotStartsWith").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_ENDS_WITH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotEndsWith")
            .getter(getter(AdvancedFieldSelector::notEndsWith))
            .setter(setter(Builder::notEndsWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotEndsWith").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, EQUALS_FIELD,
            STARTS_WITH_FIELD, ENDS_WITH_FIELD, NOT_EQUALS_FIELD, NOT_STARTS_WITH_FIELD, NOT_ENDS_WITH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String field;

    private final List<String> equals;

    private final List<String> startsWith;

    private final List<String> endsWith;

    private final List<String> notEquals;

    private final List<String> notStartsWith;

    private final List<String> notEndsWith;

    private AdvancedFieldSelector(BuilderImpl builder) {
        this.field = builder.field;
        this.equals = builder.equals;
        this.startsWith = builder.startsWith;
        this.endsWith = builder.endsWith;
        this.notEquals = builder.notEquals;
        this.notStartsWith = builder.notStartsWith;
        this.notEndsWith = builder.notEndsWith;
    }

    /**
     * <p>
     * A field in a CloudTrail event record on which to filter events to be logged. For event data stores for Config
     * configuration items, Audit Manager evidence, or non-Amazon Web Services events, the field is used only for
     * selecting events as filtering is not supported.
     * </p>
     * <p>
     * For CloudTrail event records, supported fields include <code>readOnly</code>, <code>eventCategory</code>,
     * <code>eventSource</code> (for management events), <code>eventName</code>, <code>resources.type</code>, and
     * <code>resources.ARN</code>.
     * </p>
     * <p>
     * For event data stores for Config configuration items, Audit Manager evidence, or non-Amazon Web Services events,
     * the only supported field is <code>eventCategory</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or
     * <code>false</code>. If you do not add this field, CloudTrail logs both <code>read</code> and <code>write</code>
     * events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only
     * <code>write</code> events.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to
     * <code>NotEquals</code> <code>kms.amazonaws.com</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event
     * logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have multiple
     * values for this ﬁeld, separated by commas.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>eventCategory</code> </b> - This is required and must be set to <code>Equals</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For CloudTrail event records, the value must be <code>Management</code> or <code>Data</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Config configuration items, the value must be <code>ConfigurationItem</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Audit Manager evidence, the value must be <code>Evidence</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For non-Amazon Web Services events, the value must be <code>ActivityAuditLog</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>resources.type</code> </b> - This ﬁeld is required for CloudTrail data events.
     * <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Lambda::Function</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3::Object</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::CloudTrail::Channel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::CodeWhisperer::Profile</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Cognito::IdentityPool</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::DynamoDB::Stream</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EC2::Snapshot</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::EMRWAL::Workspace</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::FinSpace::Environment</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::Glue::Table</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::GuardDuty::Detector</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::KendraRanking::ExecutionPlan</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::ManagedBlockchain::Node</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::SageMaker::ExperimentTrialComponent</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::SageMaker::FeatureGroup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3::AccessPoint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3ObjectLambda::AccessPoint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS::S3Outposts::Object</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource
     * type, add another selector.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if you use
     * <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid resource of the
     * type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals
     * <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To log all data events for all
     * objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the
     * matching value.
     * </p>
     * <p>
     * The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols
     * (&lt;&gt;) with resource-specific information.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/&lt;object_path&gt;/</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to <code>Equals</code> or
     * <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to <code>Equals</code> or
     * <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:lambda:&lt;region&gt;:&lt;account_ID&gt;:function:&lt;function_name&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When resources.type equals <code>AWS::CloudTrail::Channel</code>, and the operator is set to <code>Equals</code>
     * or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:cloudtrail:&lt;region&gt;:&lt;account_ID&gt;:channel/&lt;channel_UUID&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When resources.type equals <code>AWS::CodeWhisperer::Profile</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:codewhisperer:&lt;region&gt;:&lt;account_ID&gt;:profile/&lt;profile_ID&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When resources.type equals <code>AWS::Cognito::IdentityPool</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:cognito-identity:&lt;region&gt;:&lt;account_ID&gt;:identitypool/&lt;identity_pool_ID&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;/stream/&lt;date_time&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:ec2:&lt;region&gt;::snapshot/&lt;snapshot_ID&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::EMRWAL::Workspace</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:emrwal:&lt;region&gt;::workspace/&lt;workspace_name&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::FinSpace::Environment</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:finspace:&lt;region&gt;:&lt;account_ID&gt;:environment/&lt;environment_ID&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:glue:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;database_name&gt;/&lt;table_name&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::GuardDuty::Detector</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:guardduty:&lt;region&gt;:&lt;account_ID&gt;:detector/&lt;detector_ID&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::KendraRanking::ExecutionPlan</code>, and the operator is set
     * to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:kendra-ranking:&lt;region&gt;:&lt;account_ID&gt;:rescore-execution-plan/&lt;rescore_execution_plan_ID&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:managedblockchain:&lt;region&gt;:&lt;account_ID&gt;:nodes/&lt;node_ID&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::SageMaker::ExperimentTrialComponent</code>, and the operator
     * is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:experiment-trial-component/&lt;experiment_trial_component_name&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::SageMaker::FeatureGroup</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:feature-group/&lt;feature_group_name&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log events on
     * all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object
     * path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;/object/&lt;object_path&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:s3-object-lambda:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to
     * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:&lt;partition&gt;:s3-outposts:&lt;region&gt;:&lt;account_ID&gt;:&lt;object_path&gt;</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return A field in a CloudTrail event record on which to filter events to be logged. For event data stores for
     *         Config configuration items, Audit Manager evidence, or non-Amazon Web Services events, the field is used
     *         only for selecting events as filtering is not supported. </p>
     *         <p>
     *         For CloudTrail event records, supported fields include <code>readOnly</code>, <code>eventCategory</code>,
     *         <code>eventSource</code> (for management events), <code>eventName</code>, <code>resources.type</code>,
     *         and <code>resources.ARN</code>.
     *         </p>
     *         <p>
     *         For event data stores for Config configuration items, Audit Manager evidence, or non-Amazon Web Services
     *         events, the only supported field is <code>eventCategory</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code>
     *         or <code>false</code>. If you do not add this field, CloudTrail logs both <code>read</code> and
     *         <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of
     *         <code>false</code> logs only <code>write</code> events.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to
     *         <code>NotEquals</code> <code>kms.amazonaws.com</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data
     *         event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have
     *         multiple values for this ﬁeld, separated by commas.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>eventCategory</code> </b> - This is required and must be set to <code>Equals</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For CloudTrail event records, the value must be <code>Management</code> or <code>Data</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Config configuration items, the value must be <code>ConfigurationItem</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Audit Manager evidence, the value must be <code>Evidence</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For non-Amazon Web Services events, the value must be <code>ActivityAuditLog</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>resources.type</code> </b> - This ﬁeld is required for CloudTrail data events.
     *         <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of
     *         the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::Table</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::Lambda::Function</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::S3::Object</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::CloudTrail::Channel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::CodeWhisperer::Profile</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::Cognito::IdentityPool</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::DynamoDB::Stream</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EC2::Snapshot</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::EMRWAL::Workspace</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::FinSpace::Environment</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::Glue::Table</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::GuardDuty::Detector</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::KendraRanking::ExecutionPlan</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::ManagedBlockchain::Node</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::SageMaker::ExperimentTrialComponent</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::SageMaker::FeatureGroup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::S3::AccessPoint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::S3ObjectLambda::AccessPoint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS::S3Outposts::Object</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one
     *         resource type, add another selector.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if
     *         you use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid
     *         resource of the type you've speciﬁed in the template as the value of resources.type. For example, if
     *         resources.type equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To
     *         log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator,
     *         and include only the bucket ARN as the matching value.
     *         </p>
     *         <p>
     *         The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than
     *         symbols (&lt;&gt;) with resource-specific information.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/&lt;object_path&gt;/</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:lambda:&lt;region&gt;:&lt;account_ID&gt;:function:&lt;function_name&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When resources.type equals <code>AWS::CloudTrail::Channel</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:cloudtrail:&lt;region&gt;:&lt;account_ID&gt;:channel/&lt;channel_UUID&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When resources.type equals <code>AWS::CodeWhisperer::Profile</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:codewhisperer:&lt;region&gt;:&lt;account_ID&gt;:profile/&lt;profile_ID&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When resources.type equals <code>AWS::Cognito::IdentityPool</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:cognito-identity:&lt;region&gt;:&lt;account_ID&gt;:identitypool/&lt;identity_pool_ID&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;/stream/&lt;date_time&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:ec2:&lt;region&gt;::snapshot/&lt;snapshot_ID&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::EMRWAL::Workspace</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:emrwal:&lt;region&gt;::workspace/&lt;workspace_name&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::FinSpace::Environment</code>, and the operator is set
     *         to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:finspace:&lt;region&gt;:&lt;account_ID&gt;:environment/&lt;environment_ID&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:glue:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;database_name&gt;/&lt;table_name&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::GuardDuty::Detector</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:guardduty:&lt;region&gt;:&lt;account_ID&gt;:detector/&lt;detector_ID&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::KendraRanking::ExecutionPlan</code>, and the operator
     *         is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:kendra-ranking:&lt;region&gt;:&lt;account_ID&gt;:rescore-execution-plan/&lt;rescore_execution_plan_ID&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is
     *         set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:managedblockchain:&lt;region&gt;:&lt;account_ID&gt;:nodes/&lt;node_ID&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::SageMaker::ExperimentTrialComponent</code>, and the
     *         operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following
     *         format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:experiment-trial-component/&lt;experiment_trial_component_name&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::SageMaker::FeatureGroup</code>, and the operator is
     *         set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:feature-group/&lt;feature_group_name&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log
     *         events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t
     *         include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;/object/&lt;object_path&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator
     *         is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:s3-object-lambda:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to
     *         <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:&lt;partition&gt;:s3-outposts:&lt;region&gt;:&lt;account_ID&gt;:&lt;object_path&gt;</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String field() {
        return field;
    }

    /**
     * For responses, this returns true if the service returned a value for the Equals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEqualsValue() {
        return equals != null && !(equals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An operator that includes events that match the exact value of the event record field specified as the value of
     * <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>,
     * <code>eventCategory</code>, and <code>resources.type</code> fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEqualsValue} method.
     * </p>
     * 
     * @return An operator that includes events that match the exact value of the event record field specified as the
     *         value of <code>Field</code>. This is the only valid operator that you can use with the
     *         <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.
     */
    public final List<String> equalsValue() {
        return equals;
    }

    /**
     * For responses, this returns true if the service returned a value for the StartsWith property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStartsWith() {
        return startsWith != null && !(startsWith instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An operator that includes events that match the first few characters of the event record field specified as the
     * value of <code>Field</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStartsWith} method.
     * </p>
     * 
     * @return An operator that includes events that match the first few characters of the event record field specified
     *         as the value of <code>Field</code>.
     */
    public final List<String> startsWith() {
        return startsWith;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndsWith property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndsWith() {
        return endsWith != null && !(endsWith instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An operator that includes events that match the last few characters of the event record field specified as the
     * value of <code>Field</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndsWith} method.
     * </p>
     * 
     * @return An operator that includes events that match the last few characters of the event record field specified
     *         as the value of <code>Field</code>.
     */
    public final List<String> endsWith() {
        return endsWith;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotEquals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotEquals() {
        return notEquals != null && !(notEquals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An operator that excludes events that match the exact value of the event record field specified as the value of
     * <code>Field</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotEquals} method.
     * </p>
     * 
     * @return An operator that excludes events that match the exact value of the event record field specified as the
     *         value of <code>Field</code>.
     */
    public final List<String> notEquals() {
        return notEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotStartsWith property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotStartsWith() {
        return notStartsWith != null && !(notStartsWith instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An operator that excludes events that match the first few characters of the event record field specified as the
     * value of <code>Field</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotStartsWith} method.
     * </p>
     * 
     * @return An operator that excludes events that match the first few characters of the event record field specified
     *         as the value of <code>Field</code>.
     */
    public final List<String> notStartsWith() {
        return notStartsWith;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotEndsWith property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotEndsWith() {
        return notEndsWith != null && !(notEndsWith instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An operator that excludes events that match the last few characters of the event record field specified as the
     * value of <code>Field</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotEndsWith} method.
     * </p>
     * 
     * @return An operator that excludes events that match the last few characters of the event record field specified
     *         as the value of <code>Field</code>.
     */
    public final List<String> notEndsWith() {
        return notEndsWith;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(hasEqualsValue() ? equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStartsWith() ? startsWith() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEndsWith() ? endsWith() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotEquals() ? notEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotStartsWith() ? notStartsWith() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotEndsWith() ? notEndsWith() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedFieldSelector)) {
            return false;
        }
        AdvancedFieldSelector other = (AdvancedFieldSelector) obj;
        return Objects.equals(field(), other.field()) && hasEqualsValue() == other.hasEqualsValue()
                && Objects.equals(equalsValue(), other.equalsValue()) && hasStartsWith() == other.hasStartsWith()
                && Objects.equals(startsWith(), other.startsWith()) && hasEndsWith() == other.hasEndsWith()
                && Objects.equals(endsWith(), other.endsWith()) && hasNotEquals() == other.hasNotEquals()
                && Objects.equals(notEquals(), other.notEquals()) && hasNotStartsWith() == other.hasNotStartsWith()
                && Objects.equals(notStartsWith(), other.notStartsWith()) && hasNotEndsWith() == other.hasNotEndsWith()
                && Objects.equals(notEndsWith(), other.notEndsWith());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedFieldSelector").add("Field", field())
                .add("Equals", hasEqualsValue() ? equalsValue() : null).add("StartsWith", hasStartsWith() ? startsWith() : null)
                .add("EndsWith", hasEndsWith() ? endsWith() : null).add("NotEquals", hasNotEquals() ? notEquals() : null)
                .add("NotStartsWith", hasNotStartsWith() ? notStartsWith() : null)
                .add("NotEndsWith", hasNotEndsWith() ? notEndsWith() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Field":
            return Optional.ofNullable(clazz.cast(field()));
        case "Equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "StartsWith":
            return Optional.ofNullable(clazz.cast(startsWith()));
        case "EndsWith":
            return Optional.ofNullable(clazz.cast(endsWith()));
        case "NotEquals":
            return Optional.ofNullable(clazz.cast(notEquals()));
        case "NotStartsWith":
            return Optional.ofNullable(clazz.cast(notStartsWith()));
        case "NotEndsWith":
            return Optional.ofNullable(clazz.cast(notEndsWith()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedFieldSelector, T> g) {
        return obj -> g.apply((AdvancedFieldSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedFieldSelector> {
        /**
         * <p>
         * A field in a CloudTrail event record on which to filter events to be logged. For event data stores for Config
         * configuration items, Audit Manager evidence, or non-Amazon Web Services events, the field is used only for
         * selecting events as filtering is not supported.
         * </p>
         * <p>
         * For CloudTrail event records, supported fields include <code>readOnly</code>, <code>eventCategory</code>,
         * <code>eventSource</code> (for management events), <code>eventName</code>, <code>resources.type</code>, and
         * <code>resources.ARN</code>.
         * </p>
         * <p>
         * For event data stores for Config configuration items, Audit Manager evidence, or non-Amazon Web Services
         * events, the only supported field is <code>eventCategory</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or
         * <code>false</code>. If you do not add this field, CloudTrail logs both <code>read</code> and
         * <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of
         * <code>false</code> logs only <code>write</code> events.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to
         * <code>NotEquals</code> <code>kms.amazonaws.com</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data
         * event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have
         * multiple values for this ﬁeld, separated by commas.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>eventCategory</code> </b> - This is required and must be set to <code>Equals</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For CloudTrail event records, the value must be <code>Management</code> or <code>Data</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Config configuration items, the value must be <code>ConfigurationItem</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Audit Manager evidence, the value must be <code>Evidence</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For non-Amazon Web Services events, the value must be <code>ActivityAuditLog</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>resources.type</code> </b> - This ﬁeld is required for CloudTrail data events.
         * <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::Lambda::Function</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3::Object</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::CloudTrail::Channel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::CodeWhisperer::Profile</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::Cognito::IdentityPool</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::DynamoDB::Stream</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EC2::Snapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::EMRWAL::Workspace</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::FinSpace::Environment</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::Glue::Table</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::GuardDuty::Detector</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::KendraRanking::ExecutionPlan</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::ManagedBlockchain::Node</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::SageMaker::ExperimentTrialComponent</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::SageMaker::FeatureGroup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3::AccessPoint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3ObjectLambda::AccessPoint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS::S3Outposts::Object</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one
         * resource type, add another selector.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if you
         * use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid resource
         * of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type
         * equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To log all data events
         * for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the
         * bucket ARN as the matching value.
         * </p>
         * <p>
         * The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than
         * symbols (&lt;&gt;) with resource-specific information.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/&lt;object_path&gt;/</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to <code>Equals</code>
         * or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to <code>Equals</code>
         * or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:lambda:&lt;region&gt;:&lt;account_ID&gt;:function:&lt;function_name&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When resources.type equals <code>AWS::CloudTrail::Channel</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:cloudtrail:&lt;region&gt;:&lt;account_ID&gt;:channel/&lt;channel_UUID&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When resources.type equals <code>AWS::CodeWhisperer::Profile</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:codewhisperer:&lt;region&gt;:&lt;account_ID&gt;:profile/&lt;profile_ID&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When resources.type equals <code>AWS::Cognito::IdentityPool</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:cognito-identity:&lt;region&gt;:&lt;account_ID&gt;:identitypool/&lt;identity_pool_ID&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;/stream/&lt;date_time&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:ec2:&lt;region&gt;::snapshot/&lt;snapshot_ID&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::EMRWAL::Workspace</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:emrwal:&lt;region&gt;::workspace/&lt;workspace_name&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::FinSpace::Environment</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:finspace:&lt;region&gt;:&lt;account_ID&gt;:environment/&lt;environment_ID&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:glue:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;database_name&gt;/&lt;table_name&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::GuardDuty::Detector</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:guardduty:&lt;region&gt;:&lt;account_ID&gt;:detector/&lt;detector_ID&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::KendraRanking::ExecutionPlan</code>, and the operator is
         * set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:kendra-ranking:&lt;region&gt;:&lt;account_ID&gt;:rescore-execution-plan/&lt;rescore_execution_plan_ID&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:managedblockchain:&lt;region&gt;:&lt;account_ID&gt;:nodes/&lt;node_ID&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::SageMaker::ExperimentTrialComponent</code>, and the
         * operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:experiment-trial-component/&lt;experiment_trial_component_name&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::SageMaker::FeatureGroup</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:feature-group/&lt;feature_group_name&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log events
         * on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the
         * object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;/object/&lt;object_path&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator is
         * set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:s3-object-lambda:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to
         * <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:&lt;partition&gt;:s3-outposts:&lt;region&gt;:&lt;account_ID&gt;:&lt;object_path&gt;</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param field
         *        A field in a CloudTrail event record on which to filter events to be logged. For event data stores for
         *        Config configuration items, Audit Manager evidence, or non-Amazon Web Services events, the field is
         *        used only for selecting events as filtering is not supported. </p>
         *        <p>
         *        For CloudTrail event records, supported fields include <code>readOnly</code>,
         *        <code>eventCategory</code>, <code>eventSource</code> (for management events), <code>eventName</code>,
         *        <code>resources.type</code>, and <code>resources.ARN</code>.
         *        </p>
         *        <p>
         *        For event data stores for Config configuration items, Audit Manager evidence, or non-Amazon Web
         *        Services events, the only supported field is <code>eventCategory</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of
         *        <code>true</code> or <code>false</code>. If you do not add this field, CloudTrail logs both
         *        <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only
         *        <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to
         *        <code>NotEquals</code> <code>kms.amazonaws.com</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any
         *        data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You
         *        can have multiple values for this ﬁeld, separated by commas.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>eventCategory</code> </b> - This is required and must be set to <code>Equals</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For CloudTrail event records, the value must be <code>Management</code> or <code>Data</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Config configuration items, the value must be <code>ConfigurationItem</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Audit Manager evidence, the value must be <code>Evidence</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For non-Amazon Web Services events, the value must be <code>ActivityAuditLog</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>resources.type</code> </b> - This ﬁeld is required for CloudTrail data events.
         *        <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of
         *        the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::Lambda::Function</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3::Object</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::CloudTrail::Channel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::CodeWhisperer::Profile</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::Cognito::IdentityPool</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::DynamoDB::Stream</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EC2::Snapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::EMRWAL::Workspace</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::FinSpace::Environment</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::Glue::Table</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::GuardDuty::Detector</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::KendraRanking::ExecutionPlan</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::ManagedBlockchain::Node</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::SageMaker::ExperimentTrialComponent</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::SageMaker::FeatureGroup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3::AccessPoint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3ObjectLambda::AccessPoint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS::S3Outposts::Object</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than
         *        one resource type, add another selector.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if
         *        you use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid
         *        resource of the type you've speciﬁed in the template as the value of resources.type. For example, if
         *        resources.type equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats.
         *        To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code>
         *        operator, and include only the bucket ARN as the matching value.
         *        </p>
         *        <p>
         *        The trailing slash is intentional; do not exclude it. Replace the text between less than and greater
         *        than symbols (&lt;&gt;) with resource-specific information.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/&lt;object_path&gt;/</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:lambda:&lt;region&gt;:&lt;account_ID&gt;:function:&lt;function_name&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When resources.type equals <code>AWS::CloudTrail::Channel</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:cloudtrail:&lt;region&gt;:&lt;account_ID&gt;:channel/&lt;channel_UUID&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When resources.type equals <code>AWS::CodeWhisperer::Profile</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:codewhisperer:&lt;region&gt;:&lt;account_ID&gt;:profile/&lt;profile_ID&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When resources.type equals <code>AWS::Cognito::IdentityPool</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:cognito-identity:&lt;region&gt;:&lt;account_ID&gt;:identitypool/&lt;identity_pool_ID&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;/stream/&lt;date_time&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:ec2:&lt;region&gt;::snapshot/&lt;snapshot_ID&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::EMRWAL::Workspace</code>, and the operator is set
         *        to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:emrwal:&lt;region&gt;::workspace/&lt;workspace_name&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::FinSpace::Environment</code>, and the operator is
         *        set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:finspace:&lt;region&gt;:&lt;account_ID&gt;:environment/&lt;environment_ID&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:glue:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;database_name&gt;/&lt;table_name&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::GuardDuty::Detector</code>, and the operator is set
         *        to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:guardduty:&lt;region&gt;:&lt;account_ID&gt;:detector/&lt;detector_ID&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::KendraRanking::ExecutionPlan</code>, and the
         *        operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following
         *        format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:kendra-ranking:&lt;region&gt;:&lt;account_ID&gt;:rescore-execution-plan/&lt;rescore_execution_plan_ID&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is
         *        set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:managedblockchain:&lt;region&gt;:&lt;account_ID&gt;:nodes/&lt;node_ID&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::SageMaker::ExperimentTrialComponent</code>, and the
         *        operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following
         *        format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:experiment-trial-component/&lt;experiment_trial_component_name&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::SageMaker::FeatureGroup</code>, and the operator is
         *        set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:feature-group/&lt;feature_group_name&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to
         *        <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log
         *        events on all objects in an S3 access point, we recommend that you use only the access point ARN,
         *        don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code>
         *        operators.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;/object/&lt;object_path&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the
         *        operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following
         *        format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:s3-object-lambda:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set
         *        to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:&lt;partition&gt;:s3-outposts:&lt;region&gt;:&lt;account_ID&gt;:&lt;object_path&gt;</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);

        /**
         * <p>
         * An operator that includes events that match the exact value of the event record field specified as the value
         * of <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>,
         * <code>eventCategory</code>, and <code>resources.type</code> fields.
         * </p>
         * 
         * @param equals
         *        An operator that includes events that match the exact value of the event record field specified as the
         *        value of <code>Field</code>. This is the only valid operator that you can use with the
         *        <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(Collection<String> equals);

        /**
         * <p>
         * An operator that includes events that match the exact value of the event record field specified as the value
         * of <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>,
         * <code>eventCategory</code>, and <code>resources.type</code> fields.
         * </p>
         * 
         * @param equals
         *        An operator that includes events that match the exact value of the event record field specified as the
         *        value of <code>Field</code>. This is the only valid operator that you can use with the
         *        <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(String... equals);

        /**
         * <p>
         * An operator that includes events that match the first few characters of the event record field specified as
         * the value of <code>Field</code>.
         * </p>
         * 
         * @param startsWith
         *        An operator that includes events that match the first few characters of the event record field
         *        specified as the value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startsWith(Collection<String> startsWith);

        /**
         * <p>
         * An operator that includes events that match the first few characters of the event record field specified as
         * the value of <code>Field</code>.
         * </p>
         * 
         * @param startsWith
         *        An operator that includes events that match the first few characters of the event record field
         *        specified as the value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startsWith(String... startsWith);

        /**
         * <p>
         * An operator that includes events that match the last few characters of the event record field specified as
         * the value of <code>Field</code>.
         * </p>
         * 
         * @param endsWith
         *        An operator that includes events that match the last few characters of the event record field
         *        specified as the value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endsWith(Collection<String> endsWith);

        /**
         * <p>
         * An operator that includes events that match the last few characters of the event record field specified as
         * the value of <code>Field</code>.
         * </p>
         * 
         * @param endsWith
         *        An operator that includes events that match the last few characters of the event record field
         *        specified as the value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endsWith(String... endsWith);

        /**
         * <p>
         * An operator that excludes events that match the exact value of the event record field specified as the value
         * of <code>Field</code>.
         * </p>
         * 
         * @param notEquals
         *        An operator that excludes events that match the exact value of the event record field specified as the
         *        value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(Collection<String> notEquals);

        /**
         * <p>
         * An operator that excludes events that match the exact value of the event record field specified as the value
         * of <code>Field</code>.
         * </p>
         * 
         * @param notEquals
         *        An operator that excludes events that match the exact value of the event record field specified as the
         *        value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(String... notEquals);

        /**
         * <p>
         * An operator that excludes events that match the first few characters of the event record field specified as
         * the value of <code>Field</code>.
         * </p>
         * 
         * @param notStartsWith
         *        An operator that excludes events that match the first few characters of the event record field
         *        specified as the value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notStartsWith(Collection<String> notStartsWith);

        /**
         * <p>
         * An operator that excludes events that match the first few characters of the event record field specified as
         * the value of <code>Field</code>.
         * </p>
         * 
         * @param notStartsWith
         *        An operator that excludes events that match the first few characters of the event record field
         *        specified as the value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notStartsWith(String... notStartsWith);

        /**
         * <p>
         * An operator that excludes events that match the last few characters of the event record field specified as
         * the value of <code>Field</code>.
         * </p>
         * 
         * @param notEndsWith
         *        An operator that excludes events that match the last few characters of the event record field
         *        specified as the value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEndsWith(Collection<String> notEndsWith);

        /**
         * <p>
         * An operator that excludes events that match the last few characters of the event record field specified as
         * the value of <code>Field</code>.
         * </p>
         * 
         * @param notEndsWith
         *        An operator that excludes events that match the last few characters of the event record field
         *        specified as the value of <code>Field</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEndsWith(String... notEndsWith);
    }

    static final class BuilderImpl implements Builder {
        private String field;

        private List<String> equals = DefaultSdkAutoConstructList.getInstance();

        private List<String> startsWith = DefaultSdkAutoConstructList.getInstance();

        private List<String> endsWith = DefaultSdkAutoConstructList.getInstance();

        private List<String> notEquals = DefaultSdkAutoConstructList.getInstance();

        private List<String> notStartsWith = DefaultSdkAutoConstructList.getInstance();

        private List<String> notEndsWith = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedFieldSelector model) {
            field(model.field);
            equalsValue(model.equals);
            startsWith(model.startsWith);
            endsWith(model.endsWith);
            notEquals(model.notEquals);
            notStartsWith(model.notStartsWith);
            notEndsWith(model.notEndsWith);
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final Collection<String> getEqualsValue() {
            if (equals instanceof SdkAutoConstructList) {
                return null;
            }
            return equals;
        }

        public final void setEqualsValue(Collection<String> equals) {
            this.equals = OperatorCopier.copy(equals);
        }

        @Override
        public final Builder equalsValue(Collection<String> equals) {
            this.equals = OperatorCopier.copy(equals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder equalsValue(String... equals) {
            equalsValue(Arrays.asList(equals));
            return this;
        }

        public final Collection<String> getStartsWith() {
            if (startsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return startsWith;
        }

        public final void setStartsWith(Collection<String> startsWith) {
            this.startsWith = OperatorCopier.copy(startsWith);
        }

        @Override
        public final Builder startsWith(Collection<String> startsWith) {
            this.startsWith = OperatorCopier.copy(startsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startsWith(String... startsWith) {
            startsWith(Arrays.asList(startsWith));
            return this;
        }

        public final Collection<String> getEndsWith() {
            if (endsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return endsWith;
        }

        public final void setEndsWith(Collection<String> endsWith) {
            this.endsWith = OperatorCopier.copy(endsWith);
        }

        @Override
        public final Builder endsWith(Collection<String> endsWith) {
            this.endsWith = OperatorCopier.copy(endsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endsWith(String... endsWith) {
            endsWith(Arrays.asList(endsWith));
            return this;
        }

        public final Collection<String> getNotEquals() {
            if (notEquals instanceof SdkAutoConstructList) {
                return null;
            }
            return notEquals;
        }

        public final void setNotEquals(Collection<String> notEquals) {
            this.notEquals = OperatorCopier.copy(notEquals);
        }

        @Override
        public final Builder notEquals(Collection<String> notEquals) {
            this.notEquals = OperatorCopier.copy(notEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notEquals(String... notEquals) {
            notEquals(Arrays.asList(notEquals));
            return this;
        }

        public final Collection<String> getNotStartsWith() {
            if (notStartsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return notStartsWith;
        }

        public final void setNotStartsWith(Collection<String> notStartsWith) {
            this.notStartsWith = OperatorCopier.copy(notStartsWith);
        }

        @Override
        public final Builder notStartsWith(Collection<String> notStartsWith) {
            this.notStartsWith = OperatorCopier.copy(notStartsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notStartsWith(String... notStartsWith) {
            notStartsWith(Arrays.asList(notStartsWith));
            return this;
        }

        public final Collection<String> getNotEndsWith() {
            if (notEndsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return notEndsWith;
        }

        public final void setNotEndsWith(Collection<String> notEndsWith) {
            this.notEndsWith = OperatorCopier.copy(notEndsWith);
        }

        @Override
        public final Builder notEndsWith(Collection<String> notEndsWith) {
            this.notEndsWith = OperatorCopier.copy(notEndsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notEndsWith(String... notEndsWith) {
            notEndsWith(Arrays.asList(notEndsWith));
            return this;
        }

        @Override
        public AdvancedFieldSelector build() {
            return new AdvancedFieldSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
