/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.TrailInfo;

public class ListTrailsIterable
implements SdkIterable<ListTrailsResponse> {
    private final CloudTrailClient client;
    private final ListTrailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrailsIterable(CloudTrailClient client, ListTrailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTrailsResponseFetcher();
    }

    public Iterator<ListTrailsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrailInfo> trails() {
        Function<ListTrailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trails() != null) {
                return response.trails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrailsResponseFetcher
    implements SyncPageFetcher<ListTrailsResponse> {
        private ListTrailsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrailsResponse nextPage(ListTrailsResponse previousPage) {
            if (previousPage == null) {
                return ListTrailsIterable.this.client.listTrails(ListTrailsIterable.this.firstRequest);
            }
            return ListTrailsIterable.this.client.listTrails((ListTrailsRequest)((Object)ListTrailsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

