/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.ImportDestinationsCopier;
import software.amazon.awssdk.services.cloudtrail.model.ImportSource;
import software.amazon.awssdk.services.cloudtrail.model.ImportStatistics;
import software.amazon.awssdk.services.cloudtrail.model.ImportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopImportResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, StopImportResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportId").getter(StopImportResponse.getter(StopImportResponse::importId)).setter(StopImportResponse.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportId").build()}).build();
    private static final SdkField<ImportSource> IMPORT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportSource").getter(StopImportResponse.getter(StopImportResponse::importSource)).setter(StopImportResponse.setter(Builder::importSource)).constructor(ImportSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSource").build()}).build();
    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(StopImportResponse.getter(StopImportResponse::destinations)).setter(StopImportResponse.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportStatus").getter(StopImportResponse.getter(StopImportResponse::importStatusAsString)).setter(StopImportResponse.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(StopImportResponse.getter(StopImportResponse::createdTimestamp)).setter(StopImportResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(StopImportResponse.getter(StopImportResponse::updatedTimestamp)).setter(StopImportResponse.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()}).build();
    private static final SdkField<Instant> START_EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartEventTime").getter(StopImportResponse.getter(StopImportResponse::startEventTime)).setter(StopImportResponse.setter(Builder::startEventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartEventTime").build()}).build();
    private static final SdkField<Instant> END_EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndEventTime").getter(StopImportResponse.getter(StopImportResponse::endEventTime)).setter(StopImportResponse.setter(Builder::endEventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndEventTime").build()}).build();
    private static final SdkField<ImportStatistics> IMPORT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportStatistics").getter(StopImportResponse.getter(StopImportResponse::importStatistics)).setter(StopImportResponse.setter(Builder::importStatistics)).constructor(ImportStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, IMPORT_SOURCE_FIELD, DESTINATIONS_FIELD, IMPORT_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, START_EVENT_TIME_FIELD, END_EVENT_TIME_FIELD, IMPORT_STATISTICS_FIELD));
    private final String importId;
    private final ImportSource importSource;
    private final List<String> destinations;
    private final String importStatus;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;
    private final Instant startEventTime;
    private final Instant endEventTime;
    private final ImportStatistics importStatistics;

    private StopImportResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.importSource = builder.importSource;
        this.destinations = builder.destinations;
        this.importStatus = builder.importStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.startEventTime = builder.startEventTime;
        this.endEventTime = builder.endEventTime;
        this.importStatistics = builder.importStatistics;
    }

    public final String importId() {
        return this.importId;
    }

    public final ImportSource importSource() {
        return this.importSource;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<String> destinations() {
        return this.destinations;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public final Instant startEventTime() {
        return this.startEventTime;
    }

    public final Instant endEventTime() {
        return this.endEventTime;
    }

    public final ImportStatistics importStatistics() {
        return this.importStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.startEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopImportResponse)) {
            return false;
        }
        StopImportResponse other = (StopImportResponse)((Object)obj);
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.importSource(), other.importSource()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(this.startEventTime(), other.startEventTime()) && Objects.equals(this.endEventTime(), other.endEventTime()) && Objects.equals(this.importStatistics(), other.importStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"StopImportResponse").add("ImportId", (Object)this.importId()).add("ImportSource", (Object)this.importSource()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("ImportStatus", (Object)this.importStatusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).add("StartEventTime", (Object)this.startEventTime()).add("EndEventTime", (Object)this.endEventTime()).add("ImportStatistics", (Object)this.importStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "ImportSource": {
                return Optional.ofNullable(clazz.cast(this.importSource()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "ImportStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
            case "StartEventTime": {
                return Optional.ofNullable(clazz.cast(this.startEventTime()));
            }
            case "EndEventTime": {
                return Optional.ofNullable(clazz.cast(this.endEventTime()));
            }
            case "ImportStatistics": {
                return Optional.ofNullable(clazz.cast(this.importStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopImportResponse, T> g) {
        return obj -> g.apply((StopImportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String importId;
        private ImportSource importSource;
        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();
        private String importStatus;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;
        private Instant startEventTime;
        private Instant endEventTime;
        private ImportStatistics importStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(StopImportResponse model) {
            super(model);
            this.importId(model.importId);
            this.importSource(model.importSource);
            this.destinations(model.destinations);
            this.importStatus(model.importStatus);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
            this.startEventTime(model.startEventTime);
            this.endEventTime(model.endEventTime);
            this.importStatistics(model.importStatistics);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportSource.Builder getImportSource() {
            return this.importSource != null ? this.importSource.toBuilder() : null;
        }

        public final void setImportSource(ImportSource.BuilderImpl importSource) {
            this.importSource = importSource != null ? importSource.build() : null;
        }

        @Override
        public final Builder importSource(ImportSource importSource) {
            this.importSource = importSource;
            return this;
        }

        public final Collection<String> getDestinations() {
            if (this.destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final Instant getStartEventTime() {
            return this.startEventTime;
        }

        public final void setStartEventTime(Instant startEventTime) {
            this.startEventTime = startEventTime;
        }

        @Override
        public final Builder startEventTime(Instant startEventTime) {
            this.startEventTime = startEventTime;
            return this;
        }

        public final Instant getEndEventTime() {
            return this.endEventTime;
        }

        public final void setEndEventTime(Instant endEventTime) {
            this.endEventTime = endEventTime;
        }

        @Override
        public final Builder endEventTime(Instant endEventTime) {
            this.endEventTime = endEventTime;
            return this;
        }

        public final ImportStatistics.Builder getImportStatistics() {
            return this.importStatistics != null ? this.importStatistics.toBuilder() : null;
        }

        public final void setImportStatistics(ImportStatistics.BuilderImpl importStatistics) {
            this.importStatistics = importStatistics != null ? importStatistics.build() : null;
        }

        @Override
        public final Builder importStatistics(ImportStatistics importStatistics) {
            this.importStatistics = importStatistics;
            return this;
        }

        @Override
        public StopImportResponse build() {
            return new StopImportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopImportResponse> {
        public Builder importId(String var1);

        public Builder importSource(ImportSource var1);

        default public Builder importSource(Consumer<ImportSource.Builder> importSource) {
            return this.importSource((ImportSource)((ImportSource.Builder)ImportSource.builder().applyMutation(importSource)).build());
        }

        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);

        public Builder startEventTime(Instant var1);

        public Builder endEventTime(Instant var1);

        public Builder importStatistics(ImportStatistics var1);

        default public Builder importStatistics(Consumer<ImportStatistics.Builder> importStatistics) {
            return this.importStatistics((ImportStatistics)((ImportStatistics.Builder)ImportStatistics.builder().applyMutation(importStatistics)).build());
        }
    }
}

