/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.ImportDestinationsCopier;
import software.amazon.awssdk.services.cloudtrail.model.ImportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportsListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportsListItem> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportId").getter(ImportsListItem.getter(ImportsListItem::importId)).setter(ImportsListItem.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportId").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportStatus").getter(ImportsListItem.getter(ImportsListItem::importStatusAsString)).setter(ImportsListItem.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatus").build()}).build();
    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(ImportsListItem.getter(ImportsListItem::destinations)).setter(ImportsListItem.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(ImportsListItem.getter(ImportsListItem::createdTimestamp)).setter(ImportsListItem.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(ImportsListItem.getter(ImportsListItem::updatedTimestamp)).setter(ImportsListItem.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, IMPORT_STATUS_FIELD, DESTINATIONS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String importId;
    private final String importStatus;
    private final List<String> destinations;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private ImportsListItem(BuilderImpl builder) {
        this.importId = builder.importId;
        this.importStatus = builder.importStatus;
        this.destinations = builder.destinations;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String importId() {
        return this.importId;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<String> destinations() {
        return this.destinations;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportsListItem)) {
            return false;
        }
        ImportsListItem other = (ImportsListItem)obj;
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ImportsListItem").add("ImportId", (Object)this.importId()).add("ImportStatus", (Object)this.importStatusAsString()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "ImportStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportsListItem, T> g) {
        return obj -> g.apply((ImportsListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String importId;
        private String importStatus;
        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportsListItem model) {
            this.importId(model.importId);
            this.importStatus(model.importStatus);
            this.destinations(model.destinations);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final Collection<String> getDestinations() {
            if (this.destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public ImportsListItem build() {
            return new ImportsListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportsListItem> {
        public Builder importId(String var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

