/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelectorsCopier;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.Tag;
import software.amazon.awssdk.services.cloudtrail.model.TagsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEventDataStoreRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, CreateEventDataStoreRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateEventDataStoreRequest.getter(CreateEventDataStoreRequest::name)).setter(CreateEventDataStoreRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedEventSelectors").getter(CreateEventDataStoreRequest.getter(CreateEventDataStoreRequest::advancedEventSelectors)).setter(CreateEventDataStoreRequest.setter(Builder::advancedEventSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedEventSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_REGION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiRegionEnabled").getter(CreateEventDataStoreRequest.getter(CreateEventDataStoreRequest::multiRegionEnabled)).setter(CreateEventDataStoreRequest.setter(Builder::multiRegionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionEnabled").build()}).build();
    private static final SdkField<Boolean> ORGANIZATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OrganizationEnabled").getter(CreateEventDataStoreRequest.getter(CreateEventDataStoreRequest::organizationEnabled)).setter(CreateEventDataStoreRequest.setter(Builder::organizationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationEnabled").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriod").getter(CreateEventDataStoreRequest.getter(CreateEventDataStoreRequest::retentionPeriod)).setter(CreateEventDataStoreRequest.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtectionEnabled").getter(CreateEventDataStoreRequest.getter(CreateEventDataStoreRequest::terminationProtectionEnabled)).setter(CreateEventDataStoreRequest.setter(Builder::terminationProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagsList").getter(CreateEventDataStoreRequest.getter(CreateEventDataStoreRequest::tagsList)).setter(CreateEventDataStoreRequest.setter(Builder::tagsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateEventDataStoreRequest.getter(CreateEventDataStoreRequest::kmsKeyId)).setter(CreateEventDataStoreRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ADVANCED_EVENT_SELECTORS_FIELD, MULTI_REGION_ENABLED_FIELD, ORGANIZATION_ENABLED_FIELD, RETENTION_PERIOD_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD, TAGS_LIST_FIELD, KMS_KEY_ID_FIELD));
    private final String name;
    private final List<AdvancedEventSelector> advancedEventSelectors;
    private final Boolean multiRegionEnabled;
    private final Boolean organizationEnabled;
    private final Integer retentionPeriod;
    private final Boolean terminationProtectionEnabled;
    private final List<Tag> tagsList;
    private final String kmsKeyId;

    private CreateEventDataStoreRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.advancedEventSelectors = builder.advancedEventSelectors;
        this.multiRegionEnabled = builder.multiRegionEnabled;
        this.organizationEnabled = builder.organizationEnabled;
        this.retentionPeriod = builder.retentionPeriod;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.tagsList = builder.tagsList;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasAdvancedEventSelectors() {
        return this.advancedEventSelectors != null && !(this.advancedEventSelectors instanceof SdkAutoConstructList);
    }

    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return this.advancedEventSelectors;
    }

    public final Boolean multiRegionEnabled() {
        return this.multiRegionEnabled;
    }

    public final Boolean organizationEnabled() {
        return this.organizationEnabled;
    }

    public final Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public final Boolean terminationProtectionEnabled() {
        return this.terminationProtectionEnabled;
    }

    public final boolean hasTagsList() {
        return this.tagsList != null && !(this.tagsList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagsList() {
        return this.tagsList;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsList() ? this.tagsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventDataStoreRequest)) {
            return false;
        }
        CreateEventDataStoreRequest other = (CreateEventDataStoreRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors() && Objects.equals(this.advancedEventSelectors(), other.advancedEventSelectors()) && Objects.equals(this.multiRegionEnabled(), other.multiRegionEnabled()) && Objects.equals(this.organizationEnabled(), other.organizationEnabled()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.terminationProtectionEnabled(), other.terminationProtectionEnabled()) && this.hasTagsList() == other.hasTagsList() && Objects.equals(this.tagsList(), other.tagsList()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEventDataStoreRequest").add("Name", (Object)this.name()).add("AdvancedEventSelectors", this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null).add("MultiRegionEnabled", (Object)this.multiRegionEnabled()).add("OrganizationEnabled", (Object)this.organizationEnabled()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("TerminationProtectionEnabled", (Object)this.terminationProtectionEnabled()).add("TagsList", this.hasTagsList() ? this.tagsList() : null).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AdvancedEventSelectors": {
                return Optional.ofNullable(clazz.cast(this.advancedEventSelectors()));
            }
            case "MultiRegionEnabled": {
                return Optional.ofNullable(clazz.cast(this.multiRegionEnabled()));
            }
            case "OrganizationEnabled": {
                return Optional.ofNullable(clazz.cast(this.organizationEnabled()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "TerminationProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationProtectionEnabled()));
            }
            case "TagsList": {
                return Optional.ofNullable(clazz.cast(this.tagsList()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventDataStoreRequest, T> g) {
        return obj -> g.apply((CreateEventDataStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiRegionEnabled;
        private Boolean organizationEnabled;
        private Integer retentionPeriod;
        private Boolean terminationProtectionEnabled;
        private List<Tag> tagsList = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventDataStoreRequest model) {
            super(model);
            this.name(model.name);
            this.advancedEventSelectors(model.advancedEventSelectors);
            this.multiRegionEnabled(model.multiRegionEnabled);
            this.organizationEnabled(model.organizationEnabled);
            this.retentionPeriod(model.retentionPeriod);
            this.terminationProtectionEnabled(model.terminationProtectionEnabled);
            this.tagsList(model.tagsList);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            List<AdvancedEventSelector.Builder> result = AdvancedEventSelectorsCopier.copyToBuilder(this.advancedEventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector ... advancedEventSelectors) {
            this.advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... advancedEventSelectors) {
            this.advancedEventSelectors(Stream.of(advancedEventSelectors).map(c -> (AdvancedEventSelector)((AdvancedEventSelector.Builder)AdvancedEventSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiRegionEnabled() {
            return this.multiRegionEnabled;
        }

        public final void setMultiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
        }

        @Override
        public final Builder multiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        public final Boolean getOrganizationEnabled() {
            return this.organizationEnabled;
        }

        public final void setOrganizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
        }

        @Override
        public final Builder organizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        public final List<Tag.Builder> getTagsList() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tagsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsList(Collection<Tag.BuilderImpl> tagsList) {
            this.tagsList = TagsListCopier.copyFromBuilder(tagsList);
        }

        @Override
        public final Builder tagsList(Collection<Tag> tagsList) {
            this.tagsList = TagsListCopier.copy(tagsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Tag ... tagsList) {
            this.tagsList(Arrays.asList(tagsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Consumer<Tag.Builder> ... tagsList) {
            this.tagsList(Stream.of(tagsList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventDataStoreRequest build() {
            return new CreateEventDataStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEventDataStoreRequest> {
        public Builder name(String var1);

        public Builder advancedEventSelectors(Collection<AdvancedEventSelector> var1);

        public Builder advancedEventSelectors(AdvancedEventSelector ... var1);

        public Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... var1);

        public Builder multiRegionEnabled(Boolean var1);

        public Builder organizationEnabled(Boolean var1);

        public Builder retentionPeriod(Integer var1);

        public Builder terminationProtectionEnabled(Boolean var1);

        public Builder tagsList(Collection<Tag> var1);

        public Builder tagsList(Tag ... var1);

        public Builder tagsList(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

