/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OptionState {
    REQUIRES_INDEX_DOCUMENTS("RequiresIndexDocuments"),
    PROCESSING("Processing"),
    ACTIVE("Active"),
    FAILED_TO_VALIDATE("FailedToValidate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OptionState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OptionState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OptionState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OptionState> knownValues() {
        return Stream.of(OptionState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

