/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IndexFieldType {
    INT("int"),
    DOUBLE("double"),
    LITERAL("literal"),
    TEXT("text"),
    DATE("date"),
    LATLON("latlon"),
    INT_ARRAY("int-array"),
    DOUBLE_ARRAY("double-array"),
    LITERAL_ARRAY("literal-array"),
    TEXT_ARRAY("text-array"),
    DATE_ARRAY("date-array"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IndexFieldType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndexFieldType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IndexFieldType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IndexFieldType> knownValues() {
        return Stream.of(IndexFieldType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

