/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2AsyncClient;
import software.amazon.awssdk.services.cloudhsmv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse;

public class DescribeClustersPublisher
implements SdkPublisher<DescribeClustersResponse> {
    private final CloudHsmV2AsyncClient client;
    private final DescribeClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClustersPublisher(CloudHsmV2AsyncClient client, DescribeClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClustersPublisher(CloudHsmV2AsyncClient client, DescribeClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeClustersResponseFetcher
    implements AsyncPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeClustersResponse> nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersPublisher.this.client.describeClusters(DescribeClustersPublisher.this.firstRequest);
            }
            return DescribeClustersPublisher.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

