/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClientVersion {
    FIVE_ONE("5.1"),
    FIVE_THREE("5.3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClientVersion> VALUE_MAP;
    private final String value;

    private ClientVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientVersion> knownValues() {
        EnumSet<ClientVersion> knownValues = EnumSet.allOf(ClientVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClientVersion.class, ClientVersion::toString);
    }
}

