/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.VpcOrigin;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVpcOriginResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetVpcOriginResponse> {
    private static final SdkField<VpcOrigin> VPC_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOrigin").getter(GetVpcOriginResponse.getter(GetVpcOriginResponse::vpcOrigin)).setter(GetVpcOriginResponse.setter(Builder::vpcOrigin)).constructor(VpcOrigin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOrigin").unmarshallLocationName("VpcOrigin").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetVpcOriginResponse.getter(GetVpcOriginResponse::eTag)).setter(GetVpcOriginResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ORIGIN_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetVpcOriginResponse.memberNameToFieldInitializer();
    private final VpcOrigin vpcOrigin;
    private final String eTag;

    private GetVpcOriginResponse(BuilderImpl builder) {
        super(builder);
        this.vpcOrigin = builder.vpcOrigin;
        this.eTag = builder.eTag;
    }

    public final VpcOrigin vpcOrigin() {
        return this.vpcOrigin;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOrigin());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVpcOriginResponse)) {
            return false;
        }
        GetVpcOriginResponse other = (GetVpcOriginResponse)((Object)obj);
        return Objects.equals(this.vpcOrigin(), other.vpcOrigin()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetVpcOriginResponse").add("VpcOrigin", (Object)this.vpcOrigin()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcOrigin": {
                return Optional.ofNullable(clazz.cast(this.vpcOrigin()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcOrigin", VPC_ORIGIN_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVpcOriginResponse, T> g) {
        return obj -> g.apply((GetVpcOriginResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private VpcOrigin vpcOrigin;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVpcOriginResponse model) {
            super(model);
            this.vpcOrigin(model.vpcOrigin);
            this.eTag(model.eTag);
        }

        public final VpcOrigin.Builder getVpcOrigin() {
            return this.vpcOrigin != null ? this.vpcOrigin.toBuilder() : null;
        }

        public final void setVpcOrigin(VpcOrigin.BuilderImpl vpcOrigin) {
            this.vpcOrigin = vpcOrigin != null ? vpcOrigin.build() : null;
        }

        @Override
        public final Builder vpcOrigin(VpcOrigin vpcOrigin) {
            this.vpcOrigin = vpcOrigin;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetVpcOriginResponse build() {
            return new GetVpcOriginResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVpcOriginResponse> {
        public Builder vpcOrigin(VpcOrigin var1);

        default public Builder vpcOrigin(Consumer<VpcOrigin.Builder> vpcOrigin) {
            return this.vpcOrigin((VpcOrigin)((VpcOrigin.Builder)VpcOrigin.builder().applyMutation(vpcOrigin)).build());
        }

        public Builder eTag(String var1);
    }
}

