/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasResponse;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CopyDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.FunctionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FunctionInUseException;
import software.amazon.awssdk.services.cloudfront.model.FunctionSizeLimitExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalDeleteException;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalOriginAccessConfigurationException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDomainNameForOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.KeyGroupAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.MonitoringSubscriptionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchContinuousDeploymentPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFunctionExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchMonitoringSubscriptionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchRealtimeLogConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlInUseException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigOwnerMismatchException;
import software.amazon.awssdk.services.cloudfront.model.ResourceInUseException;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.StagingDistributionInUseException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionFailedException;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.TooLongCspInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCachePoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyContinuousDeploymentPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCustomHeadersInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithSingleFunctionArnException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsAssociatedToDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginAccessControlsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginRequestPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysInKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyRealtimeLogConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyRemoveHeadersInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyResponseHeadersPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroupDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.waiters.CloudFrontWaiter;

/**
 * Service client for accessing CloudFront. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon CloudFront</fullname>
 * <p>
 * This is the <i>Amazon CloudFront API Reference</i>. This guide is for developers who need detailed information about
 * CloudFront API actions, data types, and errors. For detailed information about CloudFront features, see the <i>Amazon
 * CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudFrontClient extends AwsClient {
    String SERVICE_NAME = "cloudfront";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudfront";

    /**
     * <p>
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
     * </p>
     * <p>
     * With this operation you can move an alias that's already in use on a CloudFront distribution to a different
     * distribution in one step. This prevents the downtime that could occur if you first remove the alias from one
     * distribution and then separately add the alias to another distribution.
     * </p>
     * <p>
     * To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target
     * distribution for the alias. For more information, including how to set up the target distribution, prerequisites
     * that you must complete, and other restrictions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param associateAliasRequest
     * @return Result of the AssociateAlias operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.AssociateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/AssociateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateAliasResponse associateAlias(AssociateAliasRequest associateAliasRequest) throws InvalidArgumentException,
            NoSuchDistributionException, TooManyDistributionCnamEsException, IllegalUpdateException, AccessDeniedException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
     * </p>
     * <p>
     * With this operation you can move an alias that's already in use on a CloudFront distribution to a different
     * distribution in one step. This prevents the downtime that could occur if you first remove the alias from one
     * distribution and then separately add the alias to another distribution.
     * </p>
     * <p>
     * To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target
     * distribution for the alias. For more information, including how to set up the target distribution, prerequisites
     * that you must complete, and other restrictions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateAliasRequest#builder()}
     * </p>
     *
     * @param associateAliasRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAliasRequest.Builder} to create a request.
     * @return Result of the AssociateAlias operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.AssociateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/AssociateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateAliasResponse associateAlias(Consumer<AssociateAliasRequest.Builder> associateAliasRequest)
            throws InvalidArgumentException, NoSuchDistributionException, TooManyDistributionCnamEsException,
            IllegalUpdateException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        return associateAlias(AssociateAliasRequest.builder().applyMutation(associateAliasRequest).build());
    }

    /**
     * <p>
     * Creates a staging distribution using the configuration of the provided primary distribution. A staging
     * distribution is a copy of an existing distribution (called the primary distribution) that you can use in a
     * continuous deployment workflow.
     * </p>
     * <p>
     * After you create a staging distribution, you can use <code>UpdateDistribution</code> to modify the staging
     * distribution's configuration. Then you can use <code>CreateContinuousDeploymentPolicy</code> to incrementally
     * move traffic to the staging distribution.
     * </p>
     *
     * @param copyDistributionRequest
     * @return Result of the CopyDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CopyDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CopyDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyDistributionResponse copyDistribution(CopyDistributionRequest copyDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a staging distribution using the configuration of the provided primary distribution. A staging
     * distribution is a copy of an existing distribution (called the primary distribution) that you can use in a
     * continuous deployment workflow.
     * </p>
     * <p>
     * After you create a staging distribution, you can use <code>UpdateDistribution</code> to modify the staging
     * distribution's configuration. Then you can use <code>CreateContinuousDeploymentPolicy</code> to incrementally
     * move traffic to the staging distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDistributionRequest.Builder} avoiding the need
     * to create one manually via {@link CopyDistributionRequest#builder()}
     * </p>
     *
     * @param copyDistributionRequest
     *        A {@link Consumer} that will call methods on {@link CopyDistributionRequest.Builder} to create a request.
     * @return Result of the CopyDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CopyDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CopyDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyDistributionResponse copyDistribution(Consumer<CopyDistributionRequest.Builder> copyDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return copyDistribution(CopyDistributionRequest.builder().applyMutation(copyDistributionRequest).build());
    }

    /**
     * <p>
     * Creates a cache policy.
     * </p>
     * <p>
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it's attached to a cache
     * behavior, the cache policy determines the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The values that CloudFront includes in the <i>cache key</i>. These values can include HTTP headers, cookies, and
     * URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront
     * cache.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The headers, cookies, and query strings that are included in the cache key are also included in requests that
     * CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches
     * the request's cache key. If you want to send values to the origin but <i>not</i> include them in the cache key,
     * use <code>OriginRequestPolicy</code>.
     * </p>
     * <p>
     * For more information about cache policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
     * >Controlling the cache key</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCachePolicyRequest
     * @return Result of the CreateCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws CachePolicyAlreadyExistsException
     *         A cache policy with this name already exists. You must provide a unique name. To modify an existing cache
     *         policy, use <code>UpdateCachePolicy</code>.
     * @throws TooManyCachePoliciesException
     *         You have reached the maximum number of cache policies for this Amazon Web Services account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyHeadersInCachePolicyException
     *         The number of headers in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInCachePolicyException
     *         The number of cookies in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInCachePolicyException
     *         The number of query strings in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCachePolicyResponse createCachePolicy(CreateCachePolicyRequest createCachePolicyRequest)
            throws AccessDeniedException, InconsistentQuantitiesException, InvalidArgumentException,
            CachePolicyAlreadyExistsException, TooManyCachePoliciesException, TooManyHeadersInCachePolicyException,
            TooManyCookiesInCachePolicyException, TooManyQueryStringsInCachePolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cache policy.
     * </p>
     * <p>
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it's attached to a cache
     * behavior, the cache policy determines the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The values that CloudFront includes in the <i>cache key</i>. These values can include HTTP headers, cookies, and
     * URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront
     * cache.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The headers, cookies, and query strings that are included in the cache key are also included in requests that
     * CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches
     * the request's cache key. If you want to send values to the origin but <i>not</i> include them in the cache key,
     * use <code>OriginRequestPolicy</code>.
     * </p>
     * <p>
     * For more information about cache policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
     * >Controlling the cache key</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCachePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCachePolicyRequest#builder()}
     * </p>
     *
     * @param createCachePolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateCachePolicyRequest.Builder} to create a request.
     * @return Result of the CreateCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws CachePolicyAlreadyExistsException
     *         A cache policy with this name already exists. You must provide a unique name. To modify an existing cache
     *         policy, use <code>UpdateCachePolicy</code>.
     * @throws TooManyCachePoliciesException
     *         You have reached the maximum number of cache policies for this Amazon Web Services account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyHeadersInCachePolicyException
     *         The number of headers in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInCachePolicyException
     *         The number of cookies in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInCachePolicyException
     *         The number of query strings in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCachePolicyResponse createCachePolicy(Consumer<CreateCachePolicyRequest.Builder> createCachePolicyRequest)
            throws AccessDeniedException, InconsistentQuantitiesException, InvalidArgumentException,
            CachePolicyAlreadyExistsException, TooManyCachePoliciesException, TooManyHeadersInCachePolicyException,
            TooManyCookiesInCachePolicyException, TooManyQueryStringsInCachePolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return createCachePolicy(CreateCachePolicyRequest.builder().applyMutation(createCachePolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        The request to create a new origin access identity (OAI). An origin access identity is a special
     *        CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of
     *        your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return Result of the CreateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws CloudFrontOriginAccessIdentityAlreadyExistsException
     *         If the <code>CallerReference</code> is a value you already sent in a previous request to create an
     *         identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the
     *         original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyCloudFrontOriginAccessIdentitiesException
     *         Processing your request would cause you to exceed the maximum number of origin access identities allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentity(
            CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest)
            throws CloudFrontOriginAccessIdentityAlreadyExistsException, MissingBodyException,
            TooManyCloudFrontOriginAccessIdentitiesException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link CreateCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. The request to create a new origin access identity (OAI). An origin access identity
     *        is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or
     *        just some of your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return Result of the CreateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws CloudFrontOriginAccessIdentityAlreadyExistsException
     *         If the <code>CallerReference</code> is a value you already sent in a previous request to create an
     *         identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the
     *         original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyCloudFrontOriginAccessIdentitiesException
     *         Processing your request would cause you to exceed the maximum number of origin access identities allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentity(
            Consumer<CreateCloudFrontOriginAccessIdentityRequest.Builder> createCloudFrontOriginAccessIdentityRequest)
            throws CloudFrontOriginAccessIdentityAlreadyExistsException, MissingBodyException,
            TooManyCloudFrontOriginAccessIdentitiesException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(createCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Creates a continuous deployment policy that distributes traffic for a custom domain name to two different
     * CloudFront distributions.
     * </p>
     * <p>
     * To use a continuous deployment policy, first use <code>CopyDistribution</code> to create a staging distribution,
     * then use <code>UpdateDistribution</code> to modify the staging distribution's configuration.
     * </p>
     * <p>
     * After you create and update a staging distribution, you can use a continuous deployment policy to incrementally
     * move traffic to the staging distribution. This workflow enables you to test changes to a distribution's
     * configuration before moving all of your domain's production traffic to the new configuration.
     * </p>
     *
     * @param createContinuousDeploymentPolicyRequest
     * @return Result of the CreateContinuousDeploymentPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws ContinuousDeploymentPolicyAlreadyExistsException
     *         A continuous deployment policy with this configuration already exists.
     * @throws TooManyContinuousDeploymentPoliciesException
     *         You have reached the maximum number of continuous deployment policies for this Amazon Web Services
     *         account.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContinuousDeploymentPolicyResponse createContinuousDeploymentPolicy(
            CreateContinuousDeploymentPolicyRequest createContinuousDeploymentPolicyRequest) throws AccessDeniedException,
            InvalidArgumentException, InconsistentQuantitiesException, ContinuousDeploymentPolicyAlreadyExistsException,
            TooManyContinuousDeploymentPoliciesException, StagingDistributionInUseException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a continuous deployment policy that distributes traffic for a custom domain name to two different
     * CloudFront distributions.
     * </p>
     * <p>
     * To use a continuous deployment policy, first use <code>CopyDistribution</code> to create a staging distribution,
     * then use <code>UpdateDistribution</code> to modify the staging distribution's configuration.
     * </p>
     * <p>
     * After you create and update a staging distribution, you can use a continuous deployment policy to incrementally
     * move traffic to the staging distribution. This workflow enables you to test changes to a distribution's
     * configuration before moving all of your domain's production traffic to the new configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContinuousDeploymentPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link CreateContinuousDeploymentPolicyRequest#builder()}
     * </p>
     *
     * @param createContinuousDeploymentPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateContinuousDeploymentPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the CreateContinuousDeploymentPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws ContinuousDeploymentPolicyAlreadyExistsException
     *         A continuous deployment policy with this configuration already exists.
     * @throws TooManyContinuousDeploymentPoliciesException
     *         You have reached the maximum number of continuous deployment policies for this Amazon Web Services
     *         account.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContinuousDeploymentPolicyResponse createContinuousDeploymentPolicy(
            Consumer<CreateContinuousDeploymentPolicyRequest.Builder> createContinuousDeploymentPolicyRequest)
            throws AccessDeniedException, InvalidArgumentException, InconsistentQuantitiesException,
            ContinuousDeploymentPolicyAlreadyExistsException, TooManyContinuousDeploymentPoliciesException,
            StagingDistributionInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        return createContinuousDeploymentPolicy(CreateContinuousDeploymentPolicyRequest.builder()
                .applyMutation(createContinuousDeploymentPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a CloudFront distribution.
     * </p>
     *
     * @param createDistributionRequest
     *        The request to create a new distribution.
     * @return Result of the CreateDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws IllegalOriginAccessConfigurationException
     *         An origin cannot contain both an origin access control (OAC) and an origin access identity (OAI).
     * @throws TooManyDistributionsAssociatedToOriginAccessControlException
     *         The maximum number of distributions have been associated with the specified origin access control.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDistributionResponse createDistribution(CreateDistributionRequest createDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, IllegalOriginAccessConfigurationException,
            TooManyDistributionsAssociatedToOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException,
            NoSuchContinuousDeploymentPolicyException, InvalidDomainNameForOriginAccessControlException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a CloudFront distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDistributionRequest#builder()}
     * </p>
     *
     * @param createDistributionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionRequest.Builder} to create a
     *        request. The request to create a new distribution.
     * @return Result of the CreateDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws IllegalOriginAccessConfigurationException
     *         An origin cannot contain both an origin access control (OAC) and an origin access identity (OAI).
     * @throws TooManyDistributionsAssociatedToOriginAccessControlException
     *         The maximum number of distributions have been associated with the specified origin access control.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDistributionResponse createDistribution(Consumer<CreateDistributionRequest.Builder> createDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, IllegalOriginAccessConfigurationException,
            TooManyDistributionsAssociatedToOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException,
            NoSuchContinuousDeploymentPolicyException, InvalidDomainNameForOriginAccessControlException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return createDistribution(CreateDistributionRequest.builder().applyMutation(createDistributionRequest).build());
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        The request to create a new distribution with tags.
     * @return Result of the CreateDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDistributionWithTagsResponse createDistributionWithTags(
            CreateDistributionWithTagsRequest createDistributionWithTagsRequest) throws CnameAlreadyExistsException,
            DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, InvalidTaggingException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException,
            NoSuchContinuousDeploymentPolicyException, InvalidDomainNameForOriginAccessControlException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionWithTagsRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDistributionWithTagsRequest#builder()}
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionWithTagsRequest.Builder} to create a
     *        request. The request to create a new distribution with tags.
     * @return Result of the CreateDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDistributionWithTagsResponse createDistributionWithTags(
            Consumer<CreateDistributionWithTagsRequest.Builder> createDistributionWithTagsRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, AccessDeniedException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException,
            InvalidMinimumProtocolVersionException, MissingBodyException, TooManyDistributionCnamEsException,
            TooManyDistributionsException, InvalidDefaultRootObjectException, InvalidRelativePathException,
            InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException,
            NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException,
            TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException,
            TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException,
            TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException,
            InvalidProtocolSettingsException, InvalidTtlOrderException, InvalidWebAclIdException,
            TooManyOriginCustomHeadersException, InvalidTaggingException, TooManyQueryStringParametersException,
            InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException,
            TooManyDistributionsWithSingleFunctionArnException, TooManyLambdaFunctionAssociationsException,
            InvalidLambdaFunctionAssociationException, TooManyDistributionsWithFunctionAssociationsException,
            TooManyFunctionAssociationsException, InvalidFunctionAssociationException, InvalidOriginReadTimeoutException,
            InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException,
            IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException,
            NoSuchContinuousDeploymentPolicyException, InvalidDomainNameForOriginAccessControlException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return createDistributionWithTags(CreateDistributionWithTagsRequest.builder()
                .applyMutation(createDistributionWithTagsRequest).build());
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     * @return Result of the CreateFieldLevelEncryptionConfig operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws FieldLevelEncryptionConfigAlreadyExistsException
     *         The specified configuration for field-level encryption already exists.
     * @throws TooManyFieldLevelEncryptionConfigsException
     *         The maximum number of configurations for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfig(
            CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchFieldLevelEncryptionProfileException,
            FieldLevelEncryptionConfigAlreadyExistsException, TooManyFieldLevelEncryptionConfigsException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return Result of the CreateFieldLevelEncryptionConfig operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws FieldLevelEncryptionConfigAlreadyExistsException
     *         The specified configuration for field-level encryption already exists.
     * @throws TooManyFieldLevelEncryptionConfigsException
     *         The maximum number of configurations for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfig(
            Consumer<CreateFieldLevelEncryptionConfigRequest.Builder> createFieldLevelEncryptionConfigRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchFieldLevelEncryptionProfileException,
            FieldLevelEncryptionConfigAlreadyExistsException, TooManyFieldLevelEncryptionConfigsException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        return createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(createFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     * @return Result of the CreateFieldLevelEncryptionProfile operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionProfilesException
     *         The maximum number of profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfile(
            CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchPublicKeyException,
            FieldLevelEncryptionProfileAlreadyExistsException, FieldLevelEncryptionProfileSizeExceededException,
            TooManyFieldLevelEncryptionProfilesException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return Result of the CreateFieldLevelEncryptionProfile operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionProfilesException
     *         The maximum number of profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfile(
            Consumer<CreateFieldLevelEncryptionProfileRequest.Builder> createFieldLevelEncryptionProfileRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchPublicKeyException,
            FieldLevelEncryptionProfileAlreadyExistsException, FieldLevelEncryptionProfileSizeExceededException,
            TooManyFieldLevelEncryptionProfilesException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        return createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(createFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Creates a CloudFront function.
     * </p>
     * <p>
     * To create a function, you provide the function code and some configuration information about the function. The
     * response contains an Amazon Resource Name (ARN) that uniquely identifies the function.
     * </p>
     * <p>
     * When you create a function, it's in the <code>DEVELOPMENT</code> stage. In this stage, you can test the function
     * with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     * </p>
     * <p>
     * When you're ready to use your function with a CloudFront distribution, use <code>PublishFunction</code> to copy
     * the function from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. When it's live, you can attach the
     * function to a distribution's cache behavior, using the function's ARN.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws TooManyFunctionsException
     *         You have reached the maximum number of CloudFront functions for this Amazon Web Services account. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws FunctionAlreadyExistsException
     *         A function with the same name already exists in this Amazon Web Services account. To create a function,
     *         you must provide a unique name. To update an existing function, use <code>UpdateFunction</code>.
     * @throws FunctionSizeLimitExceededException
     *         The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws TooManyFunctionsException,
            FunctionAlreadyExistsException, FunctionSizeLimitExceededException, InvalidArgumentException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a CloudFront function.
     * </p>
     * <p>
     * To create a function, you provide the function code and some configuration information about the function. The
     * response contains an Amazon Resource Name (ARN) that uniquely identifies the function.
     * </p>
     * <p>
     * When you create a function, it's in the <code>DEVELOPMENT</code> stage. In this stage, you can test the function
     * with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     * </p>
     * <p>
     * When you're ready to use your function with a CloudFront distribution, use <code>PublishFunction</code> to copy
     * the function from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. When it's live, you can attach the
     * function to a distribution's cache behavior, using the function's ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFunctionRequest#builder()}
     * </p>
     *
     * @param createFunctionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionRequest.Builder} to create a request.
     * @return Result of the CreateFunction operation returned by the service.
     * @throws TooManyFunctionsException
     *         You have reached the maximum number of CloudFront functions for this Amazon Web Services account. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws FunctionAlreadyExistsException
     *         A function with the same name already exists in this Amazon Web Services account. To create a function,
     *         you must provide a unique name. To update an existing function, use <code>UpdateFunction</code>.
     * @throws FunctionSizeLimitExceededException
     *         The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFunctionResponse createFunction(Consumer<CreateFunctionRequest.Builder> createFunctionRequest)
            throws TooManyFunctionsException, FunctionAlreadyExistsException, FunctionSizeLimitExceededException,
            InvalidArgumentException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return createFunction(CreateFunctionRequest.builder().applyMutation(createFunctionRequest).build());
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     *
     * @param createInvalidationRequest
     *        The request to create an invalidation.
     * @return Result of the CreateInvalidation operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws BatchTooLargeException
     *         Invalidation batch specified is too large.
     * @throws TooManyInvalidationsInProgressException
     *         You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation
     *         objects.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInvalidationResponse createInvalidation(CreateInvalidationRequest createInvalidationRequest)
            throws AccessDeniedException, MissingBodyException, InvalidArgumentException, NoSuchDistributionException,
            BatchTooLargeException, TooManyInvalidationsInProgressException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvalidationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInvalidationRequest#builder()}
     * </p>
     *
     * @param createInvalidationRequest
     *        A {@link Consumer} that will call methods on {@link CreateInvalidationRequest.Builder} to create a
     *        request. The request to create an invalidation.
     * @return Result of the CreateInvalidation operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws BatchTooLargeException
     *         Invalidation batch specified is too large.
     * @throws TooManyInvalidationsInProgressException
     *         You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation
     *         objects.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInvalidationResponse createInvalidation(Consumer<CreateInvalidationRequest.Builder> createInvalidationRequest)
            throws AccessDeniedException, MissingBodyException, InvalidArgumentException, NoSuchDistributionException,
            BatchTooLargeException, TooManyInvalidationsInProgressException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return createInvalidation(CreateInvalidationRequest.builder().applyMutation(createInvalidationRequest).build());
    }

    /**
     * <p>
     * Creates a key group that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed
     * URLs and signed cookies</a>.
     * </p>
     * <p>
     * To create a key group, you must specify at least one public key for the key group. After you create a key group,
     * you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior,
     * CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or
     * cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the signature. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
     * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createKeyGroupRequest
     * @return Result of the CreateKeyGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws KeyGroupAlreadyExistsException
     *         A key group with this name already exists. You must provide a unique name. To modify an existing key
     *         group, use <code>UpdateKeyGroup</code>.
     * @throws TooManyKeyGroupsException
     *         You have reached the maximum number of key groups for this Amazon Web Services account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyPublicKeysInKeyGroupException
     *         The number of public keys in this key group is more than the maximum allowed. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKeyGroupResponse createKeyGroup(CreateKeyGroupRequest createKeyGroupRequest) throws InvalidArgumentException,
            KeyGroupAlreadyExistsException, TooManyKeyGroupsException, TooManyPublicKeysInKeyGroupException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a key group that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed
     * URLs and signed cookies</a>.
     * </p>
     * <p>
     * To create a key group, you must specify at least one public key for the key group. After you create a key group,
     * you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior,
     * CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or
     * cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the signature. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
     * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeyGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateKeyGroupRequest#builder()}
     * </p>
     *
     * @param createKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateKeyGroupRequest.Builder} to create a request.
     * @return Result of the CreateKeyGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws KeyGroupAlreadyExistsException
     *         A key group with this name already exists. You must provide a unique name. To modify an existing key
     *         group, use <code>UpdateKeyGroup</code>.
     * @throws TooManyKeyGroupsException
     *         You have reached the maximum number of key groups for this Amazon Web Services account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyPublicKeysInKeyGroupException
     *         The number of public keys in this key group is more than the maximum allowed. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKeyGroupResponse createKeyGroup(Consumer<CreateKeyGroupRequest.Builder> createKeyGroupRequest)
            throws InvalidArgumentException, KeyGroupAlreadyExistsException, TooManyKeyGroupsException,
            TooManyPublicKeysInKeyGroupException, AwsServiceException, SdkClientException, CloudFrontException {
        return createKeyGroup(CreateKeyGroupRequest.builder().applyMutation(createKeyGroupRequest).build());
    }

    /**
     * <p>
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an
     * additional cost.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional"
     * >Viewing additional CloudFront distribution metrics</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createMonitoringSubscriptionRequest
     * @return Result of the CreateMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws MonitoringSubscriptionAlreadyExistsException
     *         A monitoring subscription already exists for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMonitoringSubscriptionResponse createMonitoringSubscription(
            CreateMonitoringSubscriptionRequest createMonitoringSubscriptionRequest) throws AccessDeniedException,
            NoSuchDistributionException, MonitoringSubscriptionAlreadyExistsException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an
     * additional cost.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional"
     * >Viewing additional CloudFront distribution metrics</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitoringSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateMonitoringSubscriptionRequest#builder()}
     * </p>
     *
     * @param createMonitoringSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateMonitoringSubscriptionRequest.Builder} to create
     *        a request.
     * @return Result of the CreateMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws MonitoringSubscriptionAlreadyExistsException
     *         A monitoring subscription already exists for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMonitoringSubscriptionResponse createMonitoringSubscription(
            Consumer<CreateMonitoringSubscriptionRequest.Builder> createMonitoringSubscriptionRequest)
            throws AccessDeniedException, NoSuchDistributionException, MonitoringSubscriptionAlreadyExistsException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return createMonitoringSubscription(CreateMonitoringSubscriptionRequest.builder()
                .applyMutation(createMonitoringSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to
     * an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
     * </p>
     * <p>
     * This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's
     * content only through CloudFront.
     * </p>
     * <p>
     * For more information about using a CloudFront origin access control, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html"
     * >Restricting access to an Amazon Web Services origin</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createOriginAccessControlRequest
     * @return Result of the CreateOriginAccessControl operation returned by the service.
     * @throws OriginAccessControlAlreadyExistsException
     *         An origin access control with the specified parameters already exists.
     * @throws TooManyOriginAccessControlsException
     *         The number of origin access controls in your Amazon Web Services account exceeds the maximum allowed.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOriginAccessControlResponse createOriginAccessControl(
            CreateOriginAccessControlRequest createOriginAccessControlRequest) throws OriginAccessControlAlreadyExistsException,
            TooManyOriginAccessControlsException, InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to
     * an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
     * </p>
     * <p>
     * This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's
     * content only through CloudFront.
     * </p>
     * <p>
     * For more information about using a CloudFront origin access control, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html"
     * >Restricting access to an Amazon Web Services origin</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOriginAccessControlRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOriginAccessControlRequest#builder()}
     * </p>
     *
     * @param createOriginAccessControlRequest
     *        A {@link Consumer} that will call methods on {@link CreateOriginAccessControlRequest.Builder} to create a
     *        request.
     * @return Result of the CreateOriginAccessControl operation returned by the service.
     * @throws OriginAccessControlAlreadyExistsException
     *         An origin access control with the specified parameters already exists.
     * @throws TooManyOriginAccessControlsException
     *         The number of origin access controls in your Amazon Web Services account exceeds the maximum allowed.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOriginAccessControlResponse createOriginAccessControl(
            Consumer<CreateOriginAccessControlRequest.Builder> createOriginAccessControlRequest)
            throws OriginAccessControlAlreadyExistsException, TooManyOriginAccessControlsException, InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return createOriginAccessControl(CreateOriginAccessControlRequest.builder()
                .applyMutation(createOriginAccessControlRequest).build());
    }

    /**
     * <p>
     * Creates an origin request policy.
     * </p>
     * <p>
     * After you create an origin request policy, you can attach it to one or more cache behaviors. When it's attached
     * to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it
     * sends to the origin. Each request that CloudFront sends to the origin includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The request body and the URL path (without the domain name) from the viewer request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The headers that CloudFront automatically includes in every origin request, including <code>Host</code>,
     * <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request
     * policy. These can include items from the viewer request and, in the case of headers, additional ones that are
     * added by CloudFront.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudFront sends a request when it can't find a valid object in its cache that matches the request. If you want
     * to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.
     * </p>
     * <p>
     * For more information about origin request policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html"
     * >Controlling origin requests</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createOriginRequestPolicyRequest
     * @return Result of the CreateOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws OriginRequestPolicyAlreadyExistsException
     *         An origin request policy with this name already exists. You must provide a unique name. To modify an
     *         existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.
     * @throws TooManyOriginRequestPoliciesException
     *         You have reached the maximum number of origin request policies for this Amazon Web Services account. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyHeadersInOriginRequestPolicyException
     *         The number of headers in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInOriginRequestPolicyException
     *         The number of cookies in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInOriginRequestPolicyException
     *         The number of query strings in the origin request policy exceeds the maximum. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOriginRequestPolicyResponse createOriginRequestPolicy(
            CreateOriginRequestPolicyRequest createOriginRequestPolicyRequest) throws AccessDeniedException,
            InconsistentQuantitiesException, InvalidArgumentException, OriginRequestPolicyAlreadyExistsException,
            TooManyOriginRequestPoliciesException, TooManyHeadersInOriginRequestPolicyException,
            TooManyCookiesInOriginRequestPolicyException, TooManyQueryStringsInOriginRequestPolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an origin request policy.
     * </p>
     * <p>
     * After you create an origin request policy, you can attach it to one or more cache behaviors. When it's attached
     * to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it
     * sends to the origin. Each request that CloudFront sends to the origin includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The request body and the URL path (without the domain name) from the viewer request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The headers that CloudFront automatically includes in every origin request, including <code>Host</code>,
     * <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request
     * policy. These can include items from the viewer request and, in the case of headers, additional ones that are
     * added by CloudFront.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudFront sends a request when it can't find a valid object in its cache that matches the request. If you want
     * to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.
     * </p>
     * <p>
     * For more information about origin request policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html"
     * >Controlling origin requests</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOriginRequestPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOriginRequestPolicyRequest#builder()}
     * </p>
     *
     * @param createOriginRequestPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateOriginRequestPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the CreateOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws OriginRequestPolicyAlreadyExistsException
     *         An origin request policy with this name already exists. You must provide a unique name. To modify an
     *         existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.
     * @throws TooManyOriginRequestPoliciesException
     *         You have reached the maximum number of origin request policies for this Amazon Web Services account. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyHeadersInOriginRequestPolicyException
     *         The number of headers in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInOriginRequestPolicyException
     *         The number of cookies in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInOriginRequestPolicyException
     *         The number of query strings in the origin request policy exceeds the maximum. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOriginRequestPolicyResponse createOriginRequestPolicy(
            Consumer<CreateOriginRequestPolicyRequest.Builder> createOriginRequestPolicyRequest) throws AccessDeniedException,
            InconsistentQuantitiesException, InvalidArgumentException, OriginRequestPolicyAlreadyExistsException,
            TooManyOriginRequestPoliciesException, TooManyHeadersInOriginRequestPolicyException,
            TooManyCookiesInOriginRequestPolicyException, TooManyQueryStringsInOriginRequestPolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return createOriginRequestPolicy(CreateOriginRequestPolicyRequest.builder()
                .applyMutation(createOriginRequestPolicyRequest).build());
    }

    /**
     * <p>
     * Uploads a public key to CloudFront that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and
     * signed cookies</a>, or with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level
     * encryption</a>.
     * </p>
     *
     * @param createPublicKeyRequest
     * @return Result of the CreatePublicKey operation returned by the service.
     * @throws PublicKeyAlreadyExistsException
     *         The specified public key already exists.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws TooManyPublicKeysException
     *         The maximum number of public keys for field-level encryption have been created. To create a new public
     *         key, delete one of the existing keys.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePublicKeyResponse createPublicKey(CreatePublicKeyRequest createPublicKeyRequest)
            throws PublicKeyAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads a public key to CloudFront that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and
     * signed cookies</a>, or with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level
     * encryption</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePublicKeyRequest#builder()}
     * </p>
     *
     * @param createPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link CreatePublicKeyRequest.Builder} to create a request.
     * @return Result of the CreatePublicKey operation returned by the service.
     * @throws PublicKeyAlreadyExistsException
     *         The specified public key already exists.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws TooManyPublicKeysException
     *         The maximum number of public keys for field-level encryption have been created. To create a new public
     *         key, delete one of the existing keys.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePublicKeyResponse createPublicKey(Consumer<CreatePublicKeyRequest.Builder> createPublicKeyRequest)
            throws PublicKeyAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return createPublicKey(CreatePublicKeyRequest.builder().applyMutation(createPublicKeyRequest).build());
    }

    /**
     * <p>
     * Creates a real-time log configuration.
     * </p>
     * <p>
     * After you create a real-time log configuration, you can attach it to one or more cache behaviors to send
     * real-time log data to the specified Amazon Kinesis data stream.
     * </p>
     * <p>
     * For more information about real-time log configurations, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createRealtimeLogConfigRequest
     * @return Result of the CreateRealtimeLogConfig operation returned by the service.
     * @throws RealtimeLogConfigAlreadyExistsException
     *         A real-time log configuration with this name already exists. You must provide a unique name. To modify an
     *         existing real-time log configuration, use <code>UpdateRealtimeLogConfig</code>.
     * @throws TooManyRealtimeLogConfigsException
     *         You have reached the maximum number of real-time log configurations for this Amazon Web Services account.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRealtimeLogConfigResponse createRealtimeLogConfig(CreateRealtimeLogConfigRequest createRealtimeLogConfigRequest)
            throws RealtimeLogConfigAlreadyExistsException, TooManyRealtimeLogConfigsException, InvalidArgumentException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a real-time log configuration.
     * </p>
     * <p>
     * After you create a real-time log configuration, you can attach it to one or more cache behaviors to send
     * real-time log data to the specified Amazon Kinesis data stream.
     * </p>
     * <p>
     * For more information about real-time log configurations, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRealtimeLogConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param createRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateRealtimeLogConfigRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRealtimeLogConfig operation returned by the service.
     * @throws RealtimeLogConfigAlreadyExistsException
     *         A real-time log configuration with this name already exists. You must provide a unique name. To modify an
     *         existing real-time log configuration, use <code>UpdateRealtimeLogConfig</code>.
     * @throws TooManyRealtimeLogConfigsException
     *         You have reached the maximum number of real-time log configurations for this Amazon Web Services account.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRealtimeLogConfigResponse createRealtimeLogConfig(
            Consumer<CreateRealtimeLogConfigRequest.Builder> createRealtimeLogConfigRequest)
            throws RealtimeLogConfigAlreadyExistsException, TooManyRealtimeLogConfigsException, InvalidArgumentException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        return createRealtimeLogConfig(CreateRealtimeLogConfigRequest.builder().applyMutation(createRealtimeLogConfigRequest)
                .build());
    }

    /**
     * <p>
     * Creates a response headers policy.
     * </p>
     * <p>
     * A response headers policy contains information about a set of HTTP headers. To create a response headers policy,
     * you provide some metadata about the policy and a set of configurations that specify the headers.
     * </p>
     * <p>
     * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a
     * CloudFront distribution. When it's attached to a cache behavior, the response headers policy affects the HTTP
     * headers that CloudFront includes in HTTP responses to requests that match the cache behavior. CloudFront adds or
     * removes response headers according to the configuration of the response headers policy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html">Adding
     * or removing HTTP headers in CloudFront responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createResponseHeadersPolicyRequest
     * @return Result of the CreateResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws ResponseHeadersPolicyAlreadyExistsException
     *         A response headers policy with this name already exists. You must provide a unique name. To modify an
     *         existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.
     * @throws TooManyResponseHeadersPoliciesException
     *         You have reached the maximum number of response headers policies for this Amazon Web Services
     *         account.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCustomHeadersInResponseHeadersPolicyException
     *         The number of custom headers in the response headers policy exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooLongCspInResponseHeadersPolicyException
     *         The length of the <code>Content-Security-Policy</code> header value in the response headers policy
     *         exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyRemoveHeadersInResponseHeadersPolicyException
     *         The number of headers in <code>RemoveHeadersConfig</code> in the response headers policy exceeds the
     *         maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResponseHeadersPolicyResponse createResponseHeadersPolicy(
            CreateResponseHeadersPolicyRequest createResponseHeadersPolicyRequest) throws AccessDeniedException,
            InconsistentQuantitiesException, InvalidArgumentException, ResponseHeadersPolicyAlreadyExistsException,
            TooManyResponseHeadersPoliciesException, TooManyCustomHeadersInResponseHeadersPolicyException,
            TooLongCspInResponseHeadersPolicyException, TooManyRemoveHeadersInResponseHeadersPolicyException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a response headers policy.
     * </p>
     * <p>
     * A response headers policy contains information about a set of HTTP headers. To create a response headers policy,
     * you provide some metadata about the policy and a set of configurations that specify the headers.
     * </p>
     * <p>
     * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a
     * CloudFront distribution. When it's attached to a cache behavior, the response headers policy affects the HTTP
     * headers that CloudFront includes in HTTP responses to requests that match the cache behavior. CloudFront adds or
     * removes response headers according to the configuration of the response headers policy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html">Adding
     * or removing HTTP headers in CloudFront responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResponseHeadersPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResponseHeadersPolicyRequest#builder()}
     * </p>
     *
     * @param createResponseHeadersPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateResponseHeadersPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the CreateResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws ResponseHeadersPolicyAlreadyExistsException
     *         A response headers policy with this name already exists. You must provide a unique name. To modify an
     *         existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.
     * @throws TooManyResponseHeadersPoliciesException
     *         You have reached the maximum number of response headers policies for this Amazon Web Services
     *         account.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCustomHeadersInResponseHeadersPolicyException
     *         The number of custom headers in the response headers policy exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooLongCspInResponseHeadersPolicyException
     *         The length of the <code>Content-Security-Policy</code> header value in the response headers policy
     *         exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyRemoveHeadersInResponseHeadersPolicyException
     *         The number of headers in <code>RemoveHeadersConfig</code> in the response headers policy exceeds the
     *         maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResponseHeadersPolicyResponse createResponseHeadersPolicy(
            Consumer<CreateResponseHeadersPolicyRequest.Builder> createResponseHeadersPolicyRequest)
            throws AccessDeniedException, InconsistentQuantitiesException, InvalidArgumentException,
            ResponseHeadersPolicyAlreadyExistsException, TooManyResponseHeadersPoliciesException,
            TooManyCustomHeadersInResponseHeadersPolicyException, TooLongCspInResponseHeadersPolicyException,
            TooManyRemoveHeadersInResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        return createResponseHeadersPolicy(CreateResponseHeadersPolicyRequest.builder()
                .applyMutation(createResponseHeadersPolicyRequest).build());
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     *
     * @param createStreamingDistributionRequest
     *        The request to create a new streaming distribution.
     * @return Result of the CreateStreamingDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStreamingDistributionResponse createStreamingDistribution(
            CreateStreamingDistributionRequest createStreamingDistributionRequest) throws CnameAlreadyExistsException,
            StreamingDistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException,
            TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param createStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingDistributionRequest.Builder} to create
     *        a request. The request to create a new streaming distribution.
     * @return Result of the CreateStreamingDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStreamingDistributionResponse createStreamingDistribution(
            Consumer<CreateStreamingDistributionRequest.Builder> createStreamingDistributionRequest)
            throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, AccessDeniedException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException,
            TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        return createStreamingDistribution(CreateStreamingDistributionRequest.builder()
                .applyMutation(createStreamingDistributionRequest).build());
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        The request to create a new streaming distribution with tags.
     * @return Result of the CreateStreamingDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTags(
            CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest)
            throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, AccessDeniedException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException,
            TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException,
            InconsistentQuantitiesException, InvalidTaggingException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingDistributionWithTagsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStreamingDistributionWithTagsRequest#builder()}
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingDistributionWithTagsRequest.Builder} to
     *        create a request. The request to create a new streaming distribution with tags.
     * @return Result of the CreateStreamingDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTags(
            Consumer<CreateStreamingDistributionWithTagsRequest.Builder> createStreamingDistributionWithTagsRequest)
            throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, AccessDeniedException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException,
            TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException,
            InconsistentQuantitiesException, InvalidTaggingException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest.builder()
                .applyMutation(createStreamingDistributionWithTagsRequest).build());
    }

    /**
     * <p>
     * Deletes a cache policy.
     * </p>
     * <p>
     * You cannot delete a cache policy if it's attached to a cache behavior. First update your distributions to remove
     * the cache policy from all cache behaviors, then delete the cache policy.
     * </p>
     * <p>
     * To delete a cache policy, you must provide the policy's identifier and version. To get these values, you can use
     * <code>ListCachePolicies</code> or <code>GetCachePolicy</code>.
     * </p>
     *
     * @param deleteCachePolicyRequest
     * @return Result of the DeleteCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws CachePolicyInUseException
     *         Cannot delete the cache policy because it is attached to one or more cache behaviors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCachePolicyResponse deleteCachePolicy(DeleteCachePolicyRequest deleteCachePolicyRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCachePolicyException,
            PreconditionFailedException, IllegalDeleteException, CachePolicyInUseException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cache policy.
     * </p>
     * <p>
     * You cannot delete a cache policy if it's attached to a cache behavior. First update your distributions to remove
     * the cache policy from all cache behaviors, then delete the cache policy.
     * </p>
     * <p>
     * To delete a cache policy, you must provide the policy's identifier and version. To get these values, you can use
     * <code>ListCachePolicies</code> or <code>GetCachePolicy</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCachePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCachePolicyRequest#builder()}
     * </p>
     *
     * @param deleteCachePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCachePolicyRequest.Builder} to create a request.
     * @return Result of the DeleteCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws CachePolicyInUseException
     *         Cannot delete the cache policy because it is attached to one or more cache behaviors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCachePolicyResponse deleteCachePolicy(Consumer<DeleteCachePolicyRequest.Builder> deleteCachePolicyRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCachePolicyException,
            PreconditionFailedException, IllegalDeleteException, CachePolicyInUseException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return deleteCachePolicy(DeleteCachePolicyRequest.builder().applyMutation(deleteCachePolicyRequest).build());
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        Deletes a origin access identity.
     * @return Result of the DeleteCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws CloudFrontOriginAccessIdentityInUseException
     *         The Origin Access Identity specified is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentity(
            DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCloudFrontOriginAccessIdentityException,
            PreconditionFailedException, CloudFrontOriginAccessIdentityInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. Deletes a origin access identity.
     * @return Result of the DeleteCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws CloudFrontOriginAccessIdentityInUseException
     *         The Origin Access Identity specified is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentity(
            Consumer<DeleteCloudFrontOriginAccessIdentityRequest.Builder> deleteCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCloudFrontOriginAccessIdentityException,
            PreconditionFailedException, CloudFrontOriginAccessIdentityInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(deleteCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Deletes a continuous deployment policy.
     * </p>
     * <p>
     * You cannot delete a continuous deployment policy that's attached to a primary distribution. First update your
     * distribution to remove the continuous deployment policy, then you can delete the policy.
     * </p>
     *
     * @param deleteContinuousDeploymentPolicyRequest
     * @return Result of the DeleteContinuousDeploymentPolicy operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContinuousDeploymentPolicyResponse deleteContinuousDeploymentPolicy(
            DeleteContinuousDeploymentPolicyRequest deleteContinuousDeploymentPolicyRequest)
            throws InvalidIfMatchVersionException, InvalidArgumentException, AccessDeniedException, PreconditionFailedException,
            ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a continuous deployment policy.
     * </p>
     * <p>
     * You cannot delete a continuous deployment policy that's attached to a primary distribution. First update your
     * distribution to remove the continuous deployment policy, then you can delete the policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContinuousDeploymentPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteContinuousDeploymentPolicyRequest#builder()}
     * </p>
     *
     * @param deleteContinuousDeploymentPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContinuousDeploymentPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteContinuousDeploymentPolicy operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContinuousDeploymentPolicyResponse deleteContinuousDeploymentPolicy(
            Consumer<DeleteContinuousDeploymentPolicyRequest.Builder> deleteContinuousDeploymentPolicyRequest)
            throws InvalidIfMatchVersionException, InvalidArgumentException, AccessDeniedException, PreconditionFailedException,
            ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return deleteContinuousDeploymentPolicy(DeleteContinuousDeploymentPolicyRequest.builder()
                .applyMutation(deleteContinuousDeploymentPolicyRequest).build());
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     *        This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the
     *        following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return Result of the DeleteDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws DistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDistributionResponse deleteDistribution(DeleteDistributionRequest deleteDistributionRequest)
            throws AccessDeniedException, DistributionNotDisabledException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDistributionRequest#builder()}
     * </p>
     *
     * @param deleteDistributionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDistributionRequest.Builder} to create a
     *        request. This action deletes a web distribution. To delete a web distribution using the CloudFront API,
     *        perform the following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return Result of the DeleteDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws DistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDistributionResponse deleteDistribution(Consumer<DeleteDistributionRequest.Builder> deleteDistributionRequest)
            throws AccessDeniedException, DistributionNotDisabledException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteDistribution(DeleteDistributionRequest.builder().applyMutation(deleteDistributionRequest).build());
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     * @return Result of the DeleteFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionConfigInUseException
     *         The specified configuration for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfig(
            DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            FieldLevelEncryptionConfigInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionConfigInUseException
     *         The specified configuration for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfig(
            Consumer<DeleteFieldLevelEncryptionConfigRequest.Builder> deleteFieldLevelEncryptionConfigRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionConfigException,
            PreconditionFailedException, FieldLevelEncryptionConfigInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(deleteFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     * @return Result of the DeleteFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileInUseException
     *         The specified profile for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfile(
            DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileInUseException
     *         The specified profile for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfile(
            Consumer<DeleteFieldLevelEncryptionProfileRequest.Builder> deleteFieldLevelEncryptionProfileRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException,
            PreconditionFailedException, FieldLevelEncryptionProfileInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(deleteFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a CloudFront function.
     * </p>
     * <p>
     * You cannot delete a function if it's associated with a cache behavior. First, update your distributions to remove
     * the function association from all cache behaviors, then delete the function.
     * </p>
     * <p>
     * To delete a function, you must provide the function's name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws FunctionInUseException
     *         Cannot delete the function because it's attached to one or more cache behaviors.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest)
            throws InvalidIfMatchVersionException, NoSuchFunctionExistsException, FunctionInUseException,
            PreconditionFailedException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CloudFront function.
     * </p>
     * <p>
     * You cannot delete a function if it's associated with a cache behavior. First, update your distributions to remove
     * the function association from all cache behaviors, then delete the function.
     * </p>
     * <p>
     * To delete a function, you must provide the function's name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFunctionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionRequest.Builder} to create a request.
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws FunctionInUseException
     *         Cannot delete the function because it's attached to one or more cache behaviors.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFunctionResponse deleteFunction(Consumer<DeleteFunctionRequest.Builder> deleteFunctionRequest)
            throws InvalidIfMatchVersionException, NoSuchFunctionExistsException, FunctionInUseException,
            PreconditionFailedException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return deleteFunction(DeleteFunctionRequest.builder().applyMutation(deleteFunctionRequest).build());
    }

    /**
     * <p>
     * Deletes a key group.
     * </p>
     * <p>
     * You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove
     * the key group from all cache behaviors, then delete the key group.
     * </p>
     * <p>
     * To delete a key group, you must provide the key group's identifier and version. To get these values, use
     * <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     *
     * @param deleteKeyGroupRequest
     * @return Result of the DeleteKeyGroup operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ResourceInUseException
     *         Cannot delete this resource because it is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKeyGroupResponse deleteKeyGroup(DeleteKeyGroupRequest deleteKeyGroupRequest)
            throws InvalidIfMatchVersionException, NoSuchResourceException, PreconditionFailedException, ResourceInUseException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a key group.
     * </p>
     * <p>
     * You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove
     * the key group from all cache behaviors, then delete the key group.
     * </p>
     * <p>
     * To delete a key group, you must provide the key group's identifier and version. To get these values, use
     * <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeyGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeyGroupRequest#builder()}
     * </p>
     *
     * @param deleteKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteKeyGroupRequest.Builder} to create a request.
     * @return Result of the DeleteKeyGroup operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ResourceInUseException
     *         Cannot delete this resource because it is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKeyGroupResponse deleteKeyGroup(Consumer<DeleteKeyGroupRequest.Builder> deleteKeyGroupRequest)
            throws InvalidIfMatchVersionException, NoSuchResourceException, PreconditionFailedException, ResourceInUseException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return deleteKeyGroup(DeleteKeyGroupRequest.builder().applyMutation(deleteKeyGroupRequest).build());
    }

    /**
     * <p>
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     * </p>
     *
     * @param deleteMonitoringSubscriptionRequest
     * @return Result of the DeleteMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws NoSuchMonitoringSubscriptionException
     *         A monitoring subscription does not exist for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMonitoringSubscriptionResponse deleteMonitoringSubscription(
            DeleteMonitoringSubscriptionRequest deleteMonitoringSubscriptionRequest) throws AccessDeniedException,
            NoSuchDistributionException, NoSuchMonitoringSubscriptionException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitoringSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMonitoringSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteMonitoringSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMonitoringSubscriptionRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws NoSuchMonitoringSubscriptionException
     *         A monitoring subscription does not exist for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMonitoringSubscriptionResponse deleteMonitoringSubscription(
            Consumer<DeleteMonitoringSubscriptionRequest.Builder> deleteMonitoringSubscriptionRequest)
            throws AccessDeniedException, NoSuchDistributionException, NoSuchMonitoringSubscriptionException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return deleteMonitoringSubscription(DeleteMonitoringSubscriptionRequest.builder()
                .applyMutation(deleteMonitoringSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes a CloudFront origin access control.
     * </p>
     * <p>
     * You cannot delete an origin access control if it's in use. First, update all distributions to remove the origin
     * access control from all origins, then delete the origin access control.
     * </p>
     *
     * @param deleteOriginAccessControlRequest
     * @return Result of the DeleteOriginAccessControl operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws OriginAccessControlInUseException
     *         Cannot delete the origin access control because it's in use by one or more distributions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOriginAccessControlResponse deleteOriginAccessControl(
            DeleteOriginAccessControlRequest deleteOriginAccessControlRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchOriginAccessControlException, PreconditionFailedException,
            OriginAccessControlInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CloudFront origin access control.
     * </p>
     * <p>
     * You cannot delete an origin access control if it's in use. First, update all distributions to remove the origin
     * access control from all origins, then delete the origin access control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOriginAccessControlRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOriginAccessControlRequest#builder()}
     * </p>
     *
     * @param deleteOriginAccessControlRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOriginAccessControlRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteOriginAccessControl operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws OriginAccessControlInUseException
     *         Cannot delete the origin access control because it's in use by one or more distributions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOriginAccessControlResponse deleteOriginAccessControl(
            Consumer<DeleteOriginAccessControlRequest.Builder> deleteOriginAccessControlRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchOriginAccessControlException, PreconditionFailedException,
            OriginAccessControlInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        return deleteOriginAccessControl(DeleteOriginAccessControlRequest.builder()
                .applyMutation(deleteOriginAccessControlRequest).build());
    }

    /**
     * <p>
     * Deletes an origin request policy.
     * </p>
     * <p>
     * You cannot delete an origin request policy if it's attached to any cache behaviors. First update your
     * distributions to remove the origin request policy from all cache behaviors, then delete the origin request
     * policy.
     * </p>
     * <p>
     * To delete an origin request policy, you must provide the policy's identifier and version. To get the identifier,
     * you can use <code>ListOriginRequestPolicies</code> or <code>GetOriginRequestPolicy</code>.
     * </p>
     *
     * @param deleteOriginRequestPolicyRequest
     * @return Result of the DeleteOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws OriginRequestPolicyInUseException
     *         Cannot delete the origin request policy because it is attached to one or more cache behaviors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOriginRequestPolicyResponse deleteOriginRequestPolicy(
            DeleteOriginRequestPolicyRequest deleteOriginRequestPolicyRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchOriginRequestPolicyException, PreconditionFailedException,
            IllegalDeleteException, OriginRequestPolicyInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an origin request policy.
     * </p>
     * <p>
     * You cannot delete an origin request policy if it's attached to any cache behaviors. First update your
     * distributions to remove the origin request policy from all cache behaviors, then delete the origin request
     * policy.
     * </p>
     * <p>
     * To delete an origin request policy, you must provide the policy's identifier and version. To get the identifier,
     * you can use <code>ListOriginRequestPolicies</code> or <code>GetOriginRequestPolicy</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOriginRequestPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOriginRequestPolicyRequest#builder()}
     * </p>
     *
     * @param deleteOriginRequestPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOriginRequestPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws OriginRequestPolicyInUseException
     *         Cannot delete the origin request policy because it is attached to one or more cache behaviors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOriginRequestPolicyResponse deleteOriginRequestPolicy(
            Consumer<DeleteOriginRequestPolicyRequest.Builder> deleteOriginRequestPolicyRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchOriginRequestPolicyException, PreconditionFailedException,
            IllegalDeleteException, OriginRequestPolicyInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteOriginRequestPolicy(DeleteOriginRequestPolicyRequest.builder()
                .applyMutation(deleteOriginRequestPolicyRequest).build());
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     *
     * @param deletePublicKeyRequest
     * @return Result of the DeletePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PublicKeyInUseException
     *         The specified public key is in use.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeletePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeletePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePublicKeyResponse deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) throws AccessDeniedException,
            PublicKeyInUseException, InvalidIfMatchVersionException, NoSuchPublicKeyException, PreconditionFailedException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePublicKeyRequest#builder()}
     * </p>
     *
     * @param deletePublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePublicKeyRequest.Builder} to create a request.
     * @return Result of the DeletePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PublicKeyInUseException
     *         The specified public key is in use.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeletePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeletePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePublicKeyResponse deletePublicKey(Consumer<DeletePublicKeyRequest.Builder> deletePublicKeyRequest)
            throws AccessDeniedException, PublicKeyInUseException, InvalidIfMatchVersionException, NoSuchPublicKeyException,
            PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        return deletePublicKey(DeletePublicKeyRequest.builder().applyMutation(deletePublicKeyRequest).build());
    }

    /**
     * <p>
     * Deletes a real-time log configuration.
     * </p>
     * <p>
     * You cannot delete a real-time log configuration if it's attached to a cache behavior. First update your
     * distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log
     * configuration.
     * </p>
     * <p>
     * To delete a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to delete.
     * </p>
     *
     * @param deleteRealtimeLogConfigRequest
     * @return Result of the DeleteRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigInUseException
     *         Cannot delete the real-time log configuration because it is attached to one or more cache behaviors.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRealtimeLogConfigResponse deleteRealtimeLogConfig(DeleteRealtimeLogConfigRequest deleteRealtimeLogConfigRequest)
            throws NoSuchRealtimeLogConfigException, RealtimeLogConfigInUseException, InvalidArgumentException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a real-time log configuration.
     * </p>
     * <p>
     * You cannot delete a real-time log configuration if it's attached to a cache behavior. First update your
     * distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log
     * configuration.
     * </p>
     * <p>
     * To delete a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to delete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRealtimeLogConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param deleteRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRealtimeLogConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigInUseException
     *         Cannot delete the real-time log configuration because it is attached to one or more cache behaviors.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRealtimeLogConfigResponse deleteRealtimeLogConfig(
            Consumer<DeleteRealtimeLogConfigRequest.Builder> deleteRealtimeLogConfigRequest)
            throws NoSuchRealtimeLogConfigException, RealtimeLogConfigInUseException, InvalidArgumentException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        return deleteRealtimeLogConfig(DeleteRealtimeLogConfigRequest.builder().applyMutation(deleteRealtimeLogConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a response headers policy.
     * </p>
     * <p>
     * You cannot delete a response headers policy if it's attached to a cache behavior. First update your distributions
     * to remove the response headers policy from all cache behaviors, then delete the response headers policy.
     * </p>
     * <p>
     * To delete a response headers policy, you must provide the policy's identifier and version. To get these values,
     * you can use <code>ListResponseHeadersPolicies</code> or <code>GetResponseHeadersPolicy</code>.
     * </p>
     *
     * @param deleteResponseHeadersPolicyRequest
     * @return Result of the DeleteResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws ResponseHeadersPolicyInUseException
     *         Cannot delete the response headers policy because it is attached to one or more cache behaviors in a
     *         CloudFront distribution.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResponseHeadersPolicyResponse deleteResponseHeadersPolicy(
            DeleteResponseHeadersPolicyRequest deleteResponseHeadersPolicyRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchResponseHeadersPolicyException, PreconditionFailedException,
            IllegalDeleteException, ResponseHeadersPolicyInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a response headers policy.
     * </p>
     * <p>
     * You cannot delete a response headers policy if it's attached to a cache behavior. First update your distributions
     * to remove the response headers policy from all cache behaviors, then delete the response headers policy.
     * </p>
     * <p>
     * To delete a response headers policy, you must provide the policy's identifier and version. To get these values,
     * you can use <code>ListResponseHeadersPolicies</code> or <code>GetResponseHeadersPolicy</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResponseHeadersPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResponseHeadersPolicyRequest#builder()}
     * </p>
     *
     * @param deleteResponseHeadersPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResponseHeadersPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws ResponseHeadersPolicyInUseException
     *         Cannot delete the response headers policy because it is attached to one or more cache behaviors in a
     *         CloudFront distribution.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResponseHeadersPolicyResponse deleteResponseHeadersPolicy(
            Consumer<DeleteResponseHeadersPolicyRequest.Builder> deleteResponseHeadersPolicyRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchResponseHeadersPolicyException,
            PreconditionFailedException, IllegalDeleteException, ResponseHeadersPolicyInUseException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return deleteResponseHeadersPolicy(DeleteResponseHeadersPolicyRequest.builder()
                .applyMutation(deleteResponseHeadersPolicyRequest).build());
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        The request to delete a streaming distribution.
     * @return Result of the DeleteStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws StreamingDistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStreamingDistributionResponse deleteStreamingDistribution(
            DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) throws AccessDeniedException,
            StreamingDistributionNotDisabledException, InvalidIfMatchVersionException, NoSuchStreamingDistributionException,
            PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStreamingDistributionRequest.Builder} to create
     *        a request. The request to delete a streaming distribution.
     * @return Result of the DeleteStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws StreamingDistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStreamingDistributionResponse deleteStreamingDistribution(
            Consumer<DeleteStreamingDistributionRequest.Builder> deleteStreamingDistributionRequest)
            throws AccessDeniedException, StreamingDistributionNotDisabledException, InvalidIfMatchVersionException,
            NoSuchStreamingDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteStreamingDistribution(DeleteStreamingDistributionRequest.builder()
                .applyMutation(deleteStreamingDistributionRequest).build());
    }

    /**
     * <p>
     * Gets configuration information and metadata about a CloudFront function, but not the function's code. To get a
     * function's code, use <code>GetFunction</code>.
     * </p>
     * <p>
     * To get configuration information and metadata about a function, you must provide the function's name and stage.
     * To get these values, you can use <code>ListFunctions</code>.
     * </p>
     *
     * @param describeFunctionRequest
     * @return Result of the DescribeFunction operation returned by the service.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DescribeFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DescribeFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFunctionResponse describeFunction(DescribeFunctionRequest describeFunctionRequest)
            throws NoSuchFunctionExistsException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets configuration information and metadata about a CloudFront function, but not the function's code. To get a
     * function's code, use <code>GetFunction</code>.
     * </p>
     * <p>
     * To get configuration information and metadata about a function, you must provide the function's name and stage.
     * To get these values, you can use <code>ListFunctions</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFunctionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFunctionRequest#builder()}
     * </p>
     *
     * @param describeFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFunctionRequest.Builder} to create a request.
     * @return Result of the DescribeFunction operation returned by the service.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DescribeFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DescribeFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFunctionResponse describeFunction(Consumer<DescribeFunctionRequest.Builder> describeFunctionRequest)
            throws NoSuchFunctionExistsException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return describeFunction(DescribeFunctionRequest.builder().applyMutation(describeFunctionRequest).build());
    }

    /**
     * <p>
     * Gets a cache policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy's identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get a cache policy, you must provide the policy's identifier. If the cache policy is attached to a
     * distribution's cache behavior, you can get the policy's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     *
     * @param getCachePolicyRequest
     * @return Result of the GetCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCachePolicyResponse getCachePolicy(GetCachePolicyRequest getCachePolicyRequest) throws AccessDeniedException,
            NoSuchCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a cache policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy's identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get a cache policy, you must provide the policy's identifier. If the cache policy is attached to a
     * distribution's cache behavior, you can get the policy's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCachePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetCachePolicyRequest#builder()}
     * </p>
     *
     * @param getCachePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetCachePolicyRequest.Builder} to create a request.
     * @return Result of the GetCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCachePolicyResponse getCachePolicy(Consumer<GetCachePolicyRequest.Builder> getCachePolicyRequest)
            throws AccessDeniedException, NoSuchCachePolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getCachePolicy(GetCachePolicyRequest.builder().applyMutation(getCachePolicyRequest).build());
    }

    /**
     * <p>
     * Gets a cache policy configuration.
     * </p>
     * <p>
     * To get a cache policy configuration, you must provide the policy's identifier. If the cache policy is attached to
     * a distribution's cache behavior, you can get the policy's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     *
     * @param getCachePolicyConfigRequest
     * @return Result of the GetCachePolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCachePolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCachePolicyConfigResponse getCachePolicyConfig(GetCachePolicyConfigRequest getCachePolicyConfigRequest)
            throws AccessDeniedException, NoSuchCachePolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a cache policy configuration.
     * </p>
     * <p>
     * To get a cache policy configuration, you must provide the policy's identifier. If the cache policy is attached to
     * a distribution's cache behavior, you can get the policy's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCachePolicyConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetCachePolicyConfigRequest#builder()}
     * </p>
     *
     * @param getCachePolicyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetCachePolicyConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetCachePolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCachePolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCachePolicyConfigResponse getCachePolicyConfig(
            Consumer<GetCachePolicyConfigRequest.Builder> getCachePolicyConfigRequest) throws AccessDeniedException,
            NoSuchCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        return getCachePolicyConfig(GetCachePolicyConfigRequest.builder().applyMutation(getCachePolicyConfigRequest).build());
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        The request to get an origin access identity's information.
     * @return Result of the GetCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentity(
            GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudFrontOriginAccessIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link GetCloudFrontOriginAccessIdentityRequest.Builder} to
     *        create a request. The request to get an origin access identity's information.
     * @return Result of the GetCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentity(
            Consumer<GetCloudFrontOriginAccessIdentityRequest.Builder> getCloudFrontOriginAccessIdentityRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(getCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        The origin access identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return Result of the GetCloudFrontOriginAccessIdentityConfig operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfig(
            GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetCloudFrontOriginAccessIdentityConfigRequest.Builder} avoiding the need to create one manually via
     * {@link GetCloudFrontOriginAccessIdentityConfigRequest#builder()}
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetCloudFrontOriginAccessIdentityConfigRequest.Builder} to create a request. The origin access
     *        identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return Result of the GetCloudFrontOriginAccessIdentityConfig operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfig(
            Consumer<GetCloudFrontOriginAccessIdentityConfigRequest.Builder> getCloudFrontOriginAccessIdentityConfigRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest.builder()
                .applyMutation(getCloudFrontOriginAccessIdentityConfigRequest).build());
    }

    /**
     * <p>
     * Gets a continuous deployment policy, including metadata (the policy's identifier and the date and time when the
     * policy was last modified).
     * </p>
     *
     * @param getContinuousDeploymentPolicyRequest
     * @return Result of the GetContinuousDeploymentPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContinuousDeploymentPolicyResponse getContinuousDeploymentPolicy(
            GetContinuousDeploymentPolicyRequest getContinuousDeploymentPolicyRequest) throws AccessDeniedException,
            NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a continuous deployment policy, including metadata (the policy's identifier and the date and time when the
     * policy was last modified).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContinuousDeploymentPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetContinuousDeploymentPolicyRequest#builder()}
     * </p>
     *
     * @param getContinuousDeploymentPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetContinuousDeploymentPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetContinuousDeploymentPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContinuousDeploymentPolicyResponse getContinuousDeploymentPolicy(
            Consumer<GetContinuousDeploymentPolicyRequest.Builder> getContinuousDeploymentPolicyRequest)
            throws AccessDeniedException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getContinuousDeploymentPolicy(GetContinuousDeploymentPolicyRequest.builder()
                .applyMutation(getContinuousDeploymentPolicyRequest).build());
    }

    /**
     * <p>
     * Gets configuration information about a continuous deployment policy.
     * </p>
     *
     * @param getContinuousDeploymentPolicyConfigRequest
     * @return Result of the GetContinuousDeploymentPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetContinuousDeploymentPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetContinuousDeploymentPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContinuousDeploymentPolicyConfigResponse getContinuousDeploymentPolicyConfig(
            GetContinuousDeploymentPolicyConfigRequest getContinuousDeploymentPolicyConfigRequest) throws AccessDeniedException,
            NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets configuration information about a continuous deployment policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContinuousDeploymentPolicyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetContinuousDeploymentPolicyConfigRequest#builder()}
     * </p>
     *
     * @param getContinuousDeploymentPolicyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetContinuousDeploymentPolicyConfigRequest.Builder} to
     *        create a request.
     * @return Result of the GetContinuousDeploymentPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetContinuousDeploymentPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetContinuousDeploymentPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetContinuousDeploymentPolicyConfigResponse getContinuousDeploymentPolicyConfig(
            Consumer<GetContinuousDeploymentPolicyConfigRequest.Builder> getContinuousDeploymentPolicyConfigRequest)
            throws AccessDeniedException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getContinuousDeploymentPolicyConfig(GetContinuousDeploymentPolicyConfigRequest.builder()
                .applyMutation(getContinuousDeploymentPolicyConfigRequest).build());
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     *
     * @param getDistributionRequest
     *        The request to get a distribution's information.
     * @return Result of the GetDistribution operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDistributionResponse getDistribution(GetDistributionRequest getDistributionRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionRequest.Builder} avoiding the need
     * to create one manually via {@link GetDistributionRequest#builder()}
     * </p>
     *
     * @param getDistributionRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionRequest.Builder} to create a request.
     *        The request to get a distribution's information.
     * @return Result of the GetDistribution operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDistributionResponse getDistribution(Consumer<GetDistributionRequest.Builder> getDistributionRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getDistribution(GetDistributionRequest.builder().applyMutation(getDistributionRequest).build());
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     *
     * @param getDistributionConfigRequest
     *        The request to get a distribution configuration.
     * @return Result of the GetDistributionConfig operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionConfigResponse getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetDistributionConfigRequest#builder()}
     * </p>
     *
     * @param getDistributionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionConfigRequest.Builder} to create a
     *        request. The request to get a distribution configuration.
     * @return Result of the GetDistributionConfig operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionConfigResponse getDistributionConfig(
            Consumer<GetDistributionConfigRequest.Builder> getDistributionConfigRequest) throws NoSuchDistributionException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        return getDistributionConfig(GetDistributionConfigRequest.builder().applyMutation(getDistributionConfigRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     * @return Result of the GetFieldLevelEncryption operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionResponse getFieldLevelEncryption(GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionRequest.Builder} avoiding
     * the need to create one manually via {@link GetFieldLevelEncryptionRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionRequest.Builder} to create a
     *        request.
     * @return Result of the GetFieldLevelEncryption operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionResponse getFieldLevelEncryption(
            Consumer<GetFieldLevelEncryptionRequest.Builder> getFieldLevelEncryptionRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        return getFieldLevelEncryption(GetFieldLevelEncryptionRequest.builder().applyMutation(getFieldLevelEncryptionRequest)
                .build());
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     * @return Result of the GetFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfig(
            GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return Result of the GetFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfig(
            Consumer<GetFieldLevelEncryptionConfigRequest.Builder> getFieldLevelEncryptionConfigRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(getFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     * @return Result of the GetFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfile(
            GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link GetFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return Result of the GetFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfile(
            Consumer<GetFieldLevelEncryptionProfileRequest.Builder> getFieldLevelEncryptionProfileRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(getFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     * @return Result of the GetFieldLevelEncryptionProfileConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfig(
            GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetFieldLevelEncryptionProfileConfigRequest.Builder} avoiding the need to create one manually via
     * {@link GetFieldLevelEncryptionProfileConfigRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionProfileConfigRequest.Builder}
     *        to create a request.
     * @return Result of the GetFieldLevelEncryptionProfileConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfig(
            Consumer<GetFieldLevelEncryptionProfileConfigRequest.Builder> getFieldLevelEncryptionProfileConfigRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest.builder()
                .applyMutation(getFieldLevelEncryptionProfileConfigRequest).build());
    }

    /**
     * <p>
     * Gets the code of a CloudFront function. To get configuration information and metadata about a function, use
     * <code>DescribeFunction</code>.
     * </p>
     * <p>
     * To get a function's code, you must provide the function's name and stage. To get these values, you can use
     * <code>ListFunctions</code>.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws NoSuchFunctionExistsException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the code of a CloudFront function. To get configuration information and metadata about a function, use
     * <code>DescribeFunction</code>.
     * </p>
     * <p>
     * To get a function's code, you must provide the function's name and stage. To get these values, you can use
     * <code>ListFunctions</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link GetFunctionRequest#builder()}
     * </p>
     *
     * @param getFunctionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionRequest.Builder} to create a request.
     * @return Result of the GetFunction operation returned by the service.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFunctionResponse getFunction(Consumer<GetFunctionRequest.Builder> getFunctionRequest)
            throws NoSuchFunctionExistsException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return getFunction(GetFunctionRequest.builder().applyMutation(getFunctionRequest).build());
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     *
     * @param getInvalidationRequest
     *        The request to get an invalidation's information.
     * @return Result of the GetInvalidation operation returned by the service.
     * @throws NoSuchInvalidationException
     *         The specified invalidation does not exist.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInvalidationResponse getInvalidation(GetInvalidationRequest getInvalidationRequest)
            throws NoSuchInvalidationException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvalidationRequest.Builder} avoiding the need
     * to create one manually via {@link GetInvalidationRequest#builder()}
     * </p>
     *
     * @param getInvalidationRequest
     *        A {@link Consumer} that will call methods on {@link GetInvalidationRequest.Builder} to create a request.
     *        The request to get an invalidation's information.
     * @return Result of the GetInvalidation operation returned by the service.
     * @throws NoSuchInvalidationException
     *         The specified invalidation does not exist.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInvalidationResponse getInvalidation(Consumer<GetInvalidationRequest.Builder> getInvalidationRequest)
            throws NoSuchInvalidationException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return getInvalidation(GetInvalidationRequest.builder().applyMutation(getInvalidationRequest).build());
    }

    /**
     * <p>
     * Gets a key group, including the date and time when the key group was last modified.
     * </p>
     * <p>
     * To get a key group, you must provide the key group's identifier. If the key group is referenced in a
     * distribution's cache behavior, you can get the key group's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     *
     * @param getKeyGroupRequest
     * @return Result of the GetKeyGroup operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKeyGroupResponse getKeyGroup(GetKeyGroupRequest getKeyGroupRequest) throws NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a key group, including the date and time when the key group was last modified.
     * </p>
     * <p>
     * To get a key group, you must provide the key group's identifier. If the key group is referenced in a
     * distribution's cache behavior, you can get the key group's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetKeyGroupRequest#builder()}
     * </p>
     *
     * @param getKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetKeyGroupRequest.Builder} to create a request.
     * @return Result of the GetKeyGroup operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKeyGroupResponse getKeyGroup(Consumer<GetKeyGroupRequest.Builder> getKeyGroupRequest)
            throws NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        return getKeyGroup(GetKeyGroupRequest.builder().applyMutation(getKeyGroupRequest).build());
    }

    /**
     * <p>
     * Gets a key group configuration.
     * </p>
     * <p>
     * To get a key group configuration, you must provide the key group's identifier. If the key group is referenced in
     * a distribution's cache behavior, you can get the key group's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     *
     * @param getKeyGroupConfigRequest
     * @return Result of the GetKeyGroupConfig operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetKeyGroupConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroupConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetKeyGroupConfigResponse getKeyGroupConfig(GetKeyGroupConfigRequest getKeyGroupConfigRequest)
            throws NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a key group configuration.
     * </p>
     * <p>
     * To get a key group configuration, you must provide the key group's identifier. If the key group is referenced in
     * a distribution's cache behavior, you can get the key group's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyGroupConfigRequest.Builder} avoiding the need
     * to create one manually via {@link GetKeyGroupConfigRequest#builder()}
     * </p>
     *
     * @param getKeyGroupConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetKeyGroupConfigRequest.Builder} to create a request.
     * @return Result of the GetKeyGroupConfig operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetKeyGroupConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroupConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetKeyGroupConfigResponse getKeyGroupConfig(Consumer<GetKeyGroupConfigRequest.Builder> getKeyGroupConfigRequest)
            throws NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        return getKeyGroupConfig(GetKeyGroupConfigRequest.builder().applyMutation(getKeyGroupConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront
     * distribution.
     * </p>
     *
     * @param getMonitoringSubscriptionRequest
     * @return Result of the GetMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws NoSuchMonitoringSubscriptionException
     *         A monitoring subscription does not exist for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMonitoringSubscriptionResponse getMonitoringSubscription(
            GetMonitoringSubscriptionRequest getMonitoringSubscriptionRequest) throws AccessDeniedException,
            NoSuchDistributionException, NoSuchMonitoringSubscriptionException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront
     * distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMonitoringSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link GetMonitoringSubscriptionRequest#builder()}
     * </p>
     *
     * @param getMonitoringSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link GetMonitoringSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the GetMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws NoSuchMonitoringSubscriptionException
     *         A monitoring subscription does not exist for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMonitoringSubscriptionResponse getMonitoringSubscription(
            Consumer<GetMonitoringSubscriptionRequest.Builder> getMonitoringSubscriptionRequest) throws AccessDeniedException,
            NoSuchDistributionException, NoSuchMonitoringSubscriptionException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return getMonitoringSubscription(GetMonitoringSubscriptionRequest.builder()
                .applyMutation(getMonitoringSubscriptionRequest).build());
    }

    /**
     * <p>
     * Gets a CloudFront origin access control, including its unique identifier.
     * </p>
     *
     * @param getOriginAccessControlRequest
     * @return Result of the GetOriginAccessControl operation returned by the service.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginAccessControlResponse getOriginAccessControl(GetOriginAccessControlRequest getOriginAccessControlRequest)
            throws NoSuchOriginAccessControlException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a CloudFront origin access control, including its unique identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginAccessControlRequest.Builder} avoiding the
     * need to create one manually via {@link GetOriginAccessControlRequest#builder()}
     * </p>
     *
     * @param getOriginAccessControlRequest
     *        A {@link Consumer} that will call methods on {@link GetOriginAccessControlRequest.Builder} to create a
     *        request.
     * @return Result of the GetOriginAccessControl operation returned by the service.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginAccessControlResponse getOriginAccessControl(
            Consumer<GetOriginAccessControlRequest.Builder> getOriginAccessControlRequest)
            throws NoSuchOriginAccessControlException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getOriginAccessControl(GetOriginAccessControlRequest.builder().applyMutation(getOriginAccessControlRequest)
                .build());
    }

    /**
     * <p>
     * Gets a CloudFront origin access control configuration.
     * </p>
     *
     * @param getOriginAccessControlConfigRequest
     * @return Result of the GetOriginAccessControlConfig operation returned by the service.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginAccessControlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginAccessControlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginAccessControlConfigResponse getOriginAccessControlConfig(
            GetOriginAccessControlConfigRequest getOriginAccessControlConfigRequest) throws NoSuchOriginAccessControlException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a CloudFront origin access control configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginAccessControlConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetOriginAccessControlConfigRequest#builder()}
     * </p>
     *
     * @param getOriginAccessControlConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetOriginAccessControlConfigRequest.Builder} to create
     *        a request.
     * @return Result of the GetOriginAccessControlConfig operation returned by the service.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginAccessControlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginAccessControlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginAccessControlConfigResponse getOriginAccessControlConfig(
            Consumer<GetOriginAccessControlConfigRequest.Builder> getOriginAccessControlConfigRequest)
            throws NoSuchOriginAccessControlException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getOriginAccessControlConfig(GetOriginAccessControlConfigRequest.builder()
                .applyMutation(getOriginAccessControlConfigRequest).build());
    }

    /**
     * <p>
     * Gets an origin request policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy's identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get an origin request policy, you must provide the policy's identifier. If the origin request policy is
     * attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     *
     * @param getOriginRequestPolicyRequest
     * @return Result of the GetOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginRequestPolicyResponse getOriginRequestPolicy(GetOriginRequestPolicyRequest getOriginRequestPolicyRequest)
            throws AccessDeniedException, NoSuchOriginRequestPolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an origin request policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy's identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get an origin request policy, you must provide the policy's identifier. If the origin request policy is
     * attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginRequestPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetOriginRequestPolicyRequest#builder()}
     * </p>
     *
     * @param getOriginRequestPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetOriginRequestPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginRequestPolicyResponse getOriginRequestPolicy(
            Consumer<GetOriginRequestPolicyRequest.Builder> getOriginRequestPolicyRequest) throws AccessDeniedException,
            NoSuchOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        return getOriginRequestPolicy(GetOriginRequestPolicyRequest.builder().applyMutation(getOriginRequestPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Gets an origin request policy configuration.
     * </p>
     * <p>
     * To get an origin request policy configuration, you must provide the policy's identifier. If the origin request
     * policy is attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     *
     * @param getOriginRequestPolicyConfigRequest
     * @return Result of the GetOriginRequestPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginRequestPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginRequestPolicyConfigResponse getOriginRequestPolicyConfig(
            GetOriginRequestPolicyConfigRequest getOriginRequestPolicyConfigRequest) throws AccessDeniedException,
            NoSuchOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an origin request policy configuration.
     * </p>
     * <p>
     * To get an origin request policy configuration, you must provide the policy's identifier. If the origin request
     * policy is attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginRequestPolicyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetOriginRequestPolicyConfigRequest#builder()}
     * </p>
     *
     * @param getOriginRequestPolicyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetOriginRequestPolicyConfigRequest.Builder} to create
     *        a request.
     * @return Result of the GetOriginRequestPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginRequestPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOriginRequestPolicyConfigResponse getOriginRequestPolicyConfig(
            Consumer<GetOriginRequestPolicyConfigRequest.Builder> getOriginRequestPolicyConfigRequest)
            throws AccessDeniedException, NoSuchOriginRequestPolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getOriginRequestPolicyConfig(GetOriginRequestPolicyConfigRequest.builder()
                .applyMutation(getOriginRequestPolicyConfigRequest).build());
    }

    /**
     * <p>
     * Gets a public key.
     * </p>
     *
     * @param getPublicKeyRequest
     * @return Result of the GetPublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPublicKeyResponse getPublicKey(GetPublicKeyRequest getPublicKeyRequest) throws AccessDeniedException,
            NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a public key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPublicKeyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPublicKeyRequest#builder()}
     * </p>
     *
     * @param getPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetPublicKeyRequest.Builder} to create a request.
     * @return Result of the GetPublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPublicKeyResponse getPublicKey(Consumer<GetPublicKeyRequest.Builder> getPublicKeyRequest)
            throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        return getPublicKey(GetPublicKeyRequest.builder().applyMutation(getPublicKeyRequest).build());
    }

    /**
     * <p>
     * Gets a public key configuration.
     * </p>
     *
     * @param getPublicKeyConfigRequest
     * @return Result of the GetPublicKeyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKeyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPublicKeyConfigResponse getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest)
            throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a public key configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPublicKeyConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetPublicKeyConfigRequest#builder()}
     * </p>
     *
     * @param getPublicKeyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetPublicKeyConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetPublicKeyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKeyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPublicKeyConfigResponse getPublicKeyConfig(Consumer<GetPublicKeyConfigRequest.Builder> getPublicKeyConfigRequest)
            throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        return getPublicKeyConfig(GetPublicKeyConfigRequest.builder().applyMutation(getPublicKeyConfigRequest).build());
    }

    /**
     * <p>
     * Gets a real-time log configuration.
     * </p>
     * <p>
     * To get a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name (ARN).
     * You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to get.
     * </p>
     *
     * @param getRealtimeLogConfigRequest
     * @return Result of the GetRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRealtimeLogConfigResponse getRealtimeLogConfig(GetRealtimeLogConfigRequest getRealtimeLogConfigRequest)
            throws NoSuchRealtimeLogConfigException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a real-time log configuration.
     * </p>
     * <p>
     * To get a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name (ARN).
     * You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to get.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRealtimeLogConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param getRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetRealtimeLogConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRealtimeLogConfigResponse getRealtimeLogConfig(
            Consumer<GetRealtimeLogConfigRequest.Builder> getRealtimeLogConfigRequest) throws NoSuchRealtimeLogConfigException,
            InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        return getRealtimeLogConfig(GetRealtimeLogConfigRequest.builder().applyMutation(getRealtimeLogConfigRequest).build());
    }

    /**
     * <p>
     * Gets a response headers policy, including metadata (the policy's identifier and the date and time when the policy
     * was last modified).
     * </p>
     * <p>
     * To get a response headers policy, you must provide the policy's identifier. If the response headers policy is
     * attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to
     * a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.
     * </p>
     *
     * @param getResponseHeadersPolicyRequest
     * @return Result of the GetResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResponseHeadersPolicyResponse getResponseHeadersPolicy(
            GetResponseHeadersPolicyRequest getResponseHeadersPolicyRequest) throws AccessDeniedException,
            NoSuchResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a response headers policy, including metadata (the policy's identifier and the date and time when the policy
     * was last modified).
     * </p>
     * <p>
     * To get a response headers policy, you must provide the policy's identifier. If the response headers policy is
     * attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to
     * a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResponseHeadersPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetResponseHeadersPolicyRequest#builder()}
     * </p>
     *
     * @param getResponseHeadersPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResponseHeadersPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResponseHeadersPolicyResponse getResponseHeadersPolicy(
            Consumer<GetResponseHeadersPolicyRequest.Builder> getResponseHeadersPolicyRequest) throws AccessDeniedException,
            NoSuchResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        return getResponseHeadersPolicy(GetResponseHeadersPolicyRequest.builder().applyMutation(getResponseHeadersPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Gets a response headers policy configuration.
     * </p>
     * <p>
     * To get a response headers policy configuration, you must provide the policy's identifier. If the response headers
     * policy is attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to
     * a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.
     * </p>
     *
     * @param getResponseHeadersPolicyConfigRequest
     * @return Result of the GetResponseHeadersPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetResponseHeadersPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetResponseHeadersPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResponseHeadersPolicyConfigResponse getResponseHeadersPolicyConfig(
            GetResponseHeadersPolicyConfigRequest getResponseHeadersPolicyConfigRequest) throws AccessDeniedException,
            NoSuchResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a response headers policy configuration.
     * </p>
     * <p>
     * To get a response headers policy configuration, you must provide the policy's identifier. If the response headers
     * policy is attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to
     * a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResponseHeadersPolicyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetResponseHeadersPolicyConfigRequest#builder()}
     * </p>
     *
     * @param getResponseHeadersPolicyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetResponseHeadersPolicyConfigRequest.Builder} to
     *        create a request.
     * @return Result of the GetResponseHeadersPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetResponseHeadersPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetResponseHeadersPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResponseHeadersPolicyConfigResponse getResponseHeadersPolicyConfig(
            Consumer<GetResponseHeadersPolicyConfigRequest.Builder> getResponseHeadersPolicyConfigRequest)
            throws AccessDeniedException, NoSuchResponseHeadersPolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getResponseHeadersPolicyConfig(GetResponseHeadersPolicyConfigRequest.builder()
                .applyMutation(getResponseHeadersPolicyConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        The request to get a streaming distribution's information.
     * @return Result of the GetStreamingDistribution operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStreamingDistributionResponse getStreamingDistribution(
            GetStreamingDistributionRequest getStreamingDistributionRequest) throws NoSuchStreamingDistributionException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingDistributionRequest.Builder} avoiding
     * the need to create one manually via {@link GetStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingDistributionRequest.Builder} to create a
     *        request. The request to get a streaming distribution's information.
     * @return Result of the GetStreamingDistribution operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStreamingDistributionResponse getStreamingDistribution(
            Consumer<GetStreamingDistributionRequest.Builder> getStreamingDistributionRequest)
            throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getStreamingDistribution(GetStreamingDistributionRequest.builder().applyMutation(getStreamingDistributionRequest)
                .build());
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        To request to get a streaming distribution configuration.
     * @return Result of the GetStreamingDistributionConfig operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStreamingDistributionConfigResponse getStreamingDistributionConfig(
            GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest)
            throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingDistributionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetStreamingDistributionConfigRequest#builder()}
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingDistributionConfigRequest.Builder} to
     *        create a request. To request to get a streaming distribution configuration.
     * @return Result of the GetStreamingDistributionConfig operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStreamingDistributionConfigResponse getStreamingDistributionConfig(
            Consumer<GetStreamingDistributionConfigRequest.Builder> getStreamingDistributionConfigRequest)
            throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getStreamingDistributionConfig(GetStreamingDistributionConfigRequest.builder()
                .applyMutation(getStreamingDistributionConfigRequest).build());
    }

    /**
     * <p>
     * Gets a list of cache policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listCachePoliciesRequest
     * @return Result of the ListCachePolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCachePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCachePoliciesResponse listCachePolicies(ListCachePoliciesRequest listCachePoliciesRequest)
            throws AccessDeniedException, NoSuchCachePolicyException, InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of cache policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCachePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCachePoliciesRequest#builder()}
     * </p>
     *
     * @param listCachePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListCachePoliciesRequest.Builder} to create a request.
     * @return Result of the ListCachePolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCachePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCachePoliciesResponse listCachePolicies(Consumer<ListCachePoliciesRequest.Builder> listCachePoliciesRequest)
            throws AccessDeniedException, NoSuchCachePolicyException, InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listCachePolicies(ListCachePoliciesRequest.builder().applyMutation(listCachePoliciesRequest).build());
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @return Result of the ListCloudFrontOriginAccessIdentities operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCloudFrontOriginAccessIdentities
     * @see #listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities() throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.builder().build());
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        The request to list origin access identities.
     * @return Result of the ListCloudFrontOriginAccessIdentities operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities(
            ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCloudFrontOriginAccessIdentitiesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCloudFrontOriginAccessIdentitiesRequest#builder()}
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListCloudFrontOriginAccessIdentitiesRequest.Builder}
     *        to create a request. The request to list origin access identities.
     * @return Result of the ListCloudFrontOriginAccessIdentities operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities(
            Consumer<ListCloudFrontOriginAccessIdentitiesRequest.Builder> listCloudFrontOriginAccessIdentitiesRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.builder()
                .applyMutation(listCloudFrontOriginAccessIdentitiesRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided
     * alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias.
     * In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the
     * distributions and accounts that you own, but helps to protect the information of ones that you don't own.
     * </p>
     * <p>
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided
     * alias. For example, if you provide <code>www.example.com</code> as input, the returned list can include
     * <code>www.example.com</code> and the overlapping wildcard alternate domain name (<code>*.example.com</code>), if
     * they exist. If you provide <code>*.example.com</code> as input, the returned list can include
     * <code>*.example.com</code> and any alternate domain names covered by that wildcard (for example,
     * <code>www.example.com</code>, <code>test.example.com</code>, <code>dev.example.com</code>, and so on), if they
     * exist.
     * </p>
     * <p>
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that
     * has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set
     * up the distribution and certificate, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listConflictingAliasesRequest
     * @return Result of the ListConflictingAliases operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListConflictingAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListConflictingAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConflictingAliasesResponse listConflictingAliases(ListConflictingAliasesRequest listConflictingAliasesRequest)
            throws InvalidArgumentException, NoSuchDistributionException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided
     * alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias.
     * In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the
     * distributions and accounts that you own, but helps to protect the information of ones that you don't own.
     * </p>
     * <p>
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided
     * alias. For example, if you provide <code>www.example.com</code> as input, the returned list can include
     * <code>www.example.com</code> and the overlapping wildcard alternate domain name (<code>*.example.com</code>), if
     * they exist. If you provide <code>*.example.com</code> as input, the returned list can include
     * <code>*.example.com</code> and any alternate domain names covered by that wildcard (for example,
     * <code>www.example.com</code>, <code>test.example.com</code>, <code>dev.example.com</code>, and so on), if they
     * exist.
     * </p>
     * <p>
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that
     * has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set
     * up the distribution and certificate, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConflictingAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListConflictingAliasesRequest#builder()}
     * </p>
     *
     * @param listConflictingAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListConflictingAliasesRequest.Builder} to create a
     *        request.
     * @return Result of the ListConflictingAliases operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListConflictingAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListConflictingAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConflictingAliasesResponse listConflictingAliases(
            Consumer<ListConflictingAliasesRequest.Builder> listConflictingAliasesRequest) throws InvalidArgumentException,
            NoSuchDistributionException, AwsServiceException, SdkClientException, CloudFrontException {
        return listConflictingAliases(ListConflictingAliasesRequest.builder().applyMutation(listConflictingAliasesRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the continuous deployment policies in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listContinuousDeploymentPoliciesRequest
     * @return Result of the ListContinuousDeploymentPolicies operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListContinuousDeploymentPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListContinuousDeploymentPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContinuousDeploymentPoliciesResponse listContinuousDeploymentPolicies(
            ListContinuousDeploymentPoliciesRequest listContinuousDeploymentPoliciesRequest) throws InvalidArgumentException,
            AccessDeniedException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the continuous deployment policies in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContinuousDeploymentPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListContinuousDeploymentPoliciesRequest#builder()}
     * </p>
     *
     * @param listContinuousDeploymentPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListContinuousDeploymentPoliciesRequest.Builder} to
     *        create a request.
     * @return Result of the ListContinuousDeploymentPolicies operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListContinuousDeploymentPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListContinuousDeploymentPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContinuousDeploymentPoliciesResponse listContinuousDeploymentPolicies(
            Consumer<ListContinuousDeploymentPoliciesRequest.Builder> listContinuousDeploymentPoliciesRequest)
            throws InvalidArgumentException, AccessDeniedException, NoSuchContinuousDeploymentPolicyException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listContinuousDeploymentPolicies(ListContinuousDeploymentPoliciesRequest.builder()
                .applyMutation(listContinuousDeploymentPoliciesRequest).build());
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @return Result of the ListDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributions
     * @see #listDistributions(ListDistributionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDistributionsResponse listDistributions() throws InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listDistributions(ListDistributionsRequest.builder().build());
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @param listDistributionsRequest
     *        The request to list your distributions.
     * @return Result of the ListDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDistributionsResponse listDistributions(ListDistributionsRequest listDistributionsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDistributionsRequest#builder()}
     * </p>
     *
     * @param listDistributionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsRequest.Builder} to create a request.
     *        The request to list your distributions.
     * @return Result of the ListDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDistributionsResponse listDistributions(Consumer<ListDistributionsRequest.Builder> listDistributionsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listDistributions(ListDistributionsRequest.builder().applyMutation(listDistributionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * cache policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByCachePolicyIdRequest
     * @return Result of the ListDistributionsByCachePolicyId operation returned by the service.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByCachePolicyId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByCachePolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByCachePolicyIdResponse listDistributionsByCachePolicyId(
            ListDistributionsByCachePolicyIdRequest listDistributionsByCachePolicyIdRequest) throws NoSuchCachePolicyException,
            InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * cache policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsByCachePolicyIdRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionsByCachePolicyIdRequest#builder()}
     * </p>
     *
     * @param listDistributionsByCachePolicyIdRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByCachePolicyIdRequest.Builder} to
     *        create a request.
     * @return Result of the ListDistributionsByCachePolicyId operation returned by the service.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByCachePolicyId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByCachePolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByCachePolicyIdResponse listDistributionsByCachePolicyId(
            Consumer<ListDistributionsByCachePolicyIdRequest.Builder> listDistributionsByCachePolicyIdRequest)
            throws NoSuchCachePolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listDistributionsByCachePolicyId(ListDistributionsByCachePolicyIdRequest.builder()
                .applyMutation(listDistributionsByCachePolicyIdRequest).build());
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key
     * group.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByKeyGroupRequest
     * @return Result of the ListDistributionsByKeyGroup operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByKeyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByKeyGroupResponse listDistributionsByKeyGroup(
            ListDistributionsByKeyGroupRequest listDistributionsByKeyGroupRequest) throws NoSuchResourceException,
            InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key
     * group.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsByKeyGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionsByKeyGroupRequest#builder()}
     * </p>
     *
     * @param listDistributionsByKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByKeyGroupRequest.Builder} to create
     *        a request.
     * @return Result of the ListDistributionsByKeyGroup operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByKeyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByKeyGroupResponse listDistributionsByKeyGroup(
            Consumer<ListDistributionsByKeyGroupRequest.Builder> listDistributionsByKeyGroupRequest)
            throws NoSuchResourceException, InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return listDistributionsByKeyGroup(ListDistributionsByKeyGroupRequest.builder()
                .applyMutation(listDistributionsByKeyGroupRequest).build());
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * origin request policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByOriginRequestPolicyIdRequest
     * @return Result of the ListDistributionsByOriginRequestPolicyId operation returned by the service.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByOriginRequestPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByOriginRequestPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByOriginRequestPolicyIdResponse listDistributionsByOriginRequestPolicyId(
            ListDistributionsByOriginRequestPolicyIdRequest listDistributionsByOriginRequestPolicyIdRequest)
            throws NoSuchOriginRequestPolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * origin request policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDistributionsByOriginRequestPolicyIdRequest.Builder} avoiding the need to create one manually via
     * {@link ListDistributionsByOriginRequestPolicyIdRequest#builder()}
     * </p>
     *
     * @param listDistributionsByOriginRequestPolicyIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListDistributionsByOriginRequestPolicyIdRequest.Builder} to create a request.
     * @return Result of the ListDistributionsByOriginRequestPolicyId operation returned by the service.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByOriginRequestPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByOriginRequestPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByOriginRequestPolicyIdResponse listDistributionsByOriginRequestPolicyId(
            Consumer<ListDistributionsByOriginRequestPolicyIdRequest.Builder> listDistributionsByOriginRequestPolicyIdRequest)
            throws NoSuchOriginRequestPolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listDistributionsByOriginRequestPolicyId(ListDistributionsByOriginRequestPolicyIdRequest.builder()
                .applyMutation(listDistributionsByOriginRequestPolicyIdRequest).build());
    }

    /**
     * <p>
     * Gets a list of distributions that have a cache behavior that's associated with the specified real-time log
     * configuration.
     * </p>
     * <p>
     * You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide
     * at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list
     * distributions for.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByRealtimeLogConfigRequest
     * @return Result of the ListDistributionsByRealtimeLogConfig operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByRealtimeLogConfigResponse listDistributionsByRealtimeLogConfig(
            ListDistributionsByRealtimeLogConfigRequest listDistributionsByRealtimeLogConfigRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distributions that have a cache behavior that's associated with the specified real-time log
     * configuration.
     * </p>
     * <p>
     * You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide
     * at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list
     * distributions for.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDistributionsByRealtimeLogConfigRequest.Builder} avoiding the need to create one manually via
     * {@link ListDistributionsByRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param listDistributionsByRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByRealtimeLogConfigRequest.Builder}
     *        to create a request.
     * @return Result of the ListDistributionsByRealtimeLogConfig operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByRealtimeLogConfigResponse listDistributionsByRealtimeLogConfig(
            Consumer<ListDistributionsByRealtimeLogConfigRequest.Builder> listDistributionsByRealtimeLogConfigRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listDistributionsByRealtimeLogConfig(ListDistributionsByRealtimeLogConfigRequest.builder()
                .applyMutation(listDistributionsByRealtimeLogConfigRequest).build());
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * response headers policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByResponseHeadersPolicyIdRequest
     * @return Result of the ListDistributionsByResponseHeadersPolicyId operation returned by the service.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByResponseHeadersPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByResponseHeadersPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByResponseHeadersPolicyIdResponse listDistributionsByResponseHeadersPolicyId(
            ListDistributionsByResponseHeadersPolicyIdRequest listDistributionsByResponseHeadersPolicyIdRequest)
            throws NoSuchResponseHeadersPolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * response headers policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDistributionsByResponseHeadersPolicyIdRequest.Builder} avoiding the need to create one manually via
     * {@link ListDistributionsByResponseHeadersPolicyIdRequest#builder()}
     * </p>
     *
     * @param listDistributionsByResponseHeadersPolicyIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListDistributionsByResponseHeadersPolicyIdRequest.Builder} to create a request.
     * @return Result of the ListDistributionsByResponseHeadersPolicyId operation returned by the service.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByResponseHeadersPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByResponseHeadersPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByResponseHeadersPolicyIdResponse listDistributionsByResponseHeadersPolicyId(
            Consumer<ListDistributionsByResponseHeadersPolicyIdRequest.Builder> listDistributionsByResponseHeadersPolicyIdRequest)
            throws NoSuchResponseHeadersPolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listDistributionsByResponseHeadersPolicyId(ListDistributionsByResponseHeadersPolicyIdRequest.builder()
                .applyMutation(listDistributionsByResponseHeadersPolicyIdRequest).build());
    }

    /**
     * <p>
     * List the distributions that are associated with a specified WAF web ACL.
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        The request to list distributions that are associated with a specified WAF web ACL.
     * @return Result of the ListDistributionsByWebACLId operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByWebACLId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByWebAclIdResponse listDistributionsByWebACLId(
            ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) throws InvalidArgumentException,
            InvalidWebAclIdException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the distributions that are associated with a specified WAF web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsByWebAclIdRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionsByWebAclIdRequest#builder()}
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByWebACLIdRequest.Builder} to create
     *        a request. The request to list distributions that are associated with a specified WAF web ACL.
     * @return Result of the ListDistributionsByWebACLId operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByWebACLId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByWebAclIdResponse listDistributionsByWebACLId(
            Consumer<ListDistributionsByWebAclIdRequest.Builder> listDistributionsByWebAclIdRequest)
            throws InvalidArgumentException, InvalidWebAclIdException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return listDistributionsByWebACLId(ListDistributionsByWebAclIdRequest.builder()
                .applyMutation(listDistributionsByWebAclIdRequest).build());
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @return Result of the ListFieldLevelEncryptionConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionConfigs
     * @see #listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs() throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest.builder().build());
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     * @return Result of the ListFieldLevelEncryptionConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs(
            ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldLevelEncryptionConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFieldLevelEncryptionConfigsRequest#builder()}
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldLevelEncryptionConfigsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFieldLevelEncryptionConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs(
            Consumer<ListFieldLevelEncryptionConfigsRequest.Builder> listFieldLevelEncryptionConfigsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest.builder()
                .applyMutation(listFieldLevelEncryptionConfigsRequest).build());
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @return Result of the ListFieldLevelEncryptionProfiles operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionProfiles
     * @see #listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles() throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     * @return Result of the ListFieldLevelEncryptionProfiles operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles(
            ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldLevelEncryptionProfilesRequest.Builder}
     * avoiding the need to create one manually via {@link ListFieldLevelEncryptionProfilesRequest#builder()}
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldLevelEncryptionProfilesRequest.Builder} to
     *        create a request.
     * @return Result of the ListFieldLevelEncryptionProfiles operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles(
            Consumer<ListFieldLevelEncryptionProfilesRequest.Builder> listFieldLevelEncryptionProfilesRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest.builder()
                .applyMutation(listFieldLevelEncryptionProfilesRequest).build());
    }

    /**
     * <p>
     * Gets a list of all CloudFront functions in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the functions that are in the specified stage, either
     * <code>DEVELOPMENT</code> or <code>LIVE</code>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws InvalidArgumentException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all CloudFront functions in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the functions that are in the specified stage, either
     * <code>DEVELOPMENT</code> or <code>LIVE</code>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionsRequest.Builder} to create a request.
     * @return Result of the ListFunctions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest)
            throws InvalidArgumentException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listFunctions(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     *
     * @param listInvalidationsRequest
     *        The request to list invalidations.
     * @return Result of the ListInvalidations operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListInvalidations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvalidationsResponse listInvalidations(ListInvalidationsRequest listInvalidationsRequest)
            throws InvalidArgumentException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvalidationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvalidationsRequest#builder()}
     * </p>
     *
     * @param listInvalidationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvalidationsRequest.Builder} to create a request.
     *        The request to list invalidations.
     * @return Result of the ListInvalidations operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListInvalidations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvalidationsResponse listInvalidations(Consumer<ListInvalidationsRequest.Builder> listInvalidationsRequest)
            throws InvalidArgumentException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listInvalidations(ListInvalidationsRequest.builder().applyMutation(listInvalidationsRequest).build());
    }

    /**
     * <p>
     * Gets a list of key groups.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listKeyGroupsRequest
     * @return Result of the ListKeyGroups operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListKeyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKeyGroupsResponse listKeyGroups(ListKeyGroupsRequest listKeyGroupsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of key groups.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeyGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListKeyGroupsRequest#builder()}
     * </p>
     *
     * @param listKeyGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListKeyGroupsRequest.Builder} to create a request.
     * @return Result of the ListKeyGroups operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListKeyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKeyGroupsResponse listKeyGroups(Consumer<ListKeyGroupsRequest.Builder> listKeyGroupsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listKeyGroups(ListKeyGroupsRequest.builder().applyMutation(listKeyGroupsRequest).build());
    }

    /**
     * <p>
     * Gets the list of CloudFront origin access controls in this Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send another request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the next request.
     * </p>
     *
     * @param listOriginAccessControlsRequest
     * @return Result of the ListOriginAccessControls operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListOriginAccessControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginAccessControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginAccessControlsResponse listOriginAccessControls(
            ListOriginAccessControlsRequest listOriginAccessControlsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the list of CloudFront origin access controls in this Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send another request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the next request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginAccessControlsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOriginAccessControlsRequest#builder()}
     * </p>
     *
     * @param listOriginAccessControlsRequest
     *        A {@link Consumer} that will call methods on {@link ListOriginAccessControlsRequest.Builder} to create a
     *        request.
     * @return Result of the ListOriginAccessControls operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListOriginAccessControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginAccessControls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginAccessControlsResponse listOriginAccessControls(
            Consumer<ListOriginAccessControlsRequest.Builder> listOriginAccessControlsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listOriginAccessControls(ListOriginAccessControlsRequest.builder().applyMutation(listOriginAccessControlsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of origin request policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listOriginRequestPoliciesRequest
     * @return Result of the ListOriginRequestPolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListOriginRequestPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginRequestPoliciesResponse listOriginRequestPolicies(
            ListOriginRequestPoliciesRequest listOriginRequestPoliciesRequest) throws AccessDeniedException,
            NoSuchOriginRequestPolicyException, InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of origin request policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginRequestPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListOriginRequestPoliciesRequest#builder()}
     * </p>
     *
     * @param listOriginRequestPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListOriginRequestPoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListOriginRequestPolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListOriginRequestPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOriginRequestPoliciesResponse listOriginRequestPolicies(
            Consumer<ListOriginRequestPoliciesRequest.Builder> listOriginRequestPoliciesRequest) throws AccessDeniedException,
            NoSuchOriginRequestPolicyException, InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return listOriginRequestPolicies(ListOriginRequestPoliciesRequest.builder()
                .applyMutation(listOriginRequestPoliciesRequest).build());
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @return Result of the ListPublicKeys operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListPublicKeys
     * @see #listPublicKeys(ListPublicKeysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysResponse listPublicKeys() throws InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return listPublicKeys(ListPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @param listPublicKeysRequest
     * @return Result of the ListPublicKeys operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListPublicKeysRequest.Builder} to create a request.
     * @return Result of the ListPublicKeys operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysResponse listPublicKeys(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listPublicKeys(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * Gets a list of real-time log configurations.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listRealtimeLogConfigsRequest
     * @return Result of the ListRealtimeLogConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListRealtimeLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListRealtimeLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRealtimeLogConfigsResponse listRealtimeLogConfigs(ListRealtimeLogConfigsRequest listRealtimeLogConfigsRequest)
            throws InvalidArgumentException, AccessDeniedException, NoSuchRealtimeLogConfigException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of real-time log configurations.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRealtimeLogConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRealtimeLogConfigsRequest#builder()}
     * </p>
     *
     * @param listRealtimeLogConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListRealtimeLogConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRealtimeLogConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListRealtimeLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListRealtimeLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRealtimeLogConfigsResponse listRealtimeLogConfigs(
            Consumer<ListRealtimeLogConfigsRequest.Builder> listRealtimeLogConfigsRequest) throws InvalidArgumentException,
            AccessDeniedException, NoSuchRealtimeLogConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        return listRealtimeLogConfigs(ListRealtimeLogConfigsRequest.builder().applyMutation(listRealtimeLogConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of response headers policies.
     * </p>
     * <p>
     * You can optionally apply a filter to get only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listResponseHeadersPoliciesRequest
     * @return Result of the ListResponseHeadersPolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListResponseHeadersPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListResponseHeadersPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponseHeadersPoliciesResponse listResponseHeadersPolicies(
            ListResponseHeadersPoliciesRequest listResponseHeadersPoliciesRequest) throws AccessDeniedException,
            NoSuchResponseHeadersPolicyException, InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of response headers policies.
     * </p>
     * <p>
     * You can optionally apply a filter to get only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResponseHeadersPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResponseHeadersPoliciesRequest#builder()}
     * </p>
     *
     * @param listResponseHeadersPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListResponseHeadersPoliciesRequest.Builder} to create
     *        a request.
     * @return Result of the ListResponseHeadersPolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListResponseHeadersPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListResponseHeadersPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponseHeadersPoliciesResponse listResponseHeadersPolicies(
            Consumer<ListResponseHeadersPoliciesRequest.Builder> listResponseHeadersPoliciesRequest)
            throws AccessDeniedException, NoSuchResponseHeadersPolicyException, InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listResponseHeadersPolicies(ListResponseHeadersPoliciesRequest.builder()
                .applyMutation(listResponseHeadersPoliciesRequest).build());
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @return Result of the ListStreamingDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListStreamingDistributions
     * @see #listStreamingDistributions(ListStreamingDistributionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamingDistributionsResponse listStreamingDistributions() throws InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listStreamingDistributions(ListStreamingDistributionsRequest.builder().build());
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        The request to list your streaming distributions.
     * @return Result of the ListStreamingDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListStreamingDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamingDistributionsResponse listStreamingDistributions(
            ListStreamingDistributionsRequest listStreamingDistributionsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingDistributionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStreamingDistributionsRequest#builder()}
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamingDistributionsRequest.Builder} to create a
     *        request. The request to list your streaming distributions.
     * @return Result of the ListStreamingDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListStreamingDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamingDistributionsResponse listStreamingDistributions(
            Consumer<ListStreamingDistributionsRequest.Builder> listStreamingDistributionsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listStreamingDistributions(ListStreamingDistributionsRequest.builder()
                .applyMutation(listStreamingDistributionsRequest).build());
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request to list tags for a CloudFront resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request. The request to list tags for a CloudFront resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code> stage to
     * <code>LIVE</code>. This automatically updates all cache behaviors that are using this function to use the newly
     * published copy in the <code>LIVE</code> stage.
     * </p>
     * <p>
     * When a function is published to the <code>LIVE</code> stage, you can attach the function to a distribution's
     * cache behavior, using the function's Amazon Resource Name (ARN).
     * </p>
     * <p>
     * To publish a function, you must provide the function's name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     *
     * @param publishFunctionRequest
     * @return Result of the PublishFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.PublishFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/PublishFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default PublishFunctionResponse publishFunction(PublishFunctionRequest publishFunctionRequest)
            throws InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFunctionExistsException,
            PreconditionFailedException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code> stage to
     * <code>LIVE</code>. This automatically updates all cache behaviors that are using this function to use the newly
     * published copy in the <code>LIVE</code> stage.
     * </p>
     * <p>
     * When a function is published to the <code>LIVE</code> stage, you can attach the function to a distribution's
     * cache behavior, using the function's Amazon Resource Name (ARN).
     * </p>
     * <p>
     * To publish a function, you must provide the function's name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishFunctionRequest.Builder} avoiding the need
     * to create one manually via {@link PublishFunctionRequest#builder()}
     * </p>
     *
     * @param publishFunctionRequest
     *        A {@link Consumer} that will call methods on {@link PublishFunctionRequest.Builder} to create a request.
     * @return Result of the PublishFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.PublishFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/PublishFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default PublishFunctionResponse publishFunction(Consumer<PublishFunctionRequest.Builder> publishFunctionRequest)
            throws InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFunctionExistsException,
            PreconditionFailedException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return publishFunction(PublishFunctionRequest.builder().applyMutation(publishFunctionRequest).build());
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request to add tags to a CloudFront resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request. The
     *        request to add tags to a CloudFront resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests a CloudFront function.
     * </p>
     * <p>
     * To test a function, you provide an <i>event object</i> that represents an HTTP request or response that your
     * CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object
     * that you provided, and returns the function's result (the modified event object) in the response. The response
     * also contains function logs and error messages, if any exist. For more information about testing functions, see
     * <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function"
     * >Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * To test a function, you provide the function's name and version (<code>ETag</code> value) along with the event
     * object. To get the function's name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     *
     * @param testFunctionRequest
     * @return Result of the TestFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws TestFunctionFailedException
     *         The CloudFront function failed.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TestFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TestFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default TestFunctionResponse testFunction(TestFunctionRequest testFunctionRequest) throws InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchFunctionExistsException, TestFunctionFailedException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests a CloudFront function.
     * </p>
     * <p>
     * To test a function, you provide an <i>event object</i> that represents an HTTP request or response that your
     * CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object
     * that you provided, and returns the function's result (the modified event object) in the response. The response
     * also contains function logs and error messages, if any exist. For more information about testing functions, see
     * <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function"
     * >Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * To test a function, you provide the function's name and version (<code>ETag</code> value) along with the event
     * object. To get the function's name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link TestFunctionRequest#builder()}
     * </p>
     *
     * @param testFunctionRequest
     *        A {@link Consumer} that will call methods on {@link TestFunctionRequest.Builder} to create a request.
     * @return Result of the TestFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws TestFunctionFailedException
     *         The CloudFront function failed.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TestFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TestFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default TestFunctionResponse testFunction(Consumer<TestFunctionRequest.Builder> testFunctionRequest)
            throws InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFunctionExistsException,
            TestFunctionFailedException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return testFunction(TestFunctionRequest.builder().applyMutation(testFunctionRequest).build());
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request to remove tags from a CloudFront resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request. The
     *        request to remove tags from a CloudFront resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a cache policy configuration.
     * </p>
     * <p>
     * When you update a cache policy configuration, all the fields are updated with the values provided in the request.
     * You cannot update some fields independent of others. To update a cache policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetCachePolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the cache policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateCachePolicy</code> by providing the entire cache policy configuration, including the fields that
     * you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateCachePolicyRequest
     * @return Result of the UpdateCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws CachePolicyAlreadyExistsException
     *         A cache policy with this name already exists. You must provide a unique name. To modify an existing cache
     *         policy, use <code>UpdateCachePolicy</code>.
     * @throws TooManyHeadersInCachePolicyException
     *         The number of headers in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInCachePolicyException
     *         The number of cookies in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInCachePolicyException
     *         The number of query strings in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCachePolicyResponse updateCachePolicy(UpdateCachePolicyRequest updateCachePolicyRequest)
            throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchCachePolicyException, PreconditionFailedException,
            CachePolicyAlreadyExistsException, TooManyHeadersInCachePolicyException, TooManyCookiesInCachePolicyException,
            TooManyQueryStringsInCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a cache policy configuration.
     * </p>
     * <p>
     * When you update a cache policy configuration, all the fields are updated with the values provided in the request.
     * You cannot update some fields independent of others. To update a cache policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetCachePolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the cache policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateCachePolicy</code> by providing the entire cache policy configuration, including the fields that
     * you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCachePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCachePolicyRequest#builder()}
     * </p>
     *
     * @param updateCachePolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCachePolicyRequest.Builder} to create a request.
     * @return Result of the UpdateCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws CachePolicyAlreadyExistsException
     *         A cache policy with this name already exists. You must provide a unique name. To modify an existing cache
     *         policy, use <code>UpdateCachePolicy</code>.
     * @throws TooManyHeadersInCachePolicyException
     *         The number of headers in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInCachePolicyException
     *         The number of cookies in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInCachePolicyException
     *         The number of query strings in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCachePolicyResponse updateCachePolicy(Consumer<UpdateCachePolicyRequest.Builder> updateCachePolicyRequest)
            throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchCachePolicyException, PreconditionFailedException,
            CachePolicyAlreadyExistsException, TooManyHeadersInCachePolicyException, TooManyCookiesInCachePolicyException,
            TooManyQueryStringsInCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateCachePolicy(UpdateCachePolicyRequest.builder().applyMutation(updateCachePolicyRequest).build());
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        The request to update an origin access identity.
     * @return Result of the UpdateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentity(
            UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. The request to update an origin access identity.
     * @return Result of the UpdateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentity(
            Consumer<UpdateCloudFrontOriginAccessIdentityRequest.Builder> updateCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(updateCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Updates a continuous deployment policy. You can update a continuous deployment policy to enable or disable it, to
     * change the percentage of traffic that it sends to the staging distribution, or to change the staging distribution
     * that it sends traffic to.
     * </p>
     * <p>
     * When you update a continuous deployment policy configuration, all the fields are updated with the values that are
     * provided in the request. You cannot update some fields independent of others. To update a continuous deployment
     * policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetContinuousDeploymentPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the continuous deployment policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>UpdateContinuousDeploymentPolicy</code>, providing the entire continuous deployment policy
     * configuration, including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateContinuousDeploymentPolicyRequest
     * @return Result of the UpdateContinuousDeploymentPolicy operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContinuousDeploymentPolicyResponse updateContinuousDeploymentPolicy(
            UpdateContinuousDeploymentPolicyRequest updateContinuousDeploymentPolicyRequest)
            throws InvalidIfMatchVersionException, InvalidArgumentException, AccessDeniedException,
            InconsistentQuantitiesException, PreconditionFailedException, StagingDistributionInUseException,
            NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a continuous deployment policy. You can update a continuous deployment policy to enable or disable it, to
     * change the percentage of traffic that it sends to the staging distribution, or to change the staging distribution
     * that it sends traffic to.
     * </p>
     * <p>
     * When you update a continuous deployment policy configuration, all the fields are updated with the values that are
     * provided in the request. You cannot update some fields independent of others. To update a continuous deployment
     * policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetContinuousDeploymentPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the continuous deployment policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>UpdateContinuousDeploymentPolicy</code>, providing the entire continuous deployment policy
     * configuration, including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContinuousDeploymentPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateContinuousDeploymentPolicyRequest#builder()}
     * </p>
     *
     * @param updateContinuousDeploymentPolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContinuousDeploymentPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateContinuousDeploymentPolicy operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContinuousDeploymentPolicyResponse updateContinuousDeploymentPolicy(
            Consumer<UpdateContinuousDeploymentPolicyRequest.Builder> updateContinuousDeploymentPolicyRequest)
            throws InvalidIfMatchVersionException, InvalidArgumentException, AccessDeniedException,
            InconsistentQuantitiesException, PreconditionFailedException, StagingDistributionInUseException,
            NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateContinuousDeploymentPolicy(UpdateContinuousDeploymentPolicyRequest.builder()
                .applyMutation(updateContinuousDeploymentPolicyRequest).build());
    }

    /**
     * <p>
     * Updates the configuration for a CloudFront distribution.
     * </p>
     * <p>
     * The update process includes getting the current distribution configuration, updating it to make your changes, and
     * then submitting an <code>UpdateDistribution</code> request to make the updates.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetDistributionConfig</code> to get the current configuration, including the version identifier (
     * <code>ETag</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the distribution configuration that was returned in the response. Note the following important
     * requirements and restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must rename the <code>ETag</code> field to <code>IfMatch</code>, leaving the value unchanged. (Set the value
     * of <code>IfMatch</code> to the value of <code>ETag</code>, then remove the <code>ETag</code> field.)
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't change the value of <code>CallerReference</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request, providing the distribution configuration. The new
     * configuration replaces the existing configuration. The values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. Make sure to include all
     * fields: the ones that you modified and also the ones that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateDistributionRequest
     *        The request to update a distribution.
     * @return Result of the UpdateDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws IllegalOriginAccessConfigurationException
     *         An origin cannot contain both an origin access control (OAC) and an origin access identity (OAI).
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDistributionResponse updateDistribution(UpdateDistributionRequest updateDistributionRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException,
            NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException,
            TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException,
            TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException,
            TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException,
            NoSuchContinuousDeploymentPolicyException, StagingDistributionInUseException,
            IllegalOriginAccessConfigurationException, InvalidDomainNameForOriginAccessControlException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for a CloudFront distribution.
     * </p>
     * <p>
     * The update process includes getting the current distribution configuration, updating it to make your changes, and
     * then submitting an <code>UpdateDistribution</code> request to make the updates.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetDistributionConfig</code> to get the current configuration, including the version identifier (
     * <code>ETag</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the distribution configuration that was returned in the response. Note the following important
     * requirements and restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must rename the <code>ETag</code> field to <code>IfMatch</code>, leaving the value unchanged. (Set the value
     * of <code>IfMatch</code> to the value of <code>ETag</code>, then remove the <code>ETag</code> field.)
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't change the value of <code>CallerReference</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request, providing the distribution configuration. The new
     * configuration replaces the existing configuration. The values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. Make sure to include all
     * fields: the ones that you modified and also the ones that you didn't.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDistributionRequest#builder()}
     * </p>
     *
     * @param updateDistributionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDistributionRequest.Builder} to create a
     *        request. The request to update a distribution.
     * @return Result of the UpdateDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws IllegalOriginAccessConfigurationException
     *         An origin cannot contain both an origin access control (OAC) and an origin access identity (OAI).
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDistributionResponse updateDistribution(Consumer<UpdateDistributionRequest.Builder> updateDistributionRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException,
            NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException,
            TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException,
            TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException,
            TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException,
            NoSuchContinuousDeploymentPolicyException, StagingDistributionInUseException,
            IllegalOriginAccessConfigurationException, InvalidDomainNameForOriginAccessControlException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return updateDistribution(UpdateDistributionRequest.builder().applyMutation(updateDistributionRequest).build());
    }

    /**
     * <p>
     * Copies the staging distribution's configuration to its corresponding primary distribution. The primary
     * distribution retains its <code>Aliases</code> (also known as alternate domain names or CNAMEs) and
     * <code>ContinuousDeploymentPolicyId</code> value, but otherwise its configuration is overwritten to match the
     * staging distribution.
     * </p>
     * <p>
     * You can use this operation in a continuous deployment workflow after you have tested configuration changes on the
     * staging distribution. After using a continuous deployment policy to move a portion of your domain name's traffic
     * to the staging distribution and verifying that it works as intended, you can use this operation to copy the
     * staging distribution's configuration to the primary distribution. This action will disable the continuous
     * deployment policy and move your domain's traffic back to the primary distribution.
     * </p>
     *
     * @param updateDistributionWithStagingConfigRequest
     * @return Result of the UpdateDistributionWithStagingConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistributionWithStagingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistributionWithStagingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDistributionWithStagingConfigResponse updateDistributionWithStagingConfig(
            UpdateDistributionWithStagingConfigRequest updateDistributionWithStagingConfigRequest) throws AccessDeniedException,
            CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException,
            NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException,
            TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException,
            TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException,
            TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the staging distribution's configuration to its corresponding primary distribution. The primary
     * distribution retains its <code>Aliases</code> (also known as alternate domain names or CNAMEs) and
     * <code>ContinuousDeploymentPolicyId</code> value, but otherwise its configuration is overwritten to match the
     * staging distribution.
     * </p>
     * <p>
     * You can use this operation in a continuous deployment workflow after you have tested configuration changes on the
     * staging distribution. After using a continuous deployment policy to move a portion of your domain name's traffic
     * to the staging distribution and verifying that it works as intended, you can use this operation to copy the
     * staging distribution's configuration to the primary distribution. This action will disable the continuous
     * deployment policy and move your domain's traffic back to the primary distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDistributionWithStagingConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDistributionWithStagingConfigRequest#builder()}
     * </p>
     *
     * @param updateDistributionWithStagingConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDistributionWithStagingConfigRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDistributionWithStagingConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistributionWithStagingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistributionWithStagingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDistributionWithStagingConfigResponse updateDistributionWithStagingConfig(
            Consumer<UpdateDistributionWithStagingConfigRequest.Builder> updateDistributionWithStagingConfigRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException,
            NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException,
            TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException,
            TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException,
            TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return updateDistributionWithStagingConfig(UpdateDistributionWithStagingConfigRequest.builder()
                .applyMutation(updateDistributionWithStagingConfigRequest).build());
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     * @return Result of the UpdateFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfig(
            UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchFieldLevelEncryptionProfileException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfig(
            Consumer<UpdateFieldLevelEncryptionConfigRequest.Builder> updateFieldLevelEncryptionConfigRequest)
            throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException,
            NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(updateFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     * @return Result of the UpdateFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfile(
            UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            FieldLevelEncryptionProfileAlreadyExistsException, IllegalUpdateException, InconsistentQuantitiesException,
            InvalidArgumentException, InvalidIfMatchVersionException, NoSuchPublicKeyException,
            NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfile(
            Consumer<UpdateFieldLevelEncryptionProfileRequest.Builder> updateFieldLevelEncryptionProfileRequest)
            throws AccessDeniedException, FieldLevelEncryptionProfileAlreadyExistsException, IllegalUpdateException,
            InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchPublicKeyException,
            NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(updateFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Updates a CloudFront function.
     * </p>
     * <p>
     * You can update a function's code or the comment that describes the function. You cannot update a function's name.
     * </p>
     * <p>
     * To update a function, you provide the function's name and version (<code>ETag</code> value) along with the
     * updated function code. To get the name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     *
     * @param updateFunctionRequest
     * @return Result of the UpdateFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FunctionSizeLimitExceededException
     *         The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFunctionResponse updateFunction(UpdateFunctionRequest updateFunctionRequest) throws InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchFunctionExistsException, PreconditionFailedException,
            FunctionSizeLimitExceededException, software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a CloudFront function.
     * </p>
     * <p>
     * You can update a function's code or the comment that describes the function. You cannot update a function's name.
     * </p>
     * <p>
     * To update a function, you provide the function's name and version (<code>ETag</code> value) along with the
     * updated function code. To get the name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFunctionRequest#builder()}
     * </p>
     *
     * @param updateFunctionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionRequest.Builder} to create a request.
     * @return Result of the UpdateFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FunctionSizeLimitExceededException
     *         The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFunctionResponse updateFunction(Consumer<UpdateFunctionRequest.Builder> updateFunctionRequest)
            throws InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFunctionExistsException,
            PreconditionFailedException, FunctionSizeLimitExceededException,
            software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return updateFunction(UpdateFunctionRequest.builder().applyMutation(updateFunctionRequest).build());
    }

    /**
     * <p>
     * Updates a key group.
     * </p>
     * <p>
     * When you update a key group, all the fields are updated with the values provided in the request. You cannot
     * update some fields independent of others. To update a key group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Get the current key group with <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateKeyGroup</code> with the entire key group object, including the fields that you modified and
     * those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateKeyGroupRequest
     * @return Result of the UpdateKeyGroup operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws KeyGroupAlreadyExistsException
     *         A key group with this name already exists. You must provide a unique name. To modify an existing key
     *         group, use <code>UpdateKeyGroup</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws TooManyPublicKeysInKeyGroupException
     *         The number of public keys in this key group is more than the maximum allowed. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKeyGroupResponse updateKeyGroup(UpdateKeyGroupRequest updateKeyGroupRequest)
            throws InvalidIfMatchVersionException, NoSuchResourceException, PreconditionFailedException,
            KeyGroupAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysInKeyGroupException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a key group.
     * </p>
     * <p>
     * When you update a key group, all the fields are updated with the values provided in the request. You cannot
     * update some fields independent of others. To update a key group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Get the current key group with <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateKeyGroup</code> with the entire key group object, including the fields that you modified and
     * those that you didn't.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKeyGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateKeyGroupRequest#builder()}
     * </p>
     *
     * @param updateKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateKeyGroupRequest.Builder} to create a request.
     * @return Result of the UpdateKeyGroup operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws KeyGroupAlreadyExistsException
     *         A key group with this name already exists. You must provide a unique name. To modify an existing key
     *         group, use <code>UpdateKeyGroup</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws TooManyPublicKeysInKeyGroupException
     *         The number of public keys in this key group is more than the maximum allowed. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKeyGroupResponse updateKeyGroup(Consumer<UpdateKeyGroupRequest.Builder> updateKeyGroupRequest)
            throws InvalidIfMatchVersionException, NoSuchResourceException, PreconditionFailedException,
            KeyGroupAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysInKeyGroupException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return updateKeyGroup(UpdateKeyGroupRequest.builder().applyMutation(updateKeyGroupRequest).build());
    }

    /**
     * <p>
     * Updates a CloudFront origin access control.
     * </p>
     *
     * @param updateOriginAccessControlRequest
     * @return Result of the UpdateOriginAccessControl operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws OriginAccessControlAlreadyExistsException
     *         An origin access control with the specified parameters already exists.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOriginAccessControlResponse updateOriginAccessControl(
            UpdateOriginAccessControlRequest updateOriginAccessControlRequest) throws AccessDeniedException,
            IllegalUpdateException, InvalidIfMatchVersionException, OriginAccessControlAlreadyExistsException,
            NoSuchOriginAccessControlException, PreconditionFailedException, InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a CloudFront origin access control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOriginAccessControlRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateOriginAccessControlRequest#builder()}
     * </p>
     *
     * @param updateOriginAccessControlRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOriginAccessControlRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateOriginAccessControl operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws OriginAccessControlAlreadyExistsException
     *         An origin access control with the specified parameters already exists.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOriginAccessControlResponse updateOriginAccessControl(
            Consumer<UpdateOriginAccessControlRequest.Builder> updateOriginAccessControlRequest) throws AccessDeniedException,
            IllegalUpdateException, InvalidIfMatchVersionException, OriginAccessControlAlreadyExistsException,
            NoSuchOriginAccessControlException, PreconditionFailedException, InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return updateOriginAccessControl(UpdateOriginAccessControlRequest.builder()
                .applyMutation(updateOriginAccessControlRequest).build());
    }

    /**
     * <p>
     * Updates an origin request policy configuration.
     * </p>
     * <p>
     * When you update an origin request policy configuration, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update an origin request policy
     * configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the origin request policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin request policy configuration,
     * including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateOriginRequestPolicyRequest
     * @return Result of the UpdateOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws OriginRequestPolicyAlreadyExistsException
     *         An origin request policy with this name already exists. You must provide a unique name. To modify an
     *         existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.
     * @throws TooManyHeadersInOriginRequestPolicyException
     *         The number of headers in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInOriginRequestPolicyException
     *         The number of cookies in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInOriginRequestPolicyException
     *         The number of query strings in the origin request policy exceeds the maximum. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOriginRequestPolicyResponse updateOriginRequestPolicy(
            UpdateOriginRequestPolicyRequest updateOriginRequestPolicyRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchOriginRequestPolicyException, PreconditionFailedException, OriginRequestPolicyAlreadyExistsException,
            TooManyHeadersInOriginRequestPolicyException, TooManyCookiesInOriginRequestPolicyException,
            TooManyQueryStringsInOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an origin request policy configuration.
     * </p>
     * <p>
     * When you update an origin request policy configuration, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update an origin request policy
     * configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the origin request policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin request policy configuration,
     * including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOriginRequestPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateOriginRequestPolicyRequest#builder()}
     * </p>
     *
     * @param updateOriginRequestPolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOriginRequestPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws OriginRequestPolicyAlreadyExistsException
     *         An origin request policy with this name already exists. You must provide a unique name. To modify an
     *         existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.
     * @throws TooManyHeadersInOriginRequestPolicyException
     *         The number of headers in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInOriginRequestPolicyException
     *         The number of cookies in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInOriginRequestPolicyException
     *         The number of query strings in the origin request policy exceeds the maximum. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOriginRequestPolicyResponse updateOriginRequestPolicy(
            Consumer<UpdateOriginRequestPolicyRequest.Builder> updateOriginRequestPolicyRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchOriginRequestPolicyException, PreconditionFailedException, OriginRequestPolicyAlreadyExistsException,
            TooManyHeadersInOriginRequestPolicyException, TooManyCookiesInOriginRequestPolicyException,
            TooManyQueryStringsInOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateOriginRequestPolicy(UpdateOriginRequestPolicyRequest.builder()
                .applyMutation(updateOriginRequestPolicyRequest).build());
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     *
     * @param updatePublicKeyRequest
     * @return Result of the UpdatePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CannotChangeImmutablePublicKeyFieldsException
     *         You can't change the value of a public key.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdatePublicKeyResponse updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) throws AccessDeniedException,
            CannotChangeImmutablePublicKeyFieldsException, InvalidArgumentException, InvalidIfMatchVersionException,
            IllegalUpdateException, NoSuchPublicKeyException, PreconditionFailedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePublicKeyRequest#builder()}
     * </p>
     *
     * @param updatePublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePublicKeyRequest.Builder} to create a request.
     * @return Result of the UpdatePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CannotChangeImmutablePublicKeyFieldsException
     *         You can't change the value of a public key.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdatePublicKeyResponse updatePublicKey(Consumer<UpdatePublicKeyRequest.Builder> updatePublicKeyRequest)
            throws AccessDeniedException, CannotChangeImmutablePublicKeyFieldsException, InvalidArgumentException,
            InvalidIfMatchVersionException, IllegalUpdateException, NoSuchPublicKeyException, PreconditionFailedException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return updatePublicKey(UpdatePublicKeyRequest.builder().applyMutation(updatePublicKeyRequest).build());
    }

    /**
     * <p>
     * Updates a real-time log configuration.
     * </p>
     * <p>
     * When you update a real-time log configuration, all the parameters are updated with the values provided in the
     * request. You cannot update some parameters independent of others. To update a real-time log configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>GetRealtimeLogConfig</code> to get the current real-time log configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the parameters in the real-time log configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire real-time log configuration,
     * including the parameters that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     * <p>
     * You cannot update a real-time log configuration's <code>Name</code> or <code>ARN</code>.
     * </p>
     *
     * @param updateRealtimeLogConfigRequest
     * @return Result of the UpdateRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRealtimeLogConfigResponse updateRealtimeLogConfig(UpdateRealtimeLogConfigRequest updateRealtimeLogConfigRequest)
            throws NoSuchRealtimeLogConfigException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a real-time log configuration.
     * </p>
     * <p>
     * When you update a real-time log configuration, all the parameters are updated with the values provided in the
     * request. You cannot update some parameters independent of others. To update a real-time log configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>GetRealtimeLogConfig</code> to get the current real-time log configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the parameters in the real-time log configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire real-time log configuration,
     * including the parameters that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     * <p>
     * You cannot update a real-time log configuration's <code>Name</code> or <code>ARN</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRealtimeLogConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param updateRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRealtimeLogConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRealtimeLogConfigResponse updateRealtimeLogConfig(
            Consumer<UpdateRealtimeLogConfigRequest.Builder> updateRealtimeLogConfigRequest)
            throws NoSuchRealtimeLogConfigException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return updateRealtimeLogConfig(UpdateRealtimeLogConfigRequest.builder().applyMutation(updateRealtimeLogConfigRequest)
                .build());
    }

    /**
     * <p>
     * Updates a response headers policy.
     * </p>
     * <p>
     * When you update a response headers policy, the entire policy is replaced. You cannot update some policy fields
     * independent of others. To update a response headers policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetResponseHeadersPolicyConfig</code> to get the current policy's configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Modify the fields in the response headers policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateResponseHeadersPolicy</code>, providing the entire response headers policy configuration,
     * including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateResponseHeadersPolicyRequest
     * @return Result of the UpdateResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ResponseHeadersPolicyAlreadyExistsException
     *         A response headers policy with this name already exists. You must provide a unique name. To modify an
     *         existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.
     * @throws TooManyCustomHeadersInResponseHeadersPolicyException
     *         The number of custom headers in the response headers policy exceeds the maximum.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooLongCspInResponseHeadersPolicyException
     *         The length of the <code>Content-Security-Policy</code> header value in the response headers policy
     *         exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyRemoveHeadersInResponseHeadersPolicyException
     *         The number of headers in <code>RemoveHeadersConfig</code> in the response headers policy exceeds the
     *         maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResponseHeadersPolicyResponse updateResponseHeadersPolicy(
            UpdateResponseHeadersPolicyRequest updateResponseHeadersPolicyRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchResponseHeadersPolicyException, PreconditionFailedException, ResponseHeadersPolicyAlreadyExistsException,
            TooManyCustomHeadersInResponseHeadersPolicyException, TooLongCspInResponseHeadersPolicyException,
            TooManyRemoveHeadersInResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a response headers policy.
     * </p>
     * <p>
     * When you update a response headers policy, the entire policy is replaced. You cannot update some policy fields
     * independent of others. To update a response headers policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetResponseHeadersPolicyConfig</code> to get the current policy's configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Modify the fields in the response headers policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateResponseHeadersPolicy</code>, providing the entire response headers policy configuration,
     * including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResponseHeadersPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateResponseHeadersPolicyRequest#builder()}
     * </p>
     *
     * @param updateResponseHeadersPolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResponseHeadersPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ResponseHeadersPolicyAlreadyExistsException
     *         A response headers policy with this name already exists. You must provide a unique name. To modify an
     *         existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.
     * @throws TooManyCustomHeadersInResponseHeadersPolicyException
     *         The number of custom headers in the response headers policy exceeds the maximum.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooLongCspInResponseHeadersPolicyException
     *         The length of the <code>Content-Security-Policy</code> header value in the response headers policy
     *         exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyRemoveHeadersInResponseHeadersPolicyException
     *         The number of headers in <code>RemoveHeadersConfig</code> in the response headers policy exceeds the
     *         maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResponseHeadersPolicyResponse updateResponseHeadersPolicy(
            Consumer<UpdateResponseHeadersPolicyRequest.Builder> updateResponseHeadersPolicyRequest)
            throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchResponseHeadersPolicyException, PreconditionFailedException,
            ResponseHeadersPolicyAlreadyExistsException, TooManyCustomHeadersInResponseHeadersPolicyException,
            TooLongCspInResponseHeadersPolicyException, TooManyRemoveHeadersInResponseHeadersPolicyException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return updateResponseHeadersPolicy(UpdateResponseHeadersPolicyRequest.builder()
                .applyMutation(updateResponseHeadersPolicyRequest).build());
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        The request to update a streaming distribution.
     * @return Result of the UpdateStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStreamingDistributionResponse updateStreamingDistribution(
            UpdateStreamingDistributionRequest updateStreamingDistributionRequest) throws AccessDeniedException,
            CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchStreamingDistributionException, PreconditionFailedException, TooManyStreamingDistributionCnamEsException,
            InvalidArgumentException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStreamingDistributionRequest.Builder} to create
     *        a request. The request to update a streaming distribution.
     * @return Result of the UpdateStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStreamingDistributionResponse updateStreamingDistribution(
            Consumer<UpdateStreamingDistributionRequest.Builder> updateStreamingDistributionRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchStreamingDistributionException, PreconditionFailedException,
            TooManyStreamingDistributionCnamEsException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateStreamingDistribution(UpdateStreamingDistributionRequest.builder()
                .applyMutation(updateStreamingDistributionRequest).build());
    }

    /**
     * Creates an instance of {@link CloudFrontUtilities} object with the configuration set on this client.
     */
    default CloudFrontUtilities utilities() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create an instance of {@link CloudFrontWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link CloudFrontWaiter}
     */
    default CloudFrontWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CloudFrontClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudFrontClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFrontClient}.
     */
    static CloudFrontClientBuilder builder() {
        return new DefaultCloudFrontClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CloudFrontServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
