/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;

public class DescribeStackEventsPublisher
implements SdkPublisher<DescribeStackEventsResponse> {
    private final CloudFormationAsyncClient client;
    private final DescribeStackEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStackEventsPublisher(CloudFormationAsyncClient client, DescribeStackEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStackEventsPublisher(CloudFormationAsyncClient client, DescribeStackEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStackEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStackEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackEvent> stackEvents() {
        Function<DescribeStackEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackEvents() != null) {
                return response.stackEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStackEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeStackEventsResponseFetcher
    implements AsyncPageFetcher<DescribeStackEventsResponse> {
        private DescribeStackEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStackEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStackEventsResponse> nextPage(DescribeStackEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStackEventsPublisher.this.client.describeStackEvents(DescribeStackEventsPublisher.this.firstRequest);
            }
            return DescribeStackEventsPublisher.this.client.describeStackEvents((DescribeStackEventsRequest)((Object)DescribeStackEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

