/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <a>CreateIndex</a> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateIndexResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchCreateIndexResponse.Builder, BatchCreateIndexResponse> {
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectIdentifier").getter(getter(BatchCreateIndexResponse::objectIdentifier))
            .setter(setter(Builder::objectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String objectIdentifier;

    private BatchCreateIndexResponse(BuilderImpl builder) {
        this.objectIdentifier = builder.objectIdentifier;
    }

    /**
     * <p>
     * The <code>ObjectIdentifier</code> of the index created by this operation.
     * </p>
     * 
     * @return The <code>ObjectIdentifier</code> of the index created by this operation.
     */
    public final String objectIdentifier() {
        return objectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateIndexResponse)) {
            return false;
        }
        BatchCreateIndexResponse other = (BatchCreateIndexResponse) obj;
        return Objects.equals(objectIdentifier(), other.objectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateIndexResponse").add("ObjectIdentifier", objectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectIdentifier":
            return Optional.ofNullable(clazz.cast(objectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateIndexResponse, T> g) {
        return obj -> g.apply((BatchCreateIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateIndexResponse> {
        /**
         * <p>
         * The <code>ObjectIdentifier</code> of the index created by this operation.
         * </p>
         * 
         * @param objectIdentifier
         *        The <code>ObjectIdentifier</code> of the index created by this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifier(String objectIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String objectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateIndexResponse model) {
            objectIdentifier(model.objectIdentifier);
        }

        public final String getObjectIdentifier() {
            return objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        @Override
        public BatchCreateIndexResponse build() {
            return new BatchCreateIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
