/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains statistics about the execution of the protected query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedQueryStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedQueryStatistics.Builder, ProtectedQueryStatistics> {
    private static final SdkField<Long> TOTAL_DURATION_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalDurationInMillis").getter(getter(ProtectedQueryStatistics::totalDurationInMillis))
            .setter(setter(Builder::totalDurationInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDurationInMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TOTAL_DURATION_IN_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalDurationInMillis;

    private ProtectedQueryStatistics(BuilderImpl builder) {
        this.totalDurationInMillis = builder.totalDurationInMillis;
    }

    /**
     * <p>
     * The duration of the Protected Query, from creation until query completion.
     * </p>
     * 
     * @return The duration of the Protected Query, from creation until query completion.
     */
    public final Long totalDurationInMillis() {
        return totalDurationInMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalDurationInMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQueryStatistics)) {
            return false;
        }
        ProtectedQueryStatistics other = (ProtectedQueryStatistics) obj;
        return Objects.equals(totalDurationInMillis(), other.totalDurationInMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedQueryStatistics").add("TotalDurationInMillis", totalDurationInMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalDurationInMillis":
            return Optional.ofNullable(clazz.cast(totalDurationInMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQueryStatistics, T> g) {
        return obj -> g.apply((ProtectedQueryStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedQueryStatistics> {
        /**
         * <p>
         * The duration of the Protected Query, from creation until query completion.
         * </p>
         * 
         * @param totalDurationInMillis
         *        The duration of the Protected Query, from creation until query completion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDurationInMillis(Long totalDurationInMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long totalDurationInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQueryStatistics model) {
            totalDurationInMillis(model.totalDurationInMillis);
        }

        public final Long getTotalDurationInMillis() {
            return totalDurationInMillis;
        }

        public final void setTotalDurationInMillis(Long totalDurationInMillis) {
            this.totalDurationInMillis = totalDurationInMillis;
        }

        @Override
        public final Builder totalDurationInMillis(Long totalDurationInMillis) {
            this.totalDurationInMillis = totalDurationInMillis;
            return this;
        }

        @Override
        public ProtectedQueryStatistics build() {
            return new ProtectedQueryStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
