/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaAnalysisRuleRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<GetSchemaAnalysisRuleRequest.Builder, GetSchemaAnalysisRuleRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(GetSchemaAnalysisRuleRequest::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetSchemaAnalysisRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetSchemaAnalysisRuleRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_IDENTIFIER_FIELD, NAME_FIELD, TYPE_FIELD));

    private final String collaborationIdentifier;

    private final String name;

    private final String type;

    private GetSchemaAnalysisRuleRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.name = builder.name;
        this.type = builder.type;
    }

    /**
     * <p>
     * A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration ID.
     * </p>
     * 
     * @return A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration
     *         ID.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The name of the schema to retrieve the analysis rule for.
     * </p>
     * 
     * @return The name of the schema to retrieve the analysis rule for.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a combination
     * of the collaboration, the schema name, and their type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a
     *         combination of the collaboration, the schema name, and their type.
     * @see AnalysisRuleType
     */
    public final AnalysisRuleType type() {
        return AnalysisRuleType.fromValue(type);
    }

    /**
     * <p>
     * The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a combination
     * of the collaboration, the schema name, and their type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a
     *         combination of the collaboration, the schema name, and their type.
     * @see AnalysisRuleType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaAnalysisRuleRequest)) {
            return false;
        }
        GetSchemaAnalysisRuleRequest other = (GetSchemaAnalysisRuleRequest) obj;
        return Objects.equals(collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSchemaAnalysisRuleRequest").add("CollaborationIdentifier", collaborationIdentifier())
                .add("Name", name()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaAnalysisRuleRequest, T> g) {
        return obj -> g.apply((GetSchemaAnalysisRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSchemaAnalysisRuleRequest> {
        /**
         * <p>
         * A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration ID.
         * </p>
         * 
         * @param collaborationIdentifier
         *        A unique identifier for the collaboration that the schema belongs to. Currently accepts a
         *        collaboration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The name of the schema to retrieve the analysis rule for.
         * </p>
         * 
         * @param name
         *        The name of the schema to retrieve the analysis rule for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a
         * combination of the collaboration, the schema name, and their type.
         * </p>
         * 
         * @param type
         *        The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a
         *        combination of the collaboration, the schema name, and their type.
         * @see AnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a
         * combination of the collaboration, the schema name, and their type.
         * </p>
         * 
         * @param type
         *        The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a
         *        combination of the collaboration, the schema name, and their type.
         * @see AnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisRuleType
         */
        Builder type(AnalysisRuleType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String collaborationIdentifier;

        private String name;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaAnalysisRuleRequest model) {
            super(model);
            collaborationIdentifier(model.collaborationIdentifier);
            name(model.name);
            type(model.type);
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AnalysisRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSchemaAnalysisRuleRequest build() {
            return new GetSchemaAnalysisRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
