/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAnalysisTemplateRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<GetAnalysisTemplateRequest.Builder, GetAnalysisTemplateRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(GetAnalysisTemplateRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> ANALYSIS_TEMPLATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisTemplateIdentifier").getter(getter(GetAnalysisTemplateRequest::analysisTemplateIdentifier))
            .setter(setter(Builder::analysisTemplateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("analysisTemplateIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            ANALYSIS_TEMPLATE_IDENTIFIER_FIELD));

    private final String membershipIdentifier;

    private final String analysisTemplateIdentifier;

    private GetAnalysisTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.analysisTemplateIdentifier = builder.analysisTemplateIdentifier;
    }

    /**
     * <p>
     * The identifier for a membership resource.
     * </p>
     * 
     * @return The identifier for a membership resource.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The identifier for the analysis template resource.
     * </p>
     * 
     * @return The identifier for the analysis template resource.
     */
    public final String analysisTemplateIdentifier() {
        return analysisTemplateIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(analysisTemplateIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnalysisTemplateRequest)) {
            return false;
        }
        GetAnalysisTemplateRequest other = (GetAnalysisTemplateRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(analysisTemplateIdentifier(), other.analysisTemplateIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAnalysisTemplateRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("AnalysisTemplateIdentifier", analysisTemplateIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "analysisTemplateIdentifier":
            return Optional.ofNullable(clazz.cast(analysisTemplateIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnalysisTemplateRequest, T> g) {
        return obj -> g.apply((GetAnalysisTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAnalysisTemplateRequest> {
        /**
         * <p>
         * The identifier for a membership resource.
         * </p>
         * 
         * @param membershipIdentifier
         *        The identifier for a membership resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The identifier for the analysis template resource.
         * </p>
         * 
         * @param analysisTemplateIdentifier
         *        The identifier for the analysis template resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisTemplateIdentifier(String analysisTemplateIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String analysisTemplateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnalysisTemplateRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            analysisTemplateIdentifier(model.analysisTemplateIdentifier);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getAnalysisTemplateIdentifier() {
            return analysisTemplateIdentifier;
        }

        public final void setAnalysisTemplateIdentifier(String analysisTemplateIdentifier) {
            this.analysisTemplateIdentifier = analysisTemplateIdentifier;
        }

        @Override
        public final Builder analysisTemplateIdentifier(String analysisTemplateIdentifier) {
            this.analysisTemplateIdentifier = analysisTemplateIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAnalysisTemplateRequest build() {
            return new GetAnalysisTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
