/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The analysis template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisTemplate.Builder, AnalysisTemplate> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AnalysisTemplate::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AnalysisTemplate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(AnalysisTemplate::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(AnalysisTemplate::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(AnalysisTemplate::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(AnalysisTemplate::membershipArn)).setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AnalysisTemplate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AnalysisTemplate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(AnalysisTemplate::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(AnalysisTemplate::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<AnalysisSchema> SCHEMA_FIELD = SdkField.<AnalysisSchema> builder(MarshallingType.SDK_POJO)
            .memberName("schema").getter(getter(AnalysisTemplate::schema)).setter(setter(Builder::schema))
            .constructor(AnalysisSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(AnalysisTemplate::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<AnalysisSource> SOURCE_FIELD = SdkField.<AnalysisSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(AnalysisTemplate::source)).setter(setter(Builder::source))
            .constructor(AnalysisSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<List<AnalysisParameter>> ANALYSIS_PARAMETERS_FIELD = SdkField
            .<List<AnalysisParameter>> builder(MarshallingType.LIST)
            .memberName("analysisParameters")
            .getter(getter(AnalysisTemplate::analysisParameters))
            .setter(setter(Builder::analysisParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ID_FIELD, ARN_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD, MEMBERSHIP_ID_FIELD,
                    MEMBERSHIP_ARN_FIELD, DESCRIPTION_FIELD, NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, SCHEMA_FIELD,
                    FORMAT_FIELD, SOURCE_FIELD, ANALYSIS_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String collaborationId;

    private final String collaborationArn;

    private final String membershipId;

    private final String membershipArn;

    private final String description;

    private final String name;

    private final Instant createTime;

    private final Instant updateTime;

    private final AnalysisSchema schema;

    private final String format;

    private final AnalysisSource source;

    private final List<AnalysisParameter> analysisParameters;

    private AnalysisTemplate(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.description = builder.description;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.schema = builder.schema;
        this.format = builder.format;
        this.source = builder.source;
        this.analysisParameters = builder.analysisParameters;
    }

    /**
     * <p>
     * The identifier for the analysis template.
     * </p>
     * 
     * @return The identifier for the analysis template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the analysis template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the analysis template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique ID for the associated collaboration of the analysis template.
     * </p>
     * 
     * @return The unique ID for the associated collaboration of the analysis template.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The unique ARN for the analysis template’s associated collaboration.
     * </p>
     * 
     * @return The unique ARN for the analysis template’s associated collaboration.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The identifier of a member who created the analysis template.
     * </p>
     * 
     * @return The identifier of a member who created the analysis template.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the member who created the analysis template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the member who created the analysis template.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The description of the analysis template.
     * </p>
     * 
     * @return The description of the analysis template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the analysis template.
     * </p>
     * 
     * @return The name of the analysis template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time that the analysis template was created.
     * </p>
     * 
     * @return The time that the analysis template was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time that the analysis template was last updated.
     * </p>
     * 
     * @return The time that the analysis template was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The entire schema object.
     * </p>
     * 
     * @return The entire schema object.
     */
    public final AnalysisSchema schema() {
        return schema;
    }

    /**
     * <p>
     * The format of the analysis template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link AnalysisFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the analysis template.
     * @see AnalysisFormat
     */
    public final AnalysisFormat format() {
        return AnalysisFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the analysis template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link AnalysisFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the analysis template.
     * @see AnalysisFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The source of the analysis template.
     * </p>
     * 
     * @return The source of the analysis template.
     */
    public final AnalysisSource source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisParameters() {
        return analysisParameters != null && !(analysisParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters of the analysis template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisParameters} method.
     * </p>
     * 
     * @return The parameters of the analysis template.
     */
    public final List<AnalysisParameter> analysisParameters() {
        return analysisParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisParameters() ? analysisParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisTemplate)) {
            return false;
        }
        AnalysisTemplate other = (AnalysisTemplate) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(schema(), other.schema()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(source(), other.source()) && hasAnalysisParameters() == other.hasAnalysisParameters()
                && Objects.equals(analysisParameters(), other.analysisParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisTemplate").add("Id", id()).add("Arn", arn()).add("CollaborationId", collaborationId())
                .add("CollaborationArn", collaborationArn()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("Description", description()).add("Name", name())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("Schema", schema())
                .add("Format", formatAsString()).add("Source", source() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AnalysisParameters", analysisParameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "analysisParameters":
            return Optional.ofNullable(clazz.cast(analysisParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisTemplate, T> g) {
        return obj -> g.apply((AnalysisTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisTemplate> {
        /**
         * <p>
         * The identifier for the analysis template.
         * </p>
         * 
         * @param id
         *        The identifier for the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the analysis template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique ID for the associated collaboration of the analysis template.
         * </p>
         * 
         * @param collaborationId
         *        The unique ID for the associated collaboration of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The unique ARN for the analysis template’s associated collaboration.
         * </p>
         * 
         * @param collaborationArn
         *        The unique ARN for the analysis template’s associated collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The identifier of a member who created the analysis template.
         * </p>
         * 
         * @param membershipId
         *        The identifier of a member who created the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the member who created the analysis template.
         * </p>
         * 
         * @param membershipArn
         *        The Amazon Resource Name (ARN) of the member who created the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The description of the analysis template.
         * </p>
         * 
         * @param description
         *        The description of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the analysis template.
         * </p>
         * 
         * @param name
         *        The name of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time that the analysis template was created.
         * </p>
         * 
         * @param createTime
         *        The time that the analysis template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time that the analysis template was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time that the analysis template was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The entire schema object.
         * </p>
         * 
         * @param schema
         *        The entire schema object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(AnalysisSchema schema);

        /**
         * <p>
         * The entire schema object.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisSchema.Builder} avoiding the need
         * to create one manually via {@link AnalysisSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #schema(AnalysisSchema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link AnalysisSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(AnalysisSchema)
         */
        default Builder schema(Consumer<AnalysisSchema.Builder> schema) {
            return schema(AnalysisSchema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * The format of the analysis template.
         * </p>
         * 
         * @param format
         *        The format of the analysis template.
         * @see AnalysisFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the analysis template.
         * </p>
         * 
         * @param format
         *        The format of the analysis template.
         * @see AnalysisFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisFormat
         */
        Builder format(AnalysisFormat format);

        /**
         * <p>
         * The source of the analysis template.
         * </p>
         * 
         * @param source
         *        The source of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(AnalysisSource source);

        /**
         * <p>
         * The source of the analysis template.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisSource.Builder} avoiding the need
         * to create one manually via {@link AnalysisSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(AnalysisSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link AnalysisSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(AnalysisSource)
         */
        default Builder source(Consumer<AnalysisSource.Builder> source) {
            return source(AnalysisSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The parameters of the analysis template.
         * </p>
         * 
         * @param analysisParameters
         *        The parameters of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisParameters(Collection<AnalysisParameter> analysisParameters);

        /**
         * <p>
         * The parameters of the analysis template.
         * </p>
         * 
         * @param analysisParameters
         *        The parameters of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisParameters(AnalysisParameter... analysisParameters);

        /**
         * <p>
         * The parameters of the analysis template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #analysisParameters(List<AnalysisParameter>)}.
         * 
         * @param analysisParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisParameters(java.util.Collection<AnalysisParameter>)
         */
        Builder analysisParameters(Consumer<AnalysisParameter.Builder>... analysisParameters);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String collaborationId;

        private String collaborationArn;

        private String membershipId;

        private String membershipArn;

        private String description;

        private String name;

        private Instant createTime;

        private Instant updateTime;

        private AnalysisSchema schema;

        private String format;

        private AnalysisSource source;

        private List<AnalysisParameter> analysisParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisTemplate model) {
            id(model.id);
            arn(model.arn);
            collaborationId(model.collaborationId);
            collaborationArn(model.collaborationArn);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            description(model.description);
            name(model.name);
            createTime(model.createTime);
            updateTime(model.updateTime);
            schema(model.schema);
            format(model.format);
            source(model.source);
            analysisParameters(model.analysisParameters);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final AnalysisSchema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(AnalysisSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(AnalysisSchema schema) {
            this.schema = schema;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(AnalysisFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final AnalysisSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(AnalysisSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(AnalysisSource source) {
            this.source = source;
            return this;
        }

        public final List<AnalysisParameter.Builder> getAnalysisParameters() {
            List<AnalysisParameter.Builder> result = AnalysisParameterListCopier.copyToBuilder(this.analysisParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisParameters(Collection<AnalysisParameter.BuilderImpl> analysisParameters) {
            this.analysisParameters = AnalysisParameterListCopier.copyFromBuilder(analysisParameters);
        }

        @Override
        public final Builder analysisParameters(Collection<AnalysisParameter> analysisParameters) {
            this.analysisParameters = AnalysisParameterListCopier.copy(analysisParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisParameters(AnalysisParameter... analysisParameters) {
            analysisParameters(Arrays.asList(analysisParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisParameters(Consumer<AnalysisParameter.Builder>... analysisParameters) {
            analysisParameters(Stream.of(analysisParameters).map(c -> AnalysisParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalysisTemplate build() {
            return new AnalysisTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
