/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembershipsResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<ListMembershipsResponse.Builder, ListMembershipsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMembershipsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<MembershipSummary>> MEMBERSHIP_SUMMARIES_FIELD = SdkField
            .<List<MembershipSummary>> builder(MarshallingType.LIST)
            .memberName("membershipSummaries")
            .getter(getter(ListMembershipsResponse::membershipSummaries))
            .setter(setter(Builder::membershipSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MembershipSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MembershipSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MEMBERSHIP_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<MembershipSummary> membershipSummaries;

    private ListMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.membershipSummaries = builder.membershipSummaries;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MembershipSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMembershipSummaries() {
        return membershipSummaries != null && !(membershipSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of memberships returned from the ListMemberships operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembershipSummaries} method.
     * </p>
     * 
     * @return The list of memberships returned from the ListMemberships operation.
     */
    public final List<MembershipSummary> membershipSummaries() {
        return membershipSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMembershipSummaries() ? membershipSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembershipsResponse)) {
            return false;
        }
        ListMembershipsResponse other = (ListMembershipsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasMembershipSummaries() == other.hasMembershipSummaries()
                && Objects.equals(membershipSummaries(), other.membershipSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMembershipsResponse").add("NextToken", nextToken())
                .add("MembershipSummaries", hasMembershipSummaries() ? membershipSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "membershipSummaries":
            return Optional.ofNullable(clazz.cast(membershipSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMembershipsResponse, T> g) {
        return obj -> g.apply((ListMembershipsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMembershipsResponse> {
        /**
         * <p>
         * The token value retrieved from a previous call to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value retrieved from a previous call to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of memberships returned from the ListMemberships operation.
         * </p>
         * 
         * @param membershipSummaries
         *        The list of memberships returned from the ListMemberships operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipSummaries(Collection<MembershipSummary> membershipSummaries);

        /**
         * <p>
         * The list of memberships returned from the ListMemberships operation.
         * </p>
         * 
         * @param membershipSummaries
         *        The list of memberships returned from the ListMemberships operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipSummaries(MembershipSummary... membershipSummaries);

        /**
         * <p>
         * The list of memberships returned from the ListMemberships operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.MembershipSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cleanrooms.model.MembershipSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.MembershipSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #membershipSummaries(List<MembershipSummary>)}.
         * 
         * @param membershipSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.MembershipSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #membershipSummaries(java.util.Collection<MembershipSummary>)
         */
        Builder membershipSummaries(Consumer<MembershipSummary.Builder>... membershipSummaries);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MembershipSummary> membershipSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembershipsResponse model) {
            super(model);
            nextToken(model.nextToken);
            membershipSummaries(model.membershipSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MembershipSummary.Builder> getMembershipSummaries() {
            List<MembershipSummary.Builder> result = MembershipSummaryListCopier.copyToBuilder(this.membershipSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembershipSummaries(Collection<MembershipSummary.BuilderImpl> membershipSummaries) {
            this.membershipSummaries = MembershipSummaryListCopier.copyFromBuilder(membershipSummaries);
        }

        @Override
        public final Builder membershipSummaries(Collection<MembershipSummary> membershipSummaries) {
            this.membershipSummaries = MembershipSummaryListCopier.copy(membershipSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipSummaries(MembershipSummary... membershipSummaries) {
            membershipSummaries(Arrays.asList(membershipSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipSummaries(Consumer<MembershipSummary.Builder>... membershipSummaries) {
            membershipSummaries(Stream.of(membershipSummaries).map(c -> MembershipSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMembershipsResponse build() {
            return new ListMembershipsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
