/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for client-side encryption for cryptographic computing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataEncryptionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DataEncryptionMetadata.Builder, DataEncryptionMetadata> {
    private static final SdkField<Boolean> ALLOW_CLEARTEXT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowCleartext").getter(getter(DataEncryptionMetadata::allowCleartext))
            .setter(setter(Builder::allowCleartext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowCleartext").build()).build();

    private static final SdkField<Boolean> ALLOW_DUPLICATES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowDuplicates").getter(getter(DataEncryptionMetadata::allowDuplicates))
            .setter(setter(Builder::allowDuplicates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowDuplicates").build()).build();

    private static final SdkField<Boolean> ALLOW_JOINS_ON_COLUMNS_WITH_DIFFERENT_NAMES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowJoinsOnColumnsWithDifferentNames")
            .getter(getter(DataEncryptionMetadata::allowJoinsOnColumnsWithDifferentNames))
            .setter(setter(Builder::allowJoinsOnColumnsWithDifferentNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("allowJoinsOnColumnsWithDifferentNames").build()).build();

    private static final SdkField<Boolean> PRESERVE_NULLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("preserveNulls").getter(getter(DataEncryptionMetadata::preserveNulls))
            .setter(setter(Builder::preserveNulls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preserveNulls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_CLEARTEXT_FIELD,
            ALLOW_DUPLICATES_FIELD, ALLOW_JOINS_ON_COLUMNS_WITH_DIFFERENT_NAMES_FIELD, PRESERVE_NULLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowCleartext;

    private final Boolean allowDuplicates;

    private final Boolean allowJoinsOnColumnsWithDifferentNames;

    private final Boolean preserveNulls;

    private DataEncryptionMetadata(BuilderImpl builder) {
        this.allowCleartext = builder.allowCleartext;
        this.allowDuplicates = builder.allowDuplicates;
        this.allowJoinsOnColumnsWithDifferentNames = builder.allowJoinsOnColumnsWithDifferentNames;
        this.preserveNulls = builder.preserveNulls;
    }

    /**
     * <p>
     * Indicates whether encrypted tables can contain cleartext data (true) or are to cryptographically process every
     * column (false).
     * </p>
     * 
     * @return Indicates whether encrypted tables can contain cleartext data (true) or are to cryptographically process
     *         every column (false).
     */
    public final Boolean allowCleartext() {
        return allowCleartext;
    }

    /**
     * <p>
     * Indicates whether Fingerprint columns can contain duplicate entries (true) or are to contain only non-repeated
     * values (false).
     * </p>
     * 
     * @return Indicates whether Fingerprint columns can contain duplicate entries (true) or are to contain only
     *         non-repeated values (false).
     */
    public final Boolean allowDuplicates() {
        return allowDuplicates;
    }

    /**
     * <p>
     * Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name (true)
     * or can only be joined on Fingerprint columns of the same name (false).
     * </p>
     * 
     * @return Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name
     *         (true) or can only be joined on Fingerprint columns of the same name (false).
     */
    public final Boolean allowJoinsOnColumnsWithDifferentNames() {
        return allowJoinsOnColumnsWithDifferentNames;
    }

    /**
     * <p>
     * Indicates whether NULL values are to be copied as NULL to encrypted tables (true) or cryptographically processed
     * (false).
     * </p>
     * 
     * @return Indicates whether NULL values are to be copied as NULL to encrypted tables (true) or cryptographically
     *         processed (false).
     */
    public final Boolean preserveNulls() {
        return preserveNulls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowCleartext());
        hashCode = 31 * hashCode + Objects.hashCode(allowDuplicates());
        hashCode = 31 * hashCode + Objects.hashCode(allowJoinsOnColumnsWithDifferentNames());
        hashCode = 31 * hashCode + Objects.hashCode(preserveNulls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataEncryptionMetadata)) {
            return false;
        }
        DataEncryptionMetadata other = (DataEncryptionMetadata) obj;
        return Objects.equals(allowCleartext(), other.allowCleartext())
                && Objects.equals(allowDuplicates(), other.allowDuplicates())
                && Objects.equals(allowJoinsOnColumnsWithDifferentNames(), other.allowJoinsOnColumnsWithDifferentNames())
                && Objects.equals(preserveNulls(), other.preserveNulls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataEncryptionMetadata").add("AllowCleartext", allowCleartext())
                .add("AllowDuplicates", allowDuplicates())
                .add("AllowJoinsOnColumnsWithDifferentNames", allowJoinsOnColumnsWithDifferentNames())
                .add("PreserveNulls", preserveNulls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowCleartext":
            return Optional.ofNullable(clazz.cast(allowCleartext()));
        case "allowDuplicates":
            return Optional.ofNullable(clazz.cast(allowDuplicates()));
        case "allowJoinsOnColumnsWithDifferentNames":
            return Optional.ofNullable(clazz.cast(allowJoinsOnColumnsWithDifferentNames()));
        case "preserveNulls":
            return Optional.ofNullable(clazz.cast(preserveNulls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataEncryptionMetadata, T> g) {
        return obj -> g.apply((DataEncryptionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataEncryptionMetadata> {
        /**
         * <p>
         * Indicates whether encrypted tables can contain cleartext data (true) or are to cryptographically process
         * every column (false).
         * </p>
         * 
         * @param allowCleartext
         *        Indicates whether encrypted tables can contain cleartext data (true) or are to cryptographically
         *        process every column (false).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCleartext(Boolean allowCleartext);

        /**
         * <p>
         * Indicates whether Fingerprint columns can contain duplicate entries (true) or are to contain only
         * non-repeated values (false).
         * </p>
         * 
         * @param allowDuplicates
         *        Indicates whether Fingerprint columns can contain duplicate entries (true) or are to contain only
         *        non-repeated values (false).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowDuplicates(Boolean allowDuplicates);

        /**
         * <p>
         * Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name
         * (true) or can only be joined on Fingerprint columns of the same name (false).
         * </p>
         * 
         * @param allowJoinsOnColumnsWithDifferentNames
         *        Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different
         *        name (true) or can only be joined on Fingerprint columns of the same name (false).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowJoinsOnColumnsWithDifferentNames(Boolean allowJoinsOnColumnsWithDifferentNames);

        /**
         * <p>
         * Indicates whether NULL values are to be copied as NULL to encrypted tables (true) or cryptographically
         * processed (false).
         * </p>
         * 
         * @param preserveNulls
         *        Indicates whether NULL values are to be copied as NULL to encrypted tables (true) or cryptographically
         *        processed (false).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preserveNulls(Boolean preserveNulls);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowCleartext;

        private Boolean allowDuplicates;

        private Boolean allowJoinsOnColumnsWithDifferentNames;

        private Boolean preserveNulls;

        private BuilderImpl() {
        }

        private BuilderImpl(DataEncryptionMetadata model) {
            allowCleartext(model.allowCleartext);
            allowDuplicates(model.allowDuplicates);
            allowJoinsOnColumnsWithDifferentNames(model.allowJoinsOnColumnsWithDifferentNames);
            preserveNulls(model.preserveNulls);
        }

        public final Boolean getAllowCleartext() {
            return allowCleartext;
        }

        public final void setAllowCleartext(Boolean allowCleartext) {
            this.allowCleartext = allowCleartext;
        }

        @Override
        public final Builder allowCleartext(Boolean allowCleartext) {
            this.allowCleartext = allowCleartext;
            return this;
        }

        public final Boolean getAllowDuplicates() {
            return allowDuplicates;
        }

        public final void setAllowDuplicates(Boolean allowDuplicates) {
            this.allowDuplicates = allowDuplicates;
        }

        @Override
        public final Builder allowDuplicates(Boolean allowDuplicates) {
            this.allowDuplicates = allowDuplicates;
            return this;
        }

        public final Boolean getAllowJoinsOnColumnsWithDifferentNames() {
            return allowJoinsOnColumnsWithDifferentNames;
        }

        public final void setAllowJoinsOnColumnsWithDifferentNames(Boolean allowJoinsOnColumnsWithDifferentNames) {
            this.allowJoinsOnColumnsWithDifferentNames = allowJoinsOnColumnsWithDifferentNames;
        }

        @Override
        public final Builder allowJoinsOnColumnsWithDifferentNames(Boolean allowJoinsOnColumnsWithDifferentNames) {
            this.allowJoinsOnColumnsWithDifferentNames = allowJoinsOnColumnsWithDifferentNames;
            return this;
        }

        public final Boolean getPreserveNulls() {
            return preserveNulls;
        }

        public final void setPreserveNulls(Boolean preserveNulls) {
            this.preserveNulls = preserveNulls;
        }

        @Override
        public final Builder preserveNulls(Boolean preserveNulls) {
            this.preserveNulls = preserveNulls;
            return this;
        }

        @Override
        public DataEncryptionMetadata build() {
            return new DataEncryptionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
