/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.TranscriptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMeetingTranscriptionRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, StartMeetingTranscriptionRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(StartMeetingTranscriptionRequest.getter(StartMeetingTranscriptionRequest::meetingId)).setter(StartMeetingTranscriptionRequest.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meetingId").build()}).build();
    private static final SdkField<TranscriptionConfiguration> TRANSCRIPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TranscriptionConfiguration").getter(StartMeetingTranscriptionRequest.getter(StartMeetingTranscriptionRequest::transcriptionConfiguration)).setter(StartMeetingTranscriptionRequest.setter(Builder::transcriptionConfiguration)).constructor(TranscriptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, TRANSCRIPTION_CONFIGURATION_FIELD));
    private final String meetingId;
    private final TranscriptionConfiguration transcriptionConfiguration;

    private StartMeetingTranscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.transcriptionConfiguration = builder.transcriptionConfiguration;
    }

    public final String meetingId() {
        return this.meetingId;
    }

    public final TranscriptionConfiguration transcriptionConfiguration() {
        return this.transcriptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMeetingTranscriptionRequest)) {
            return false;
        }
        StartMeetingTranscriptionRequest other = (StartMeetingTranscriptionRequest)((Object)obj);
        return Objects.equals(this.meetingId(), other.meetingId()) && Objects.equals(this.transcriptionConfiguration(), other.transcriptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartMeetingTranscriptionRequest").add("MeetingId", (Object)this.meetingId()).add("TranscriptionConfiguration", (Object)this.transcriptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "TranscriptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.transcriptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMeetingTranscriptionRequest, T> g) {
        return obj -> g.apply((StartMeetingTranscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String meetingId;
        private TranscriptionConfiguration transcriptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMeetingTranscriptionRequest model) {
            super(model);
            this.meetingId(model.meetingId);
            this.transcriptionConfiguration(model.transcriptionConfiguration);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final TranscriptionConfiguration.Builder getTranscriptionConfiguration() {
            return this.transcriptionConfiguration != null ? this.transcriptionConfiguration.toBuilder() : null;
        }

        public final void setTranscriptionConfiguration(TranscriptionConfiguration.BuilderImpl transcriptionConfiguration) {
            this.transcriptionConfiguration = transcriptionConfiguration != null ? transcriptionConfiguration.build() : null;
        }

        @Override
        public final Builder transcriptionConfiguration(TranscriptionConfiguration transcriptionConfiguration) {
            this.transcriptionConfiguration = transcriptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMeetingTranscriptionRequest build() {
            return new StartMeetingTranscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMeetingTranscriptionRequest> {
        public Builder meetingId(String var1);

        public Builder transcriptionConfiguration(TranscriptionConfiguration var1);

        default public Builder transcriptionConfiguration(Consumer<TranscriptionConfiguration.Builder> transcriptionConfiguration) {
            return this.transcriptionConfiguration((TranscriptionConfiguration)((TranscriptionConfiguration.Builder)TranscriptionConfiguration.builder().applyMutation(transcriptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

