/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BotType {
    CHAT_BOT("ChatBot"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BotType> VALUE_MAP;
    private final String value;

    private BotType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BotType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BotType> knownValues() {
        EnumSet<BotType> knownValues = EnumSet.allOf(BotType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BotType.class, BotType::toString);
    }
}

