/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.BotType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Bot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Bot> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BotId").getter(Bot.getter(Bot::botId)).setter(Bot.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(Bot.getter(Bot::userId)).setter(Bot.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(Bot.getter(Bot::displayName)).setter(Bot.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> BOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BotType").getter(Bot.getter(Bot::botTypeAsString)).setter(Bot.setter(Builder::botType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotType").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(Bot.getter(Bot::disabled)).setter(Bot.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(Bot.getter(Bot::createdTimestamp)).setter(Bot.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(Bot.getter(Bot::updatedTimestamp)).setter(Bot.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> BOT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BotEmail").getter(Bot.getter(Bot::botEmail)).setter(Bot.setter(Builder::botEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotEmail").build()}).build();
    private static final SdkField<String> SECURITY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityToken").getter(Bot.getter(Bot::securityToken)).setter(Bot.setter(Builder::securityToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, USER_ID_FIELD, DISPLAY_NAME_FIELD, BOT_TYPE_FIELD, DISABLED_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, BOT_EMAIL_FIELD, SECURITY_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String botId;
    private final String userId;
    private final String displayName;
    private final String botType;
    private final Boolean disabled;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;
    private final String botEmail;
    private final String securityToken;

    private Bot(BuilderImpl builder) {
        this.botId = builder.botId;
        this.userId = builder.userId;
        this.displayName = builder.displayName;
        this.botType = builder.botType;
        this.disabled = builder.disabled;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.botEmail = builder.botEmail;
        this.securityToken = builder.securityToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final BotType botType() {
        return BotType.fromValue(this.botType);
    }

    public final String botTypeAsString() {
        return this.botType;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public final String botEmail() {
        return this.botEmail;
    }

    public final String securityToken() {
        return this.securityToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.botEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bot)) {
            return false;
        }
        Bot other = (Bot)obj;
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.botTypeAsString(), other.botTypeAsString()) && Objects.equals(this.disabled(), other.disabled()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(this.botEmail(), other.botEmail()) && Objects.equals(this.securityToken(), other.securityToken());
    }

    public final String toString() {
        return ToString.builder((String)"Bot").add("BotId", (Object)this.botId()).add("UserId", (Object)this.userId()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("BotType", (Object)this.botTypeAsString()).add("Disabled", (Object)this.disabled()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).add("BotEmail", (Object)(this.botEmail() == null ? null : "*** Sensitive Data Redacted ***")).add("SecurityToken", (Object)(this.securityToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BotId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "BotType": {
                return Optional.ofNullable(clazz.cast(this.botTypeAsString()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
            case "BotEmail": {
                return Optional.ofNullable(clazz.cast(this.botEmail()));
            }
            case "SecurityToken": {
                return Optional.ofNullable(clazz.cast(this.securityToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Bot, T> g) {
        return obj -> g.apply((Bot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botId;
        private String userId;
        private String displayName;
        private String botType;
        private Boolean disabled;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;
        private String botEmail;
        private String securityToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Bot model) {
            this.botId(model.botId);
            this.userId(model.userId);
            this.displayName(model.displayName);
            this.botType(model.botType);
            this.disabled(model.disabled);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
            this.botEmail(model.botEmail);
            this.securityToken(model.securityToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getBotType() {
            return this.botType;
        }

        public final void setBotType(String botType) {
            this.botType = botType;
        }

        @Override
        public final Builder botType(String botType) {
            this.botType = botType;
            return this;
        }

        @Override
        public final Builder botType(BotType botType) {
            this.botType(botType == null ? null : botType.toString());
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final String getBotEmail() {
            return this.botEmail;
        }

        public final void setBotEmail(String botEmail) {
            this.botEmail = botEmail;
        }

        @Override
        public final Builder botEmail(String botEmail) {
            this.botEmail = botEmail;
            return this;
        }

        public final String getSecurityToken() {
            return this.securityToken;
        }

        public final void setSecurityToken(String securityToken) {
            this.securityToken = securityToken;
        }

        @Override
        public final Builder securityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        public Bot build() {
            return new Bot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Bot> {
        public Builder botId(String var1);

        public Builder userId(String var1);

        public Builder displayName(String var1);

        public Builder botType(String var1);

        public Builder botType(BotType var1);

        public Builder disabled(Boolean var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);

        public Builder botEmail(String var1);

        public Builder securityToken(String var1);
    }
}

