/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The member details, such as email address, name, member ID, and member type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Member implements SdkPojo, Serializable, ToCopyableBuilder<Member.Builder, Member> {
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberId").getter(getter(Member::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberType").getter(getter(Member::memberTypeAsString)).setter(setter(Builder::memberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberType").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(Member::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> FULL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FullName").getter(getter(Member::fullName)).setter(setter(Builder::fullName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullName").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Member::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ID_FIELD,
            MEMBER_TYPE_FIELD, EMAIL_FIELD, FULL_NAME_FIELD, ACCOUNT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String memberId;

    private final String memberType;

    private final String email;

    private final String fullName;

    private final String accountId;

    private Member(BuilderImpl builder) {
        this.memberId = builder.memberId;
        this.memberType = builder.memberType;
        this.email = builder.email;
        this.fullName = builder.fullName;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * The member ID (user ID or bot ID).
     * </p>
     * 
     * @return The member ID (user ID or bot ID).
     */
    public final String memberId() {
        return memberId;
    }

    /**
     * <p>
     * The member type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The member type.
     * @see MemberType
     */
    public final MemberType memberType() {
        return MemberType.fromValue(memberType);
    }

    /**
     * <p>
     * The member type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The member type.
     * @see MemberType
     */
    public final String memberTypeAsString() {
        return memberType;
    }

    /**
     * <p>
     * The member email address.
     * </p>
     * 
     * @return The member email address.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The member name.
     * </p>
     * 
     * @return The member name.
     */
    public final String fullName() {
        return fullName;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(memberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(fullName());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member) obj;
        return Objects.equals(memberId(), other.memberId()) && Objects.equals(memberTypeAsString(), other.memberTypeAsString())
                && Objects.equals(email(), other.email()) && Objects.equals(fullName(), other.fullName())
                && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Member").add("MemberId", memberId()).add("MemberType", memberTypeAsString())
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FullName", fullName() == null ? null : "*** Sensitive Data Redacted ***").add("AccountId", accountId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "MemberType":
            return Optional.ofNullable(clazz.cast(memberTypeAsString()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "FullName":
            return Optional.ofNullable(clazz.cast(fullName()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Member> {
        /**
         * <p>
         * The member ID (user ID or bot ID).
         * </p>
         * 
         * @param memberId
         *        The member ID (user ID or bot ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);

        /**
         * <p>
         * The member type.
         * </p>
         * 
         * @param memberType
         *        The member type.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder memberType(String memberType);

        /**
         * <p>
         * The member type.
         * </p>
         * 
         * @param memberType
         *        The member type.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder memberType(MemberType memberType);

        /**
         * <p>
         * The member email address.
         * </p>
         * 
         * @param email
         *        The member email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The member name.
         * </p>
         * 
         * @param fullName
         *        The member name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullName(String fullName);

        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private String memberId;

        private String memberType;

        private String email;

        private String fullName;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            memberId(model.memberId);
            memberType(model.memberType);
            email(model.email);
            fullName(model.fullName);
            accountId(model.accountId);
        }

        public final String getMemberId() {
            return memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final String getMemberType() {
            return memberType;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MemberType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getFullName() {
            return fullName;
        }

        public final void setFullName(String fullName) {
            this.fullName = fullName;
        }

        @Override
        public final Builder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Member build() {
            return new Member(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
