/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Invitation object returned after emailing users to invite them to join the Amazon Chime <code>Team</code> account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Invite implements SdkPojo, Serializable, ToCopyableBuilder<Invite.Builder, Invite> {
    private static final SdkField<String> INVITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InviteId").getter(getter(Invite::inviteId)).setter(setter(Builder::inviteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InviteId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Invite::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(Invite::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> EMAIL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailStatus").getter(getter(Invite::emailStatusAsString)).setter(setter(Builder::emailStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITE_ID_FIELD, STATUS_FIELD,
            EMAIL_ADDRESS_FIELD, EMAIL_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inviteId;

    private final String status;

    private final String emailAddress;

    private final String emailStatus;

    private Invite(BuilderImpl builder) {
        this.inviteId = builder.inviteId;
        this.status = builder.status;
        this.emailAddress = builder.emailAddress;
        this.emailStatus = builder.emailStatus;
    }

    /**
     * <p>
     * The invite ID.
     * </p>
     * 
     * @return The invite ID.
     */
    public final String inviteId() {
        return inviteId;
    }

    /**
     * <p>
     * The status of the invite.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InviteStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the invite.
     * @see InviteStatus
     */
    public final InviteStatus status() {
        return InviteStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the invite.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InviteStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the invite.
     * @see InviteStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The email address to which the invite is sent.
     * </p>
     * 
     * @return The email address to which the invite is sent.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The status of the invite email.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #emailStatus} will
     * return {@link EmailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #emailStatusAsString}.
     * </p>
     * 
     * @return The status of the invite email.
     * @see EmailStatus
     */
    public final EmailStatus emailStatus() {
        return EmailStatus.fromValue(emailStatus);
    }

    /**
     * <p>
     * The status of the invite email.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #emailStatus} will
     * return {@link EmailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #emailStatusAsString}.
     * </p>
     * 
     * @return The status of the invite email.
     * @see EmailStatus
     */
    public final String emailStatusAsString() {
        return emailStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inviteId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(emailStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invite)) {
            return false;
        }
        Invite other = (Invite) obj;
        return Objects.equals(inviteId(), other.inviteId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(emailStatusAsString(), other.emailStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Invite").add("InviteId", inviteId()).add("Status", statusAsString())
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailStatus", emailStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InviteId":
            return Optional.ofNullable(clazz.cast(inviteId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "EmailStatus":
            return Optional.ofNullable(clazz.cast(emailStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Invite, T> g) {
        return obj -> g.apply((Invite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Invite> {
        /**
         * <p>
         * The invite ID.
         * </p>
         * 
         * @param inviteId
         *        The invite ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inviteId(String inviteId);

        /**
         * <p>
         * The status of the invite.
         * </p>
         * 
         * @param status
         *        The status of the invite.
         * @see InviteStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InviteStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the invite.
         * </p>
         * 
         * @param status
         *        The status of the invite.
         * @see InviteStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InviteStatus
         */
        Builder status(InviteStatus status);

        /**
         * <p>
         * The email address to which the invite is sent.
         * </p>
         * 
         * @param emailAddress
         *        The email address to which the invite is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The status of the invite email.
         * </p>
         * 
         * @param emailStatus
         *        The status of the invite email.
         * @see EmailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmailStatus
         */
        Builder emailStatus(String emailStatus);

        /**
         * <p>
         * The status of the invite email.
         * </p>
         * 
         * @param emailStatus
         *        The status of the invite email.
         * @see EmailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmailStatus
         */
        Builder emailStatus(EmailStatus emailStatus);
    }

    static final class BuilderImpl implements Builder {
        private String inviteId;

        private String status;

        private String emailAddress;

        private String emailStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Invite model) {
            inviteId(model.inviteId);
            status(model.status);
            emailAddress(model.emailAddress);
            emailStatus(model.emailStatus);
        }

        public final String getInviteId() {
            return inviteId;
        }

        public final void setInviteId(String inviteId) {
            this.inviteId = inviteId;
        }

        @Override
        public final Builder inviteId(String inviteId) {
            this.inviteId = inviteId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InviteStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getEmailStatus() {
            return emailStatus;
        }

        public final void setEmailStatus(String emailStatus) {
            this.emailStatus = emailStatus;
        }

        @Override
        public final Builder emailStatus(String emailStatus) {
            this.emailStatus = emailStatus;
            return this;
        }

        @Override
        public final Builder emailStatus(EmailStatus emailStatus) {
            this.emailStatus(emailStatus == null ? null : emailStatus.toString());
            return this;
        }

        @Override
        public Invite build() {
            return new Invite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
