/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListChannelBansRequest;
import software.amazon.awssdk.services.chime.model.ListChannelBansResponse;

public class ListChannelBansIterable
implements SdkIterable<ListChannelBansResponse> {
    private final ChimeClient client;
    private final ListChannelBansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelBansIterable(ChimeClient client, ListChannelBansRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChannelBansResponseFetcher();
    }

    public Iterator<ListChannelBansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelBansResponseFetcher
    implements SyncPageFetcher<ListChannelBansResponse> {
        private ListChannelBansResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelBansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelBansResponse nextPage(ListChannelBansResponse previousPage) {
            if (previousPage == null) {
                return ListChannelBansIterable.this.client.listChannelBans(ListChannelBansIterable.this.firstRequest);
            }
            return ListChannelBansIterable.this.client.listChannelBans((ListChannelBansRequest)((Object)ListChannelBansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

