/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.RoomMembership;
import software.amazon.awssdk.services.chime.model.RoomMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoomMembershipsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListRoomMembershipsResponse> {
    private static final SdkField<List<RoomMembership>> ROOM_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoomMemberships").getter(ListRoomMembershipsResponse.getter(ListRoomMembershipsResponse::roomMemberships)).setter(ListRoomMembershipsResponse.setter(Builder::roomMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomMemberships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoomMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRoomMembershipsResponse.getter(ListRoomMembershipsResponse::nextToken)).setter(ListRoomMembershipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_MEMBERSHIPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RoomMembership> roomMemberships;
    private final String nextToken;

    private ListRoomMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.roomMemberships = builder.roomMemberships;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRoomMemberships() {
        return this.roomMemberships != null && !(this.roomMemberships instanceof SdkAutoConstructList);
    }

    public final List<RoomMembership> roomMemberships() {
        return this.roomMemberships;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoomMemberships() ? this.roomMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoomMembershipsResponse)) {
            return false;
        }
        ListRoomMembershipsResponse other = (ListRoomMembershipsResponse)((Object)obj);
        return this.hasRoomMemberships() == other.hasRoomMemberships() && Objects.equals(this.roomMemberships(), other.roomMemberships()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoomMembershipsResponse").add("RoomMemberships", this.hasRoomMemberships() ? this.roomMemberships() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomMemberships": {
                return Optional.ofNullable(clazz.cast(this.roomMemberships()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoomMembershipsResponse, T> g) {
        return obj -> g.apply((ListRoomMembershipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<RoomMembership> roomMemberships = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoomMembershipsResponse model) {
            super(model);
            this.roomMemberships(model.roomMemberships);
            this.nextToken(model.nextToken);
        }

        public final List<RoomMembership.Builder> getRoomMemberships() {
            List<RoomMembership.Builder> result = RoomMembershipListCopier.copyToBuilder(this.roomMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoomMemberships(Collection<RoomMembership.BuilderImpl> roomMemberships) {
            this.roomMemberships = RoomMembershipListCopier.copyFromBuilder(roomMemberships);
        }

        @Override
        public final Builder roomMemberships(Collection<RoomMembership> roomMemberships) {
            this.roomMemberships = RoomMembershipListCopier.copy(roomMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomMemberships(RoomMembership ... roomMemberships) {
            this.roomMemberships(Arrays.asList(roomMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomMemberships(Consumer<RoomMembership.Builder> ... roomMemberships) {
            this.roomMemberships(Stream.of(roomMemberships).map(c -> (RoomMembership)((RoomMembership.Builder)RoomMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRoomMembershipsResponse build() {
            return new ListRoomMembershipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoomMembershipsResponse> {
        public Builder roomMemberships(Collection<RoomMembership> var1);

        public Builder roomMemberships(RoomMembership ... var1);

        public Builder roomMemberships(Consumer<RoomMembership.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

