/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.BudgetsRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNotificationRequest
extends BudgetsRequest
implements ToCopyableBuilder<Builder, UpdateNotificationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(UpdateNotificationRequest.getter(UpdateNotificationRequest::accountId)).setter(UpdateNotificationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(UpdateNotificationRequest.getter(UpdateNotificationRequest::budgetName)).setter(UpdateNotificationRequest.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<Notification> OLD_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OldNotification").getter(UpdateNotificationRequest.getter(UpdateNotificationRequest::oldNotification)).setter(UpdateNotificationRequest.setter(Builder::oldNotification)).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldNotification").build()}).build();
    private static final SdkField<Notification> NEW_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewNotification").getter(UpdateNotificationRequest.getter(UpdateNotificationRequest::newNotification)).setter(UpdateNotificationRequest.setter(Builder::newNotification)).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewNotification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUDGET_NAME_FIELD, OLD_NOTIFICATION_FIELD, NEW_NOTIFICATION_FIELD));
    private final String accountId;
    private final String budgetName;
    private final Notification oldNotification;
    private final Notification newNotification;

    private UpdateNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.oldNotification = builder.oldNotification;
        this.newNotification = builder.newNotification;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String budgetName() {
        return this.budgetName;
    }

    public final Notification oldNotification() {
        return this.oldNotification;
    }

    public final Notification newNotification() {
        return this.newNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.oldNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.newNotification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationRequest)) {
            return false;
        }
        UpdateNotificationRequest other = (UpdateNotificationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.oldNotification(), other.oldNotification()) && Objects.equals(this.newNotification(), other.newNotification());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNotificationRequest").add("AccountId", (Object)this.accountId()).add("BudgetName", (Object)this.budgetName()).add("OldNotification", (Object)this.oldNotification()).add("NewNotification", (Object)this.newNotification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "OldNotification": {
                return Optional.ofNullable(clazz.cast(this.oldNotification()));
            }
            case "NewNotification": {
                return Optional.ofNullable(clazz.cast(this.newNotification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotificationRequest, T> g) {
        return obj -> g.apply((UpdateNotificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification oldNotification;
        private Notification newNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.oldNotification(model.oldNotification);
            this.newNotification(model.newNotification);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final Notification.Builder getOldNotification() {
            return this.oldNotification != null ? this.oldNotification.toBuilder() : null;
        }

        public final void setOldNotification(Notification.BuilderImpl oldNotification) {
            this.oldNotification = oldNotification != null ? oldNotification.build() : null;
        }

        @Override
        public final Builder oldNotification(Notification oldNotification) {
            this.oldNotification = oldNotification;
            return this;
        }

        public final Notification.Builder getNewNotification() {
            return this.newNotification != null ? this.newNotification.toBuilder() : null;
        }

        public final void setNewNotification(Notification.BuilderImpl newNotification) {
            this.newNotification = newNotification != null ? newNotification.build() : null;
        }

        @Override
        public final Builder newNotification(Notification newNotification) {
            this.newNotification = newNotification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationRequest build() {
            return new UpdateNotificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BudgetsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNotificationRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder oldNotification(Notification var1);

        default public Builder oldNotification(Consumer<Notification.Builder> oldNotification) {
            return this.oldNotification((Notification)((Notification.Builder)Notification.builder().applyMutation(oldNotification)).build());
        }

        public Builder newNotification(Notification var1);

        default public Builder newNotification(Consumer<Notification.Builder> newNotification) {
            return this.newNotification((Notification)((Notification.Builder)Notification.builder().applyMutation(newNotification)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

