/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.BraketResponse;
import software.amazon.awssdk.services.braket.model.CancellationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelJobResponse
extends BraketResponse
implements ToCopyableBuilder<Builder, CancelJobResponse> {
    private static final SdkField<String> CANCELLATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cancellationStatus").getter(CancelJobResponse.getter(CancelJobResponse::cancellationStatusAsString)).setter(CancelJobResponse.setter(Builder::cancellationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancellationStatus").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(CancelJobResponse.getter(CancelJobResponse::jobArn)).setter(CancelJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELLATION_STATUS_FIELD, JOB_ARN_FIELD));
    private final String cancellationStatus;
    private final String jobArn;

    private CancelJobResponse(BuilderImpl builder) {
        super(builder);
        this.cancellationStatus = builder.cancellationStatus;
        this.jobArn = builder.jobArn;
    }

    public final CancellationStatus cancellationStatus() {
        return CancellationStatus.fromValue(this.cancellationStatus);
    }

    public final String cancellationStatusAsString() {
        return this.cancellationStatus;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cancellationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelJobResponse)) {
            return false;
        }
        CancelJobResponse other = (CancelJobResponse)((Object)obj);
        return Objects.equals(this.cancellationStatusAsString(), other.cancellationStatusAsString()) && Objects.equals(this.jobArn(), other.jobArn());
    }

    public final String toString() {
        return ToString.builder((String)"CancelJobResponse").add("CancellationStatus", (Object)this.cancellationStatusAsString()).add("JobArn", (Object)this.jobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cancellationStatus": {
                return Optional.ofNullable(clazz.cast(this.cancellationStatusAsString()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelJobResponse, T> g) {
        return obj -> g.apply((CancelJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketResponse.BuilderImpl
    implements Builder {
        private String cancellationStatus;
        private String jobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelJobResponse model) {
            super(model);
            this.cancellationStatus(model.cancellationStatus);
            this.jobArn(model.jobArn);
        }

        public final String getCancellationStatus() {
            return this.cancellationStatus;
        }

        public final void setCancellationStatus(String cancellationStatus) {
            this.cancellationStatus = cancellationStatus;
        }

        @Override
        public final Builder cancellationStatus(String cancellationStatus) {
            this.cancellationStatus = cancellationStatus;
            return this;
        }

        @Override
        public final Builder cancellationStatus(CancellationStatus cancellationStatus) {
            this.cancellationStatus(cancellationStatus == null ? null : cancellationStatus.toString());
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        @Override
        public CancelJobResponse build() {
            return new CancelJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BraketResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelJobResponse> {
        public Builder cancellationStatus(String var1);

        public Builder cancellationStatus(CancellationStatus var1);

        public Builder jobArn(String var1);
    }
}

