/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that specifies the billing period range where the custom line item versions reside.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomLineItemVersionsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListCustomLineItemVersionsFilter.Builder, ListCustomLineItemVersionsFilter> {
    private static final SdkField<ListCustomLineItemVersionsBillingPeriodRangeFilter> BILLING_PERIOD_RANGE_FIELD = SdkField
            .<ListCustomLineItemVersionsBillingPeriodRangeFilter> builder(MarshallingType.SDK_POJO)
            .memberName("BillingPeriodRange").getter(getter(ListCustomLineItemVersionsFilter::billingPeriodRange))
            .setter(setter(Builder::billingPeriodRange)).constructor(ListCustomLineItemVersionsBillingPeriodRangeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ListCustomLineItemVersionsBillingPeriodRangeFilter billingPeriodRange;

    private ListCustomLineItemVersionsFilter(BuilderImpl builder) {
        this.billingPeriodRange = builder.billingPeriodRange;
    }

    /**
     * <p>
     * The billing period range in which the custom line item version is applied.
     * </p>
     * 
     * @return The billing period range in which the custom line item version is applied.
     */
    public final ListCustomLineItemVersionsBillingPeriodRangeFilter billingPeriodRange() {
        return billingPeriodRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriodRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomLineItemVersionsFilter)) {
            return false;
        }
        ListCustomLineItemVersionsFilter other = (ListCustomLineItemVersionsFilter) obj;
        return Objects.equals(billingPeriodRange(), other.billingPeriodRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomLineItemVersionsFilter").add("BillingPeriodRange", billingPeriodRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingPeriodRange":
            return Optional.ofNullable(clazz.cast(billingPeriodRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomLineItemVersionsFilter, T> g) {
        return obj -> g.apply((ListCustomLineItemVersionsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCustomLineItemVersionsFilter> {
        /**
         * <p>
         * The billing period range in which the custom line item version is applied.
         * </p>
         * 
         * @param billingPeriodRange
         *        The billing period range in which the custom line item version is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriodRange(ListCustomLineItemVersionsBillingPeriodRangeFilter billingPeriodRange);

        /**
         * <p>
         * The billing period range in which the custom line item version is applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ListCustomLineItemVersionsBillingPeriodRangeFilter.Builder} avoiding the need to create one manually
         * via {@link ListCustomLineItemVersionsBillingPeriodRangeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link ListCustomLineItemVersionsBillingPeriodRangeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #billingPeriodRange(ListCustomLineItemVersionsBillingPeriodRangeFilter)}.
         * 
         * @param billingPeriodRange
         *        a consumer that will call methods on
         *        {@link ListCustomLineItemVersionsBillingPeriodRangeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingPeriodRange(ListCustomLineItemVersionsBillingPeriodRangeFilter)
         */
        default Builder billingPeriodRange(Consumer<ListCustomLineItemVersionsBillingPeriodRangeFilter.Builder> billingPeriodRange) {
            return billingPeriodRange(ListCustomLineItemVersionsBillingPeriodRangeFilter.builder()
                    .applyMutation(billingPeriodRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ListCustomLineItemVersionsBillingPeriodRangeFilter billingPeriodRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomLineItemVersionsFilter model) {
            billingPeriodRange(model.billingPeriodRange);
        }

        public final ListCustomLineItemVersionsBillingPeriodRangeFilter.Builder getBillingPeriodRange() {
            return billingPeriodRange != null ? billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(ListCustomLineItemVersionsBillingPeriodRangeFilter.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(ListCustomLineItemVersionsBillingPeriodRangeFilter billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        @Override
        public ListCustomLineItemVersionsFilter build() {
            return new ListCustomLineItemVersionsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
