/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of the charge details that are associated with a percentage custom line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLineItemPercentageChargeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLineItemPercentageChargeDetails.Builder, CustomLineItemPercentageChargeDetails> {
    private static final SdkField<Double> PERCENTAGE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PercentageValue").getter(getter(CustomLineItemPercentageChargeDetails::percentageValue))
            .setter(setter(Builder::percentageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageValue").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedValues")
            .getter(getter(CustomLineItemPercentageChargeDetails::associatedValues))
            .setter(setter(Builder::associatedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTAGE_VALUE_FIELD,
            ASSOCIATED_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double percentageValue;

    private final List<String> associatedValues;

    private CustomLineItemPercentageChargeDetails(BuilderImpl builder) {
        this.percentageValue = builder.percentageValue;
        this.associatedValues = builder.associatedValues;
    }

    /**
     * <p>
     * The custom line item's percentage value. This will be multiplied against the combined value of its associated
     * resources to determine its charge value.
     * </p>
     * 
     * @return The custom line item's percentage value. This will be multiplied against the combined value of its
     *         associated resources to determine its charge value.
     */
    public final Double percentageValue() {
        return percentageValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedValues() {
        return associatedValues != null && !(associatedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource ARNs to associate to the percentage custom line item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedValues} method.
     * </p>
     * 
     * @return A list of resource ARNs to associate to the percentage custom line item.
     */
    public final List<String> associatedValues() {
        return associatedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percentageValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedValues() ? associatedValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemPercentageChargeDetails)) {
            return false;
        }
        CustomLineItemPercentageChargeDetails other = (CustomLineItemPercentageChargeDetails) obj;
        return Objects.equals(percentageValue(), other.percentageValue()) && hasAssociatedValues() == other.hasAssociatedValues()
                && Objects.equals(associatedValues(), other.associatedValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLineItemPercentageChargeDetails").add("PercentageValue", percentageValue())
                .add("AssociatedValues", hasAssociatedValues() ? associatedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentageValue":
            return Optional.ofNullable(clazz.cast(percentageValue()));
        case "AssociatedValues":
            return Optional.ofNullable(clazz.cast(associatedValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemPercentageChargeDetails, T> g) {
        return obj -> g.apply((CustomLineItemPercentageChargeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLineItemPercentageChargeDetails> {
        /**
         * <p>
         * The custom line item's percentage value. This will be multiplied against the combined value of its associated
         * resources to determine its charge value.
         * </p>
         * 
         * @param percentageValue
         *        The custom line item's percentage value. This will be multiplied against the combined value of its
         *        associated resources to determine its charge value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageValue(Double percentageValue);

        /**
         * <p>
         * A list of resource ARNs to associate to the percentage custom line item.
         * </p>
         * 
         * @param associatedValues
         *        A list of resource ARNs to associate to the percentage custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedValues(Collection<String> associatedValues);

        /**
         * <p>
         * A list of resource ARNs to associate to the percentage custom line item.
         * </p>
         * 
         * @param associatedValues
         *        A list of resource ARNs to associate to the percentage custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedValues(String... associatedValues);
    }

    static final class BuilderImpl implements Builder {
        private Double percentageValue;

        private List<String> associatedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemPercentageChargeDetails model) {
            percentageValue(model.percentageValue);
            associatedValues(model.associatedValues);
        }

        public final Double getPercentageValue() {
            return percentageValue;
        }

        public final void setPercentageValue(Double percentageValue) {
            this.percentageValue = percentageValue;
        }

        @Override
        public final Builder percentageValue(Double percentageValue) {
            this.percentageValue = percentageValue;
            return this;
        }

        public final Collection<String> getAssociatedValues() {
            if (associatedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedValues;
        }

        public final void setAssociatedValues(Collection<String> associatedValues) {
            this.associatedValues = CustomLineItemAssociationsListCopier.copy(associatedValues);
        }

        @Override
        public final Builder associatedValues(Collection<String> associatedValues) {
            this.associatedValues = CustomLineItemAssociationsListCopier.copy(associatedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedValues(String... associatedValues) {
            associatedValues(Arrays.asList(associatedValues));
            return this;
        }

        @Override
        public CustomLineItemPercentageChargeDetails build() {
            return new CustomLineItemPercentageChargeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
