/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputationPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputationPreference.Builder, ComputationPreference> {
    private static final SdkField<String> PRICING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanArn").getter(getter(ComputationPreference::pricingPlanArn))
            .setter(setter(Builder::pricingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_PLAN_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pricingPlanArn;

    private ComputationPreference(BuilderImpl builder) {
        this.pricingPlanArn = builder.pricingPlanArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pricing plan that's used to compute the Amazon Web Services charges for a
     * billing group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pricing plan that's used to compute the Amazon Web Services charges
     *         for a billing group.
     */
    public final String pricingPlanArn() {
        return pricingPlanArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationPreference)) {
            return false;
        }
        ComputationPreference other = (ComputationPreference) obj;
        return Objects.equals(pricingPlanArn(), other.pricingPlanArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputationPreference").add("PricingPlanArn", pricingPlanArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PricingPlanArn":
            return Optional.ofNullable(clazz.cast(pricingPlanArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputationPreference, T> g) {
        return obj -> g.apply((ComputationPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputationPreference> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pricing plan that's used to compute the Amazon Web Services charges for
         * a billing group.
         * </p>
         * 
         * @param pricingPlanArn
         *        The Amazon Resource Name (ARN) of the pricing plan that's used to compute the Amazon Web Services
         *        charges for a billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlanArn(String pricingPlanArn);
    }

    static final class BuilderImpl implements Builder {
        private String pricingPlanArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationPreference model) {
            pricingPlanArn(model.pricingPlanArn);
        }

        public final String getPricingPlanArn() {
            return pricingPlanArn;
        }

        public final void setPricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
        }

        @Override
        public final Builder pricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
            return this;
        }

        @Override
        public ComputationPreference build() {
            return new ComputationPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
