/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponseElement;

public class ListResourcesAssociatedToCustomLineItemPublisher
implements SdkPublisher<ListResourcesAssociatedToCustomLineItemResponse> {
    private final BillingconductorAsyncClient client;
    private final ListResourcesAssociatedToCustomLineItemRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourcesAssociatedToCustomLineItemPublisher(BillingconductorAsyncClient client, ListResourcesAssociatedToCustomLineItemRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourcesAssociatedToCustomLineItemPublisher(BillingconductorAsyncClient client, ListResourcesAssociatedToCustomLineItemRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourcesAssociatedToCustomLineItemResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourcesAssociatedToCustomLineItemResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListResourcesAssociatedToCustomLineItemResponseElement> associatedResources() {
        Function<ListResourcesAssociatedToCustomLineItemResponse, Iterator> getIterator = response -> {
            if (response != null && response.associatedResources() != null) {
                return response.associatedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourcesAssociatedToCustomLineItemResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourcesAssociatedToCustomLineItemResponseFetcher
    implements AsyncPageFetcher<ListResourcesAssociatedToCustomLineItemResponse> {
        private ListResourcesAssociatedToCustomLineItemResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesAssociatedToCustomLineItemResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourcesAssociatedToCustomLineItemResponse> nextPage(ListResourcesAssociatedToCustomLineItemResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesAssociatedToCustomLineItemPublisher.this.client.listResourcesAssociatedToCustomLineItem(ListResourcesAssociatedToCustomLineItemPublisher.this.firstRequest);
            }
            return ListResourcesAssociatedToCustomLineItemPublisher.this.client.listResourcesAssociatedToCustomLineItem((ListResourcesAssociatedToCustomLineItemRequest)((Object)ListResourcesAssociatedToCustomLineItemPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

