/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleListElement;

public class ListPricingRulesIterable
implements SdkIterable<ListPricingRulesResponse> {
    private final BillingconductorClient client;
    private final ListPricingRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPricingRulesIterable(BillingconductorClient client, ListPricingRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPricingRulesResponseFetcher();
    }

    public Iterator<ListPricingRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PricingRuleListElement> pricingRules() {
        Function<ListPricingRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pricingRules() != null) {
                return response.pricingRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPricingRulesResponseFetcher
    implements SyncPageFetcher<ListPricingRulesResponse> {
        private ListPricingRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListPricingRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPricingRulesResponse nextPage(ListPricingRulesResponse previousPage) {
            if (previousPage == null) {
                return ListPricingRulesIterable.this.client.listPricingRules(ListPricingRulesIterable.this.firstRequest);
            }
            return ListPricingRulesIterable.this.client.listPricingRules((ListPricingRulesRequest)((Object)ListPricingRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

