/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupArnListCopier;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemArnsCopier;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomLineItemsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListCustomLineItemsFilter> {
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(ListCustomLineItemsFilter.getter(ListCustomLineItemsFilter::names)).setter(ListCustomLineItemsFilter.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BILLING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BillingGroups").getter(ListCustomLineItemsFilter.getter(ListCustomLineItemsFilter::billingGroups)).setter(ListCustomLineItemsFilter.setter(Builder::billingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Arns").getter(ListCustomLineItemsFilter.getter(ListCustomLineItemsFilter::arns)).setter(ListCustomLineItemsFilter.setter(Builder::arns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMES_FIELD, BILLING_GROUPS_FIELD, ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> names;
    private final List<String> billingGroups;
    private final List<String> arns;

    private ListCustomLineItemsFilter(BuilderImpl builder) {
        this.names = builder.names;
        this.billingGroups = builder.billingGroups;
        this.arns = builder.arns;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<String> names() {
        return this.names;
    }

    public final boolean hasBillingGroups() {
        return this.billingGroups != null && !(this.billingGroups instanceof SdkAutoConstructList);
    }

    public final List<String> billingGroups() {
        return this.billingGroups;
    }

    public final boolean hasArns() {
        return this.arns != null && !(this.arns instanceof SdkAutoConstructList);
    }

    public final List<String> arns() {
        return this.arns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBillingGroups() ? this.billingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArns() ? this.arns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomLineItemsFilter)) {
            return false;
        }
        ListCustomLineItemsFilter other = (ListCustomLineItemsFilter)obj;
        return this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && this.hasBillingGroups() == other.hasBillingGroups() && Objects.equals(this.billingGroups(), other.billingGroups()) && this.hasArns() == other.hasArns() && Objects.equals(this.arns(), other.arns());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomLineItemsFilter").add("Names", (Object)(this.names() == null ? null : "*** Sensitive Data Redacted ***")).add("BillingGroups", this.hasBillingGroups() ? this.billingGroups() : null).add("Arns", this.hasArns() ? this.arns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "BillingGroups": {
                return Optional.ofNullable(clazz.cast(this.billingGroups()));
            }
            case "Arns": {
                return Optional.ofNullable(clazz.cast(this.arns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomLineItemsFilter, T> g) {
        return obj -> g.apply((ListCustomLineItemsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private List<String> billingGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomLineItemsFilter model) {
            this.names(model.names);
            this.billingGroups(model.billingGroups);
            this.arns(model.arns);
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        public final void setNames(Collection<String> names) {
            this.names = CustomLineItemNameListCopier.copy(names);
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = CustomLineItemNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final Collection<String> getBillingGroups() {
            if (this.billingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.billingGroups;
        }

        public final void setBillingGroups(Collection<String> billingGroups) {
            this.billingGroups = BillingGroupArnListCopier.copy(billingGroups);
        }

        @Override
        public final Builder billingGroups(Collection<String> billingGroups) {
            this.billingGroups = BillingGroupArnListCopier.copy(billingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroups(String ... billingGroups) {
            this.billingGroups(Arrays.asList(billingGroups));
            return this;
        }

        public final Collection<String> getArns() {
            if (this.arns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = CustomLineItemArnsCopier.copy(arns);
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = CustomLineItemArnsCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String ... arns) {
            this.arns(Arrays.asList(arns));
            return this;
        }

        public ListCustomLineItemsFilter build() {
            return new ListCustomLineItemsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListCustomLineItemsFilter> {
        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder billingGroups(Collection<String> var1);

        public Builder billingGroups(String ... var1);

        public Builder arns(Collection<String> var1);

        public Builder arns(String ... var1);
    }
}

