/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.EksLimitsCopier;
import software.amazon.awssdk.services.batch.model.EksRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksContainerResourceRequirements
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksContainerResourceRequirements> {
    private static final SdkField<Map<String, String>> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("limits").getter(EksContainerResourceRequirements.getter(EksContainerResourceRequirements::limits)).setter(EksContainerResourceRequirements.setter(Builder::limits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limits").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requests").getter(EksContainerResourceRequirements.getter(EksContainerResourceRequirements::requests)).setter(EksContainerResourceRequirements.setter(Builder::requests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requests").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMITS_FIELD, REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EksContainerResourceRequirements.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> limits;
    private final Map<String, String> requests;

    private EksContainerResourceRequirements(BuilderImpl builder) {
        this.limits = builder.limits;
        this.requests = builder.requests;
    }

    public final boolean hasLimits() {
        return this.limits != null && !(this.limits instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> limits() {
        return this.limits;
    }

    public final boolean hasRequests() {
        return this.requests != null && !(this.requests instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requests() {
        return this.requests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLimits() ? this.limits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequests() ? this.requests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksContainerResourceRequirements)) {
            return false;
        }
        EksContainerResourceRequirements other = (EksContainerResourceRequirements)obj;
        return this.hasLimits() == other.hasLimits() && Objects.equals(this.limits(), other.limits()) && this.hasRequests() == other.hasRequests() && Objects.equals(this.requests(), other.requests());
    }

    public final String toString() {
        return ToString.builder((String)"EksContainerResourceRequirements").add("Limits", this.hasLimits() ? this.limits() : null).add("Requests", this.hasRequests() ? this.requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "requests": {
                return Optional.ofNullable(clazz.cast(this.requests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, String>>> map = new HashMap<String, SdkField<Map<String, String>>>();
        map.put("limits", LIMITS_FIELD);
        map.put("requests", REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksContainerResourceRequirements, T> g) {
        return obj -> g.apply((EksContainerResourceRequirements)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> limits = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requests = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EksContainerResourceRequirements model) {
            this.limits(model.limits);
            this.requests(model.requests);
        }

        public final Map<String, String> getLimits() {
            if (this.limits instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.limits;
        }

        public final void setLimits(Map<String, String> limits) {
            this.limits = EksLimitsCopier.copy(limits);
        }

        @Override
        public final Builder limits(Map<String, String> limits) {
            this.limits = EksLimitsCopier.copy(limits);
            return this;
        }

        public final Map<String, String> getRequests() {
            if (this.requests instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requests;
        }

        public final void setRequests(Map<String, String> requests) {
            this.requests = EksRequestsCopier.copy(requests);
        }

        @Override
        public final Builder requests(Map<String, String> requests) {
            this.requests = EksRequestsCopier.copy(requests);
            return this;
        }

        public EksContainerResourceRequirements build() {
            return new EksContainerResourceRequirements(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksContainerResourceRequirements> {
        public Builder limits(Map<String, String> var1);

        public Builder requests(Map<String, String> var1);
    }
}

