/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobDefinitionType {
    CONTAINER("container"),
    MULTINODE("multinode"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobDefinitionType> VALUE_MAP;
    private final String value;

    private JobDefinitionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobDefinitionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobDefinitionType> knownValues() {
        EnumSet<JobDefinitionType> knownValues = EnumSet.allOf(JobDefinitionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobDefinitionType.class, JobDefinitionType::toString);
    }
}

