/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupstorage.BackupStorageClient;
import software.amazon.awssdk.services.backupstorage.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupstorage.model.ListChunksRequest;
import software.amazon.awssdk.services.backupstorage.model.ListChunksResponse;

public class ListChunksIterable
implements SdkIterable<ListChunksResponse> {
    private final BackupStorageClient client;
    private final ListChunksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChunksIterable(BackupStorageClient client, ListChunksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChunksResponseFetcher();
    }

    public Iterator<ListChunksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChunksResponseFetcher
    implements SyncPageFetcher<ListChunksResponse> {
        private ListChunksResponseFetcher() {
        }

        public boolean hasNextPage(ListChunksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChunksResponse nextPage(ListChunksResponse previousPage) {
            if (previousPage == null) {
                return ListChunksIterable.this.client.listChunks(ListChunksIterable.this.firstRequest);
            }
            return ListChunksIterable.this.client.listChunks((ListChunksRequest)((Object)ListChunksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

