/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.query.internal.unmarshall;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.protocols.core.StringToInstant;
import software.amazon.awssdk.protocols.core.StringToValueConverter;
import software.amazon.awssdk.protocols.query.internal.marshall.SimpleTypeQueryMarshaller;
import software.amazon.awssdk.protocols.query.internal.unmarshall.ListQueryUnmarshaller;
import software.amazon.awssdk.protocols.query.internal.unmarshall.MapQueryUnmarshaller;
import software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshaller;
import software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshallerContext;
import software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshallerRegistry;
import software.amazon.awssdk.protocols.query.internal.unmarshall.SimpleTypeQueryUnmarshaller;
import software.amazon.awssdk.protocols.query.unmarshall.XmlDomParser;
import software.amazon.awssdk.protocols.query.unmarshall.XmlElement;
import software.amazon.awssdk.protocols.query.unmarshall.XmlErrorUnmarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.builder.Buildable;

@SdkInternalApi
public final class QueryProtocolUnmarshaller
implements XmlErrorUnmarshaller {
    private static final QueryUnmarshallerRegistry UNMARSHALLER_REGISTRY = QueryUnmarshallerRegistry.builder().unmarshaller(MarshallingType.STRING, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_STRING)).unmarshaller(MarshallingType.INTEGER, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_INTEGER)).unmarshaller(MarshallingType.LONG, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_LONG)).unmarshaller(MarshallingType.SHORT, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_SHORT)).unmarshaller(MarshallingType.FLOAT, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_FLOAT)).unmarshaller(MarshallingType.DOUBLE, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_DOUBLE)).unmarshaller(MarshallingType.BOOLEAN, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_BOOLEAN)).unmarshaller(MarshallingType.DOUBLE, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_DOUBLE)).unmarshaller(MarshallingType.INSTANT, new SimpleTypeQueryUnmarshaller(StringToInstant.create(SimpleTypeQueryMarshaller.defaultTimestampFormats()))).unmarshaller(MarshallingType.SDK_BYTES, new SimpleTypeQueryUnmarshaller(StringToValueConverter.TO_SDK_BYTES)).unmarshaller(MarshallingType.LIST, new ListQueryUnmarshaller()).unmarshaller(MarshallingType.MAP, new MapQueryUnmarshaller()).unmarshaller(MarshallingType.NULL, (context, content, field) -> null).unmarshaller(MarshallingType.SDK_POJO, (context, content, field) -> context.protocolUnmarshaller().unmarshall(context, (SdkPojo)field.constructor().get(), (XmlElement)content.get(0))).build();
    private final boolean hasResultWrapper;

    private QueryProtocolUnmarshaller(Builder builder) {
        this.hasResultWrapper = builder.hasResultWrapper;
    }

    public <TypeT extends SdkPojo> Pair<TypeT, Map<String, String>> unmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response) {
        XmlElement document = response.content().map(XmlDomParser::parse).orElse(XmlElement.empty());
        XmlElement resultRoot = this.hasResultWrapper ? document.getFirstChild() : document;
        return Pair.of(this.unmarshall(sdkPojo, resultRoot, response), this.parseMetadata(document));
    }

    @Override
    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, XmlElement resultRoot, SdkHttpFullResponse response) {
        QueryUnmarshallerContext unmarshallerContext = QueryUnmarshallerContext.builder().registry(UNMARSHALLER_REGISTRY).protocolUnmarshaller(this).build();
        return (TypeT)this.unmarshall(unmarshallerContext, sdkPojo, resultRoot);
    }

    private Map<String, String> parseMetadata(XmlElement document) {
        XmlElement requestId;
        XmlElement responseMetadata = document.getElementByName("ResponseMetadata");
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (responseMetadata != null) {
            responseMetadata.children().forEach(c -> metadata.put(this.metadataKeyName((XmlElement)c), c.textContent()));
        }
        if ((requestId = document.getElementByName("requestId")) != null) {
            metadata.put("AWS_REQUEST_ID", requestId.textContent());
        }
        return metadata;
    }

    private String metadataKeyName(XmlElement c) {
        return c.elementName().equals("RequestId") ? "AWS_REQUEST_ID" : c.elementName();
    }

    private SdkPojo unmarshall(QueryUnmarshallerContext context, SdkPojo sdkPojo, XmlElement root) {
        if (root != null) {
            for (SdkField field : sdkPojo.sdkFields()) {
                List<XmlElement> element = root.getElementsByName(field.unmarshallLocationName());
                if (CollectionUtils.isNullOrEmpty(element)) continue;
                QueryUnmarshaller<Object> unmarshaller = UNMARSHALLER_REGISTRY.getUnmarshaller(field.location(), field.marshallingType());
                Object unmarshalled = unmarshaller.unmarshall(context, element, (SdkField<Object>)field);
                field.set((Object)sdkPojo, unmarshalled);
            }
        }
        return (SdkPojo)((Buildable)sdkPojo).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean hasResultWrapper;

        private Builder() {
        }

        public Builder hasResultWrapper(boolean hasResultWrapper) {
            this.hasResultWrapper = hasResultWrapper;
            return this;
        }

        public QueryProtocolUnmarshaller build() {
            return new QueryProtocolUnmarshaller(this);
        }
    }
}

