/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.authcrt.signer.AwsCrtV4aSigner;
import software.amazon.awssdk.authcrt.signer.internal.AwsCrt4aSigningAdapter;
import software.amazon.awssdk.authcrt.signer.internal.SigningConfigProvider;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.regions.RegionScope;

@SdkInternalApi
public final class DefaultAwsCrtV4aSigner
implements AwsCrtV4aSigner {
    private final AwsCrt4aSigningAdapter signer;
    private final SigningConfigProvider configProvider;
    private final RegionScope defaultRegionScope;

    private DefaultAwsCrtV4aSigner(BuilderImpl builder) {
        this(new AwsCrt4aSigningAdapter(), new SigningConfigProvider(), builder.defaultRegionScope);
    }

    DefaultAwsCrtV4aSigner(AwsCrt4aSigningAdapter signer, SigningConfigProvider configProvider, RegionScope defaultRegionScope) {
        this.signer = signer;
        this.configProvider = configProvider;
        this.defaultRegionScope = defaultRegionScope;
    }

    public static AwsCrtV4aSigner create() {
        return DefaultAwsCrtV4aSigner.builder().build();
    }

    public static AwsCrtV4aSigner.Builder builder() {
        return new BuilderImpl();
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        if (CredentialUtils.isAnonymous((AwsCredentials)((AwsCredentials)executionAttributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS)))) {
            return request;
        }
        ExecutionAttributes defaultsApplied = this.applyDefaults(executionAttributes);
        return this.signer.signRequest(request, this.configProvider.createCrtSigningConfig(defaultsApplied));
    }

    public SdkHttpFullRequest presign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        ExecutionAttributes defaultsApplied = this.applyDefaults(executionAttributes);
        return this.signer.signRequest(request, this.configProvider.createCrtPresigningConfig(defaultsApplied));
    }

    private ExecutionAttributes applyDefaults(ExecutionAttributes executionAttributes) {
        return this.applyDefaultRegionScope(executionAttributes);
    }

    private ExecutionAttributes applyDefaultRegionScope(ExecutionAttributes executionAttributes) {
        if (executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE) != null) {
            return executionAttributes;
        }
        if (this.defaultRegionScope == null) {
            return executionAttributes;
        }
        return executionAttributes.copy().putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE, (Object)this.defaultRegionScope);
    }

    private static class BuilderImpl
    implements AwsCrtV4aSigner.Builder {
        private RegionScope defaultRegionScope;

        private BuilderImpl() {
        }

        @Override
        public AwsCrtV4aSigner.Builder defaultRegionScope(RegionScope defaultRegionScope) {
            this.defaultRegionScope = defaultRegionScope;
            return this;
        }

        @Override
        public AwsCrtV4aSigner build() {
            return new DefaultAwsCrtV4aSigner(this);
        }
    }
}

