/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssessmentReportRequest extends AuditManagerRequest implements
        ToCopyableBuilder<CreateAssessmentReportRequest.Builder, CreateAssessmentReportRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAssessmentReportRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAssessmentReportRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(CreateAssessmentReportRequest::assessmentId))
            .setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()).build();

    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryStatement").getter(getter(CreateAssessmentReportRequest::queryStatement))
            .setter(setter(Builder::queryStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryStatement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ASSESSMENT_ID_FIELD, QUERY_STATEMENT_FIELD));

    private final String name;

    private final String description;

    private final String assessmentId;

    private final String queryStatement;

    private CreateAssessmentReportRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.assessmentId = builder.assessmentId;
        this.queryStatement = builder.queryStatement;
    }

    /**
     * <p>
     * The name of the new assessment report.
     * </p>
     * 
     * @return The name of the new assessment report.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the assessment report.
     * </p>
     * 
     * @return The description of the assessment report.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier for the assessment.
     * </p>
     * 
     * @return The identifier for the assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * A SQL statement that represents an evidence finder query.
     * </p>
     * <p>
     * Provide this parameter when you want to generate an assessment report from the results of an evidence finder
     * search query. When you use this parameter, Audit Manager generates a one-time report using only the evidence from
     * the query output. This report does not include any assessment evidence that was manually <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     * >added to a report using the console</a>, or <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html"
     * >associated with a report using the API</a>.
     * </p>
     * <p>
     * To use this parameter, the <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_EvidenceFinderEnablement.html#auditmanager-Type-EvidenceFinderEnablement-enablementStatus"
     * >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     * </p>
     * <p>
     * For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     * >Troubleshooting evidence finder issues</a> in the <i>Audit Manager User Guide.</i>
     * </p>
     * 
     * @return A SQL statement that represents an evidence finder query.</p>
     *         <p>
     *         Provide this parameter when you want to generate an assessment report from the results of an evidence
     *         finder search query. When you use this parameter, Audit Manager generates a one-time report using only
     *         the evidence from the query output. This report does not include any assessment evidence that was
     *         manually <a href=
     *         "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     *         >added to a report using the console</a>, or <a href=
     *         "https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html"
     *         >associated with a report using the API</a>.
     *         </p>
     *         <p>
     *         To use this parameter, the <a href=
     *         "https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_EvidenceFinderEnablement.html#auditmanager-Type-EvidenceFinderEnablement-enablementStatus"
     *         >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     *         </p>
     *         <p>
     *         For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     *         "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     *         >Troubleshooting evidence finder issues</a> in the <i>Audit Manager User Guide.</i>
     */
    public final String queryStatement() {
        return queryStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentReportRequest)) {
            return false;
        }
        CreateAssessmentReportRequest other = (CreateAssessmentReportRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(assessmentId(), other.assessmentId())
                && Objects.equals(queryStatement(), other.queryStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssessmentReportRequest").add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AssessmentId", assessmentId()).add("QueryStatement", queryStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "queryStatement":
            return Optional.ofNullable(clazz.cast(queryStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentReportRequest, T> g) {
        return obj -> g.apply((CreateAssessmentReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAssessmentReportRequest> {
        /**
         * <p>
         * The name of the new assessment report.
         * </p>
         * 
         * @param name
         *        The name of the new assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the assessment report.
         * </p>
         * 
         * @param description
         *        The description of the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier for the assessment.
         * </p>
         * 
         * @param assessmentId
         *        The identifier for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * A SQL statement that represents an evidence finder query.
         * </p>
         * <p>
         * Provide this parameter when you want to generate an assessment report from the results of an evidence finder
         * search query. When you use this parameter, Audit Manager generates a one-time report using only the evidence
         * from the query output. This report does not include any assessment evidence that was manually <a href=
         * "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
         * >added to a report using the console</a>, or <a href=
         * "https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html"
         * >associated with a report using the API</a>.
         * </p>
         * <p>
         * To use this parameter, the <a href=
         * "https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_EvidenceFinderEnablement.html#auditmanager-Type-EvidenceFinderEnablement-enablementStatus"
         * >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
         * </p>
         * <p>
         * For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
         * "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
         * >Troubleshooting evidence finder issues</a> in the <i>Audit Manager User Guide.</i>
         * </p>
         * 
         * @param queryStatement
         *        A SQL statement that represents an evidence finder query.</p>
         *        <p>
         *        Provide this parameter when you want to generate an assessment report from the results of an evidence
         *        finder search query. When you use this parameter, Audit Manager generates a one-time report using only
         *        the evidence from the query output. This report does not include any assessment evidence that was
         *        manually <a href=
         *        "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
         *        >added to a report using the console</a>, or <a href=
         *        "https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html"
         *        >associated with a report using the API</a>.
         *        </p>
         *        <p>
         *        To use this parameter, the <a href=
         *        "https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_EvidenceFinderEnablement.html#auditmanager-Type-EvidenceFinderEnablement-enablementStatus"
         *        >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
         *        </p>
         *        <p>
         *        For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
         *        "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
         *        >Troubleshooting evidence finder issues</a> in the <i>Audit Manager User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStatement(String queryStatement);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String assessmentId;

        private String queryStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentReportRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            assessmentId(model.assessmentId);
            queryStatement(model.queryStatement);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getQueryStatement() {
            return queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentReportRequest build() {
            return new CreateAssessmentReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
