/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.auditmanager.internal.AuditManagerServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.auditmanager.model.AccessDeniedException;
import software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerException;
import software.amazon.awssdk.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.CreateControlRequest;
import software.amazon.awssdk.services.auditmanager.model.CreateControlResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest;
import software.amazon.awssdk.services.auditmanager.model.DeleteControlResponse;
import software.amazon.awssdk.services.auditmanager.model.DeregisterAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.DeregisterAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAccountStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAccountStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetControlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetControlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceResponse;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetInsightsResponse;
import software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeRequest;
import software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse;
import software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetSettingsResponse;
import software.amazon.awssdk.services.auditmanager.model.InternalServerException;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse;
import software.amazon.awssdk.services.auditmanager.model.ListControlsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest;
import software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse;
import software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse;
import software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.RegisterAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.auditmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.auditmanager.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.ThrottlingException;
import software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.auditmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateControlResponse;
import software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.auditmanager.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest;
import software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse;
import software.amazon.awssdk.services.auditmanager.model.ValidationException;
import software.amazon.awssdk.services.auditmanager.transform.AssociateAssessmentReportEvidenceFolderRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.BatchAssociateAssessmentReportEvidenceRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.BatchCreateDelegationByAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.BatchDeleteDelegationByAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.BatchDisassociateAssessmentReportEvidenceRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.BatchImportEvidenceToAssessmentControlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.CreateAssessmentFrameworkRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.CreateAssessmentReportRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.CreateAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.CreateControlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.DeleteAssessmentFrameworkRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.DeleteAssessmentFrameworkShareRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.DeleteAssessmentReportRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.DeleteAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.DeleteControlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.DeregisterAccountRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.DeregisterOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.DisassociateAssessmentReportEvidenceFolderRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetAssessmentFrameworkRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetAssessmentReportUrlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetChangeLogsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetControlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetDelegationsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetEvidenceByEvidenceFolderRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetEvidenceFileUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetEvidenceFolderRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetEvidenceFoldersByAssessmentControlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetEvidenceFoldersByAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetEvidenceRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetInsightsByAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetInsightsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetServicesInScopeRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.GetSettingsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListAssessmentControlInsightsByControlDomainRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListAssessmentFrameworkShareRequestsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListAssessmentFrameworksRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListAssessmentReportsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListControlDomainInsightsByAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListControlDomainInsightsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListControlInsightsByControlDomainRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListControlsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListKeywordsForDataSourceRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListNotificationsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.RegisterAccountRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.RegisterOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.StartAssessmentFrameworkShareRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UpdateAssessmentControlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UpdateAssessmentControlSetStatusRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UpdateAssessmentFrameworkRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UpdateAssessmentFrameworkShareRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UpdateAssessmentRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UpdateAssessmentStatusRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UpdateControlRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.UpdateSettingsRequestMarshaller;
import software.amazon.awssdk.services.auditmanager.transform.ValidateAssessmentReportIntegrityRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link AuditManagerAsyncClient}.
 *
 * @see AuditManagerAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAuditManagerAsyncClient implements AuditManagerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuditManagerAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAuditManagerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates an evidence folder to an assessment report in an Audit Manager assessment.
     * </p>
     *
     * @param associateAssessmentReportEvidenceFolderRequest
     * @return A Java Future containing the result of the AssociateAssessmentReportEvidenceFolder operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.AssociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/AssociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAssessmentReportEvidenceFolderResponse> associateAssessmentReportEvidenceFolder(
            AssociateAssessmentReportEvidenceFolderRequest associateAssessmentReportEvidenceFolderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAssessmentReportEvidenceFolderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateAssessmentReportEvidenceFolderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAssessmentReportEvidenceFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateAssessmentReportEvidenceFolderResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateAssessmentReportEvidenceFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateAssessmentReportEvidenceFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAssessmentReportEvidenceFolderRequest, AssociateAssessmentReportEvidenceFolderResponse>()
                            .withOperationName("AssociateAssessmentReportEvidenceFolder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateAssessmentReportEvidenceFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateAssessmentReportEvidenceFolderRequest));
            CompletableFuture<AssociateAssessmentReportEvidenceFolderResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     * </p>
     *
     * @param batchAssociateAssessmentReportEvidenceRequest
     * @return A Java Future containing the result of the BatchAssociateAssessmentReportEvidence operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchAssociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchAssociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchAssociateAssessmentReportEvidenceResponse> batchAssociateAssessmentReportEvidence(
            BatchAssociateAssessmentReportEvidenceRequest batchAssociateAssessmentReportEvidenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchAssociateAssessmentReportEvidenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchAssociateAssessmentReportEvidenceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateAssessmentReportEvidence");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchAssociateAssessmentReportEvidenceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchAssociateAssessmentReportEvidenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchAssociateAssessmentReportEvidenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateAssessmentReportEvidenceRequest, BatchAssociateAssessmentReportEvidenceResponse>()
                            .withOperationName("BatchAssociateAssessmentReportEvidence").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchAssociateAssessmentReportEvidenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchAssociateAssessmentReportEvidenceRequest));
            CompletableFuture<BatchAssociateAssessmentReportEvidenceResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a batch of delegations for an assessment in Audit Manager.
     * </p>
     *
     * @param batchCreateDelegationByAssessmentRequest
     * @return A Java Future containing the result of the BatchCreateDelegationByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchCreateDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchCreateDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchCreateDelegationByAssessmentResponse> batchCreateDelegationByAssessment(
            BatchCreateDelegationByAssessmentRequest batchCreateDelegationByAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateDelegationByAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateDelegationByAssessmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateDelegationByAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchCreateDelegationByAssessmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchCreateDelegationByAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchCreateDelegationByAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchCreateDelegationByAssessmentRequest, BatchCreateDelegationByAssessmentResponse>()
                            .withOperationName("BatchCreateDelegationByAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchCreateDelegationByAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchCreateDelegationByAssessmentRequest));
            CompletableFuture<BatchCreateDelegationByAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a batch of delegations for an assessment in Audit Manager.
     * </p>
     *
     * @param batchDeleteDelegationByAssessmentRequest
     * @return A Java Future containing the result of the BatchDeleteDelegationByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchDeleteDelegationByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDeleteDelegationByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteDelegationByAssessmentResponse> batchDeleteDelegationByAssessment(
            BatchDeleteDelegationByAssessmentRequest batchDeleteDelegationByAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteDelegationByAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteDelegationByAssessmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteDelegationByAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteDelegationByAssessmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchDeleteDelegationByAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteDelegationByAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteDelegationByAssessmentRequest, BatchDeleteDelegationByAssessmentResponse>()
                            .withOperationName("BatchDeleteDelegationByAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteDelegationByAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteDelegationByAssessmentRequest));
            CompletableFuture<BatchDeleteDelegationByAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a list of evidence from an assessment report in Audit Manager.
     * </p>
     *
     * @param batchDisassociateAssessmentReportEvidenceRequest
     * @return A Java Future containing the result of the BatchDisassociateAssessmentReportEvidence operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchDisassociateAssessmentReportEvidence
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchDisassociateAssessmentReportEvidence"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDisassociateAssessmentReportEvidenceResponse> batchDisassociateAssessmentReportEvidence(
            BatchDisassociateAssessmentReportEvidenceRequest batchDisassociateAssessmentReportEvidenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchDisassociateAssessmentReportEvidenceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateAssessmentReportEvidenceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDisassociateAssessmentReportEvidence");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDisassociateAssessmentReportEvidenceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchDisassociateAssessmentReportEvidenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDisassociateAssessmentReportEvidenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateAssessmentReportEvidenceRequest, BatchDisassociateAssessmentReportEvidenceResponse>()
                            .withOperationName("BatchDisassociateAssessmentReportEvidence")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDisassociateAssessmentReportEvidenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDisassociateAssessmentReportEvidenceRequest));
            CompletableFuture<BatchDisassociateAssessmentReportEvidenceResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more pieces of evidence to a control in an Audit Manager assessment.
     * </p>
     * <p>
     * You can import manual evidence from any S3 bucket by specifying the S3 URI of the object. You can also upload a
     * file from your browser, or enter plain text in response to a risk assessment question.
     * </p>
     * <p>
     * The following restrictions apply to this action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>manualEvidence</code> can be only one of the following: <code>evidenceFileName</code>,
     * <code>s3ResourcePath</code>, or <code>textResponse</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum size of an individual evidence file: 100 MB
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of daily manual evidence uploads per control: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Supported file formats: See <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Audit Manager service restrictions, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and restrictions for
     * Audit Manager</a>.
     * </p>
     *
     * @param batchImportEvidenceToAssessmentControlRequest
     * @return A Java Future containing the result of the BatchImportEvidenceToAssessmentControl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.BatchImportEvidenceToAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/BatchImportEvidenceToAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchImportEvidenceToAssessmentControlResponse> batchImportEvidenceToAssessmentControl(
            BatchImportEvidenceToAssessmentControlRequest batchImportEvidenceToAssessmentControlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchImportEvidenceToAssessmentControlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchImportEvidenceToAssessmentControlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchImportEvidenceToAssessmentControl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchImportEvidenceToAssessmentControlResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchImportEvidenceToAssessmentControlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchImportEvidenceToAssessmentControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchImportEvidenceToAssessmentControlRequest, BatchImportEvidenceToAssessmentControlResponse>()
                            .withOperationName("BatchImportEvidenceToAssessmentControl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchImportEvidenceToAssessmentControlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchImportEvidenceToAssessmentControlRequest));
            CompletableFuture<BatchImportEvidenceToAssessmentControlResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an assessment in Audit Manager.
     * </p>
     *
     * @param createAssessmentRequest
     * @return A Java Future containing the result of the CreateAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssessmentResponse> createAssessment(CreateAssessmentRequest createAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssessmentRequest, CreateAssessmentResponse>()
                            .withOperationName("CreateAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAssessmentRequest));
            CompletableFuture<CreateAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom framework in Audit Manager.
     * </p>
     *
     * @param createAssessmentFrameworkRequest
     * @return A Java Future containing the result of the CreateAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssessmentFrameworkResponse> createAssessmentFramework(
            CreateAssessmentFrameworkRequest createAssessmentFrameworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssessmentFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssessmentFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssessmentFramework");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssessmentFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAssessmentFrameworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAssessmentFrameworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssessmentFrameworkRequest, CreateAssessmentFrameworkResponse>()
                            .withOperationName("CreateAssessmentFramework").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAssessmentFrameworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAssessmentFrameworkRequest));
            CompletableFuture<CreateAssessmentFrameworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an assessment report for the specified assessment.
     * </p>
     *
     * @param createAssessmentReportRequest
     * @return A Java Future containing the result of the CreateAssessmentReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssessmentReportResponse> createAssessmentReport(
            CreateAssessmentReportRequest createAssessmentReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssessmentReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssessmentReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssessmentReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssessmentReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAssessmentReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAssessmentReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssessmentReportRequest, CreateAssessmentReportResponse>()
                            .withOperationName("CreateAssessmentReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAssessmentReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAssessmentReportRequest));
            CompletableFuture<CreateAssessmentReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new custom control in Audit Manager.
     * </p>
     *
     * @param createControlRequest
     * @return A Java Future containing the result of the CreateControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.CreateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateControl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateControlResponse> createControl(CreateControlRequest createControlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createControlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateControl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateControlResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateControlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateControlRequest, CreateControlResponse>()
                            .withOperationName("CreateControl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateControlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createControlRequest));
            CompletableFuture<CreateControlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an assessment in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentRequest
     * @return A Java Future containing the result of the DeleteAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssessmentResponse> deleteAssessment(DeleteAssessmentRequest deleteAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssessmentRequest, DeleteAssessmentResponse>()
                            .withOperationName("DeleteAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAssessmentRequest));
            CompletableFuture<DeleteAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom framework in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentFrameworkRequest
     * @return A Java Future containing the result of the DeleteAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssessmentFrameworkResponse> deleteAssessmentFramework(
            DeleteAssessmentFrameworkRequest deleteAssessmentFrameworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssessmentFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssessmentFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssessmentFramework");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssessmentFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssessmentFrameworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssessmentFrameworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssessmentFrameworkRequest, DeleteAssessmentFrameworkResponse>()
                            .withOperationName("DeleteAssessmentFramework").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssessmentFrameworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAssessmentFrameworkRequest));
            CompletableFuture<DeleteAssessmentFrameworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a share request for a custom framework in Audit Manager.
     * </p>
     *
     * @param deleteAssessmentFrameworkShareRequest
     * @return A Java Future containing the result of the DeleteAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssessmentFrameworkShareResponse> deleteAssessmentFrameworkShare(
            DeleteAssessmentFrameworkShareRequest deleteAssessmentFrameworkShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssessmentFrameworkShareRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAssessmentFrameworkShareRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssessmentFrameworkShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssessmentFrameworkShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssessmentFrameworkShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssessmentFrameworkShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssessmentFrameworkShareRequest, DeleteAssessmentFrameworkShareResponse>()
                            .withOperationName("DeleteAssessmentFrameworkShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssessmentFrameworkShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAssessmentFrameworkShareRequest));
            CompletableFuture<DeleteAssessmentFrameworkShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an assessment report in Audit Manager.
     * </p>
     * <p>
     * When you run the <code>DeleteAssessmentReport</code> operation, Audit Manager attempts to delete the following
     * data:
     * </p>
     * <ol>
     * <li>
     * <p>
     * The specified assessment report that’s stored in your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * The associated metadata that’s stored in Audit Manager
     * </p>
     * </li>
     * </ol>
     * <p>
     * If Audit Manager can’t access the assessment report in your S3 bucket, the report isn’t deleted. In this event,
     * the <code>DeleteAssessmentReport</code> operation doesn’t fail. Instead, it proceeds to delete the associated
     * metadata only. You must then delete the assessment report from the S3 bucket yourself.
     * </p>
     * <p>
     * This scenario happens when Audit Manager receives a <code>403 (Forbidden)</code> or <code>404 (Not Found)</code>
     * error from Amazon S3. To avoid this, make sure that your S3 bucket is available, and that you configured the
     * correct permissions for Audit Manager to delete resources in your S3 bucket. For an example permissions policy
     * that you can use, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/security_iam_id-based-policy-examples.html#full-administrator-access-assessment-report-destination"
     * >Assessment report destination permissions</a> in the <i>Audit Manager User Guide</i>. For information about the
     * issues that could cause a <code>403 (Forbidden)</code> or <code>404 (Not Found</code>) error from Amazon S3, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error
     * Codes</a> in the <i>Amazon Simple Storage Service API Reference</i>.
     * </p>
     *
     * @param deleteAssessmentReportRequest
     * @return A Java Future containing the result of the DeleteAssessmentReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteAssessmentReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteAssessmentReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssessmentReportResponse> deleteAssessmentReport(
            DeleteAssessmentReportRequest deleteAssessmentReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssessmentReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssessmentReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssessmentReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssessmentReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssessmentReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAssessmentReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssessmentReportRequest, DeleteAssessmentReportResponse>()
                            .withOperationName("DeleteAssessmentReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssessmentReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAssessmentReportRequest));
            CompletableFuture<DeleteAssessmentReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom control in Audit Manager.
     * </p>
     * <important>
     * <p>
     * When you invoke this operation, the custom control is deleted from any frameworks or assessments that it’s
     * currently part of. As a result, Audit Manager will stop collecting evidence for that custom control in all of
     * your assessments. This includes assessments that you previously created before you deleted the custom control.
     * </p>
     * </important>
     *
     * @param deleteControlRequest
     * @return A Java Future containing the result of the DeleteControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeleteControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeleteControl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteControlResponse> deleteControl(DeleteControlRequest deleteControlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteControlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteControl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteControlResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteControlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteControlRequest, DeleteControlResponse>()
                            .withOperationName("DeleteControl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteControlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteControlRequest));
            CompletableFuture<DeleteControlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters an account in Audit Manager.
     * </p>
     * <note>
     * <p>
     * Before you deregister, you can use the <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html">UpdateSettings</a>
     * API operation to set your preferred data retention policy. By default, Audit Manager retains your data. If you
     * want to delete your data, you can use the <code>DeregistrationPolicy</code> attribute to request the deletion of
     * your data.
     * </p>
     * <p>
     * For more information about data retention, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/data-protection.html">Data Protection</a> in the
     * <i>Audit Manager User Guide</i>.
     * </p>
     * </note>
     *
     * @param deregisterAccountRequest
     * @return A Java Future containing the result of the DeregisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeregisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterAccountResponse> deregisterAccount(DeregisterAccountRequest deregisterAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterAccountRequest, DeregisterAccountResponse>()
                            .withOperationName("DeregisterAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterAccountRequest));
            CompletableFuture<DeregisterAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
     * </p>
     * <p>
     * When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the
     * evidence that you previously collected under that account. This is also the case when you deregister a delegated
     * administrator from Organizations. However, Audit Manager stops collecting and attaching evidence to that
     * delegated administrator account moving forward.
     * </p>
     * <important>
     * <p>
     * Keep in mind the following cleanup task if you use evidence finder:
     * </p>
     * <p>
     * Before you use your management account to remove a delegated administrator, make sure that the current delegated
     * administrator account signs in to Audit Manager and disables evidence finder first. Disabling evidence finder
     * automatically deletes the event data store that was created in their account when they enabled evidence finder.
     * If this task isn’t completed, the event data store remains in their account. In this case, we recommend that the
     * original delegated administrator goes to CloudTrail Lake and manually <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-eds-disable-termination.html">deletes the
     * event data store</a>.
     * </p>
     * <p>
     * This cleanup task is necessary to ensure that you don't end up with multiple event data stores. Audit Manager
     * ignores an unused event data store after you remove or change a delegated administrator account. However, the
     * unused event data store continues to incur storage costs from CloudTrail Lake if you don't delete it.
     * </p>
     * </important>
     * <p>
     * When you deregister a delegated administrator account for Audit Manager, the data for that account isn’t deleted.
     * If you want to delete resource data for a delegated administrator account, you must perform that task separately
     * before you deregister the account. Either, you can do this in the Audit Manager console. Or, you can use one of
     * the delete API operations that are provided by Audit Manager.
     * </p>
     * <p>
     * To delete your Audit Manager resource data, see the following instructions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html">DeleteAssessment
     * </a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html">Deleting an
     * assessment</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html">
     * DeleteAssessmentFramework</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html">Deleting a custom
     * framework</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html">
     * DeleteAssessmentFrameworkShare</a> (see also: <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html"
     * >Deleting a share request</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html">
     * DeleteAssessmentReport</a> (see also: <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps"
     * >Deleting an assessment report</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html">DeleteControl</a>
     * (see also: <a href="https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html">Deleting a
     * custom control</a> in the <i>Audit Manager User Guide</i>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * At this time, Audit Manager doesn't provide an option to delete evidence for a specific delegated administrator.
     * Instead, when your management account deregisters Audit Manager, we perform a cleanup for the current delegated
     * administrator account at the time of deregistration.
     * </p>
     *
     * @param deregisterOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the DeregisterOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DeregisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DeregisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterOrganizationAdminAccountResponse> deregisterOrganizationAdminAccount(
            DeregisterOrganizationAdminAccountRequest deregisterOrganizationAdminAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterOrganizationAdminAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterOrganizationAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterOrganizationAdminAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeregisterOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterOrganizationAdminAccountRequest, DeregisterOrganizationAdminAccountResponse>()
                            .withOperationName("DeregisterOrganizationAdminAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterOrganizationAdminAccountRequest));
            CompletableFuture<DeregisterOrganizationAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     * </p>
     *
     * @param disassociateAssessmentReportEvidenceFolderRequest
     * @return A Java Future containing the result of the DisassociateAssessmentReportEvidenceFolder operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.DisassociateAssessmentReportEvidenceFolder
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DisassociateAssessmentReportEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateAssessmentReportEvidenceFolderResponse> disassociateAssessmentReportEvidenceFolder(
            DisassociateAssessmentReportEvidenceFolderRequest disassociateAssessmentReportEvidenceFolderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                disassociateAssessmentReportEvidenceFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateAssessmentReportEvidenceFolderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAssessmentReportEvidenceFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateAssessmentReportEvidenceFolderResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateAssessmentReportEvidenceFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateAssessmentReportEvidenceFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateAssessmentReportEvidenceFolderRequest, DisassociateAssessmentReportEvidenceFolderResponse>()
                            .withOperationName("DisassociateAssessmentReportEvidenceFolder")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateAssessmentReportEvidenceFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateAssessmentReportEvidenceFolderRequest));
            CompletableFuture<DisassociateAssessmentReportEvidenceFolderResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the registration status of an account in Audit Manager.
     * </p>
     *
     * @param getAccountStatusRequest
     * @return A Java Future containing the result of the GetAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAccountStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccountStatusResponse> getAccountStatus(GetAccountStatusRequest getAccountStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAccountStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAccountStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAccountStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccountStatusRequest, GetAccountStatusResponse>()
                            .withOperationName("GetAccountStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccountStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccountStatusRequest));
            CompletableFuture<GetAccountStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified assessment.
     * </p>
     *
     * @param getAssessmentRequest
     * @return A Java Future containing the result of the GetAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssessmentResponse> getAssessment(GetAssessmentRequest getAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssessmentRequest, GetAssessmentResponse>()
                            .withOperationName("GetAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAssessmentRequest));
            CompletableFuture<GetAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified framework.
     * </p>
     *
     * @param getAssessmentFrameworkRequest
     * @return A Java Future containing the result of the GetAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssessmentFrameworkResponse> getAssessmentFramework(
            GetAssessmentFrameworkRequest getAssessmentFrameworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssessmentFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssessmentFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssessmentFramework");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssessmentFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAssessmentFrameworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAssessmentFrameworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssessmentFrameworkRequest, GetAssessmentFrameworkResponse>()
                            .withOperationName("GetAssessmentFramework").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAssessmentFrameworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAssessmentFrameworkRequest));
            CompletableFuture<GetAssessmentFrameworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the URL of an assessment report in Audit Manager.
     * </p>
     *
     * @param getAssessmentReportUrlRequest
     * @return A Java Future containing the result of the GetAssessmentReportUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetAssessmentReportUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetAssessmentReportUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssessmentReportUrlResponse> getAssessmentReportUrl(
            GetAssessmentReportUrlRequest getAssessmentReportUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssessmentReportUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssessmentReportUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssessmentReportUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssessmentReportUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAssessmentReportUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAssessmentReportUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssessmentReportUrlRequest, GetAssessmentReportUrlResponse>()
                            .withOperationName("GetAssessmentReportUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAssessmentReportUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAssessmentReportUrlRequest));
            CompletableFuture<GetAssessmentReportUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of changelogs from Audit Manager.
     * </p>
     *
     * @param getChangeLogsRequest
     * @return A Java Future containing the result of the GetChangeLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetChangeLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetChangeLogs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetChangeLogsResponse> getChangeLogs(GetChangeLogsRequest getChangeLogsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChangeLogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChangeLogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChangeLogs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetChangeLogsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetChangeLogsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetChangeLogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetChangeLogsRequest, GetChangeLogsResponse>()
                            .withOperationName("GetChangeLogs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetChangeLogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getChangeLogsRequest));
            CompletableFuture<GetChangeLogsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified control.
     * </p>
     *
     * @param getControlRequest
     * @return A Java Future containing the result of the GetControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetControl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetControlResponse> getControl(GetControlRequest getControlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getControlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetControl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetControlResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetControlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetControlRequest, GetControlResponse>().withOperationName("GetControl")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetControlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getControlRequest));
            CompletableFuture<GetControlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of delegations from an audit owner to a delegate.
     * </p>
     *
     * @param getDelegationsRequest
     * @return A Java Future containing the result of the GetDelegations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetDelegations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetDelegations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDelegationsResponse> getDelegations(GetDelegationsRequest getDelegationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDelegationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDelegationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDelegations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDelegationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDelegationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDelegationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDelegationsRequest, GetDelegationsResponse>()
                            .withOperationName("GetDelegations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDelegationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDelegationsRequest));
            CompletableFuture<GetDelegationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified evidence item.
     * </p>
     *
     * @param getEvidenceRequest
     * @return A Java Future containing the result of the GetEvidence operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidence
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidence" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEvidenceResponse> getEvidence(GetEvidenceRequest getEvidenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEvidenceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEvidenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEvidence");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEvidenceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEvidenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEvidenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEvidenceRequest, GetEvidenceResponse>()
                            .withOperationName("GetEvidence").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEvidenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEvidenceRequest));
            CompletableFuture<GetEvidenceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all evidence from a specified evidence folder in Audit Manager.
     * </p>
     *
     * @param getEvidenceByEvidenceFolderRequest
     * @return A Java Future containing the result of the GetEvidenceByEvidenceFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceByEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceByEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEvidenceByEvidenceFolderResponse> getEvidenceByEvidenceFolder(
            GetEvidenceByEvidenceFolderRequest getEvidenceByEvidenceFolderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEvidenceByEvidenceFolderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEvidenceByEvidenceFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEvidenceByEvidenceFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEvidenceByEvidenceFolderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEvidenceByEvidenceFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEvidenceByEvidenceFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEvidenceByEvidenceFolderRequest, GetEvidenceByEvidenceFolderResponse>()
                            .withOperationName("GetEvidenceByEvidenceFolder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEvidenceByEvidenceFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEvidenceByEvidenceFolderRequest));
            CompletableFuture<GetEvidenceByEvidenceFolderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a presigned Amazon S3 URL that can be used to upload a file as manual evidence. For instructions on how
     * to use this operation, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#how-to-upload-manual-evidence-files"
     * >Upload a file from your browser </a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * <p>
     * The following restrictions apply to this operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum size of an individual evidence file: 100 MB
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of daily manual evidence uploads per control: 100
     * </p>
     * </li>
     * <li>
     * <p>
     * Supported file formats: See <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Audit Manager service restrictions, see <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and restrictions for
     * Audit Manager</a>.
     * </p>
     *
     * @param getEvidenceFileUploadUrlRequest
     * @return A Java Future containing the result of the GetEvidenceFileUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFileUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFileUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEvidenceFileUploadUrlResponse> getEvidenceFileUploadUrl(
            GetEvidenceFileUploadUrlRequest getEvidenceFileUploadUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEvidenceFileUploadUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEvidenceFileUploadUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEvidenceFileUploadUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEvidenceFileUploadUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEvidenceFileUploadUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEvidenceFileUploadUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEvidenceFileUploadUrlRequest, GetEvidenceFileUploadUrlResponse>()
                            .withOperationName("GetEvidenceFileUploadUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEvidenceFileUploadUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEvidenceFileUploadUrlRequest));
            CompletableFuture<GetEvidenceFileUploadUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an evidence folder from a specified assessment in Audit Manager.
     * </p>
     *
     * @param getEvidenceFolderRequest
     * @return A Java Future containing the result of the GetEvidenceFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFolder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEvidenceFolderResponse> getEvidenceFolder(GetEvidenceFolderRequest getEvidenceFolderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEvidenceFolderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEvidenceFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEvidenceFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEvidenceFolderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEvidenceFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEvidenceFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEvidenceFolderRequest, GetEvidenceFolderResponse>()
                            .withOperationName("GetEvidenceFolder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEvidenceFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEvidenceFolderRequest));
            CompletableFuture<GetEvidenceFolderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the evidence folders from a specified assessment in Audit Manager.
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentRequest
     * @return A Java Future containing the result of the GetEvidenceFoldersByAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEvidenceFoldersByAssessmentResponse> getEvidenceFoldersByAssessment(
            GetEvidenceFoldersByAssessmentRequest getEvidenceFoldersByAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEvidenceFoldersByAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEvidenceFoldersByAssessmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEvidenceFoldersByAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEvidenceFoldersByAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEvidenceFoldersByAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEvidenceFoldersByAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEvidenceFoldersByAssessmentRequest, GetEvidenceFoldersByAssessmentResponse>()
                            .withOperationName("GetEvidenceFoldersByAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEvidenceFoldersByAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEvidenceFoldersByAssessmentRequest));
            CompletableFuture<GetEvidenceFoldersByAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of evidence folders that are associated with a specified control in an Audit Manager assessment.
     * </p>
     *
     * @param getEvidenceFoldersByAssessmentControlRequest
     * @return A Java Future containing the result of the GetEvidenceFoldersByAssessmentControl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetEvidenceFoldersByAssessmentControl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetEvidenceFoldersByAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEvidenceFoldersByAssessmentControlResponse> getEvidenceFoldersByAssessmentControl(
            GetEvidenceFoldersByAssessmentControlRequest getEvidenceFoldersByAssessmentControlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEvidenceFoldersByAssessmentControlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEvidenceFoldersByAssessmentControlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEvidenceFoldersByAssessmentControl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEvidenceFoldersByAssessmentControlResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetEvidenceFoldersByAssessmentControlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEvidenceFoldersByAssessmentControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEvidenceFoldersByAssessmentControlRequest, GetEvidenceFoldersByAssessmentControlResponse>()
                            .withOperationName("GetEvidenceFoldersByAssessmentControl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEvidenceFoldersByAssessmentControlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEvidenceFoldersByAssessmentControlRequest));
            CompletableFuture<GetEvidenceFoldersByAssessmentControlResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the latest analytics data for all your current active assessments.
     * </p>
     *
     * @param getInsightsRequest
     * @return A Java Future containing the result of the GetInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInsightsResponse> getInsights(GetInsightsRequest getInsightsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInsightsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInsightsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInsightsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetInsightsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInsightsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInsightsRequest, GetInsightsResponse>()
                            .withOperationName("GetInsights").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInsightsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInsightsRequest));
            CompletableFuture<GetInsightsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the latest analytics data for a specific active assessment.
     * </p>
     *
     * @param getInsightsByAssessmentRequest
     * @return A Java Future containing the result of the GetInsightsByAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetInsightsByAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInsightsByAssessmentResponse> getInsightsByAssessment(
            GetInsightsByAssessmentRequest getInsightsByAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInsightsByAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInsightsByAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInsightsByAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInsightsByAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInsightsByAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInsightsByAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInsightsByAssessmentRequest, GetInsightsByAssessmentResponse>()
                            .withOperationName("GetInsightsByAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInsightsByAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInsightsByAssessmentRequest));
            CompletableFuture<GetInsightsByAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the name of the delegated Amazon Web Services administrator account for a specified organization.
     * </p>
     *
     * @param getOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the GetOrganizationAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOrganizationAdminAccountResponse> getOrganizationAdminAccount(
            GetOrganizationAdminAccountRequest getOrganizationAdminAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOrganizationAdminAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOrganizationAdminAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOrganizationAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationAdminAccountRequest, GetOrganizationAdminAccountResponse>()
                            .withOperationName("GetOrganizationAdminAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOrganizationAdminAccountRequest));
            CompletableFuture<GetOrganizationAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of all of the Amazon Web Services that you can choose to include in your assessment. When you <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html">create an
     * assessment</a>, specify which of these services you want to include to narrow the assessment's <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Scope.html">scope</a>.
     * </p>
     *
     * @param getServicesInScopeRequest
     * @return A Java Future containing the result of the GetServicesInScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetServicesInScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetServicesInScope"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServicesInScopeResponse> getServicesInScope(GetServicesInScopeRequest getServicesInScopeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getServicesInScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServicesInScopeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServicesInScope");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetServicesInScopeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetServicesInScopeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetServicesInScopeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServicesInScopeRequest, GetServicesInScopeResponse>()
                            .withOperationName("GetServicesInScope").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetServicesInScopeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getServicesInScopeRequest));
            CompletableFuture<GetServicesInScopeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the settings for a specified Amazon Web Services account.
     * </p>
     *
     * @param getSettingsRequest
     * @return A Java Future containing the result of the GetSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.GetSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/GetSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSettingsResponse> getSettings(GetSettingsRequest getSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSettingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSettingsRequest, GetSettingsResponse>()
                            .withOperationName("GetSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSettingsRequest));
            CompletableFuture<GetSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified.
     * Moreover, the control must have collected evidence on the <code>lastUpdated</code> date of
     * <code>controlInsightsByAssessment</code>. If neither of these conditions are met, no data is listed for that
     * control.
     * </p>
     * </note>
     *
     * @param listAssessmentControlInsightsByControlDomainRequest
     * @return A Java Future containing the result of the ListAssessmentControlInsightsByControlDomain operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentControlInsightsByControlDomain
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssessmentControlInsightsByControlDomainResponse> listAssessmentControlInsightsByControlDomain(
            ListAssessmentControlInsightsByControlDomainRequest listAssessmentControlInsightsByControlDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listAssessmentControlInsightsByControlDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAssessmentControlInsightsByControlDomainRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssessmentControlInsightsByControlDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssessmentControlInsightsByControlDomainResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAssessmentControlInsightsByControlDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssessmentControlInsightsByControlDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssessmentControlInsightsByControlDomainRequest, ListAssessmentControlInsightsByControlDomainResponse>()
                            .withOperationName("ListAssessmentControlInsightsByControlDomain")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssessmentControlInsightsByControlDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAssessmentControlInsightsByControlDomainRequest));
            CompletableFuture<ListAssessmentControlInsightsByControlDomainResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     * </p>
     *
     * @param listAssessmentFrameworkShareRequestsRequest
     * @return A Java Future containing the result of the ListAssessmentFrameworkShareRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworkShareRequests
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworkShareRequests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssessmentFrameworkShareRequestsResponse> listAssessmentFrameworkShareRequests(
            ListAssessmentFrameworkShareRequestsRequest listAssessmentFrameworkShareRequestsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssessmentFrameworkShareRequestsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAssessmentFrameworkShareRequestsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssessmentFrameworkShareRequests");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssessmentFrameworkShareRequestsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAssessmentFrameworkShareRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssessmentFrameworkShareRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssessmentFrameworkShareRequestsRequest, ListAssessmentFrameworkShareRequestsResponse>()
                            .withOperationName("ListAssessmentFrameworkShareRequests").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssessmentFrameworkShareRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAssessmentFrameworkShareRequestsRequest));
            CompletableFuture<ListAssessmentFrameworkShareRequestsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     * </p>
     *
     * @param listAssessmentFrameworksRequest
     * @return A Java Future containing the result of the ListAssessmentFrameworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentFrameworks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssessmentFrameworksResponse> listAssessmentFrameworks(
            ListAssessmentFrameworksRequest listAssessmentFrameworksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssessmentFrameworksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssessmentFrameworksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssessmentFrameworks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssessmentFrameworksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssessmentFrameworksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssessmentFrameworksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssessmentFrameworksRequest, ListAssessmentFrameworksResponse>()
                            .withOperationName("ListAssessmentFrameworks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssessmentFrameworksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAssessmentFrameworksRequest));
            CompletableFuture<ListAssessmentFrameworksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of assessment reports created in Audit Manager.
     * </p>
     *
     * @param listAssessmentReportsRequest
     * @return A Java Future containing the result of the ListAssessmentReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessmentReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessmentReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssessmentReportsResponse> listAssessmentReports(
            ListAssessmentReportsRequest listAssessmentReportsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssessmentReportsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssessmentReportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssessmentReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssessmentReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssessmentReportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssessmentReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssessmentReportsRequest, ListAssessmentReportsResponse>()
                            .withOperationName("ListAssessmentReports").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssessmentReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAssessmentReportsRequest));
            CompletableFuture<ListAssessmentReportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of current and past assessments from Audit Manager.
     * </p>
     *
     * @param listAssessmentsRequest
     * @return A Java Future containing the result of the ListAssessments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListAssessments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssessmentsResponse> listAssessments(ListAssessmentsRequest listAssessmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssessmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssessmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssessments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssessmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssessmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAssessmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssessmentsRequest, ListAssessmentsResponse>()
                            .withOperationName("ListAssessments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssessmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAssessmentsRequest));
            CompletableFuture<ListAssessmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the latest analytics data for control domains across all of your active assessments.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that control domain.
     * </p>
     * </note>
     *
     * @param listControlDomainInsightsRequest
     * @return A Java Future containing the result of the ListControlDomainInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsights"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListControlDomainInsightsResponse> listControlDomainInsights(
            ListControlDomainInsightsRequest listControlDomainInsightsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listControlDomainInsightsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listControlDomainInsightsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListControlDomainInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListControlDomainInsightsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListControlDomainInsightsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListControlDomainInsightsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListControlDomainInsightsRequest, ListControlDomainInsightsResponse>()
                            .withOperationName("ListControlDomainInsights").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListControlDomainInsightsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listControlDomainInsightsRequest));
            CompletableFuture<ListControlDomainInsightsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists analytics data for control domains within a specified active assessment.
     * </p>
     * <note>
     * <p>
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the
     * <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is
     * listed for that domain.
     * </p>
     * </note>
     *
     * @param listControlDomainInsightsByAssessmentRequest
     * @return A Java Future containing the result of the ListControlDomainInsightsByAssessment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlDomainInsightsByAssessment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlDomainInsightsByAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListControlDomainInsightsByAssessmentResponse> listControlDomainInsightsByAssessment(
            ListControlDomainInsightsByAssessmentRequest listControlDomainInsightsByAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listControlDomainInsightsByAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listControlDomainInsightsByAssessmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListControlDomainInsightsByAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListControlDomainInsightsByAssessmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListControlDomainInsightsByAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListControlDomainInsightsByAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListControlDomainInsightsByAssessmentRequest, ListControlDomainInsightsByAssessmentResponse>()
                            .withOperationName("ListControlDomainInsightsByAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListControlDomainInsightsByAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listControlDomainInsightsByAssessmentRequest));
            CompletableFuture<ListControlDomainInsightsByAssessmentResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     * </p>
     * <note>
     * <p>
     * Control insights are listed only if the control belongs to the control domain that was specified and the control
     * collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsMetadata</code>. If neither of
     * these conditions are met, no data is listed for that control.
     * </p>
     * </note>
     *
     * @param listControlInsightsByControlDomainRequest
     * @return A Java Future containing the result of the ListControlInsightsByControlDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControlInsightsByControlDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControlInsightsByControlDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListControlInsightsByControlDomainResponse> listControlInsightsByControlDomain(
            ListControlInsightsByControlDomainRequest listControlInsightsByControlDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listControlInsightsByControlDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listControlInsightsByControlDomainRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListControlInsightsByControlDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListControlInsightsByControlDomainResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListControlInsightsByControlDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListControlInsightsByControlDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListControlInsightsByControlDomainRequest, ListControlInsightsByControlDomainResponse>()
                            .withOperationName("ListControlInsightsByControlDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListControlInsightsByControlDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listControlInsightsByControlDomainRequest));
            CompletableFuture<ListControlInsightsByControlDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of controls from Audit Manager.
     * </p>
     *
     * @param listControlsRequest
     * @return A Java Future containing the result of the ListControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListControls" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListControlsResponse> listControls(ListControlsRequest listControlsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listControlsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listControlsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListControls");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListControlsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListControlsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListControlsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListControlsRequest, ListControlsResponse>()
                            .withOperationName("ListControls").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListControlsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listControlsRequest));
            CompletableFuture<ListControlsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     * </p>
     *
     * @param listKeywordsForDataSourceRequest
     * @return A Java Future containing the result of the ListKeywordsForDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListKeywordsForDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListKeywordsForDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListKeywordsForDataSourceResponse> listKeywordsForDataSource(
            ListKeywordsForDataSourceRequest listKeywordsForDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listKeywordsForDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listKeywordsForDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListKeywordsForDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListKeywordsForDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListKeywordsForDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListKeywordsForDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListKeywordsForDataSourceRequest, ListKeywordsForDataSourceResponse>()
                            .withOperationName("ListKeywordsForDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListKeywordsForDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listKeywordsForDataSourceRequest));
            CompletableFuture<ListKeywordsForDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all Audit Manager notifications.
     * </p>
     *
     * @param listNotificationsRequest
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNotificationsResponse> listNotifications(ListNotificationsRequest listNotificationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNotificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNotificationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNotificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListNotificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNotificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNotificationsRequest, ListNotificationsResponse>()
                            .withOperationName("ListNotifications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListNotificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listNotificationsRequest));
            CompletableFuture<ListNotificationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource in Audit Manager.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables Audit Manager for the specified Amazon Web Services account.
     * </p>
     *
     * @param registerAccountRequest
     * @return A Java Future containing the result of the RegisterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.RegisterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterAccountResponse> registerAccount(RegisterAccountRequest registerAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterAccountRequest, RegisterAccountResponse>()
                            .withOperationName("RegisterAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerAccountRequest));
            CompletableFuture<RegisterAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
     * </p>
     *
     * @param registerOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the RegisterOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.RegisterOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/RegisterOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterOrganizationAdminAccountResponse> registerOrganizationAdminAccount(
            RegisterOrganizationAdminAccountRequest registerOrganizationAdminAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerOrganizationAdminAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterOrganizationAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterOrganizationAdminAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RegisterOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterOrganizationAdminAccountRequest, RegisterOrganizationAdminAccountResponse>()
                            .withOperationName("RegisterOrganizationAdminAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerOrganizationAdminAccountRequest));
            CompletableFuture<RegisterOrganizationAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a share request for a custom framework in Audit Manager.
     * </p>
     * <p>
     * The share request specifies a recipient and notifies them that a custom framework is available. Recipients have
     * 120 days to accept or decline the request. If no action is taken, the share request expires.
     * </p>
     * <p>
     * When you create a share request, Audit Manager stores a snapshot of your custom framework in the US East (N.
     * Virginia) Amazon Web Services Region. Audit Manager also stores a backup of the same snapshot in the US West
     * (Oregon) Amazon Web Services Region.
     * </p>
     * <p>
     * Audit Manager deletes the snapshot and the backup snapshot when one of the following events occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sender revokes the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient declines the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The recipient encounters an error and doesn't successfully accept the share request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The share request expires before the recipient responds to the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a sender <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/framework-sharing.html#framework-sharing-resend"
     * >resends a share request</a>, the snapshot is replaced with an updated version that corresponds with the latest
     * version of the custom framework.
     * </p>
     * <p>
     * When a recipient accepts a share request, the snapshot is replicated into their Amazon Web Services account under
     * the Amazon Web Services Region that was specified in the share request.
     * </p>
     * <important>
     * <p>
     * When you invoke the <code>StartAssessmentFrameworkShare</code> API, you are about to share a custom framework
     * with another Amazon Web Services account. You may not share a custom framework that is derived from a standard
     * framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you
     * have obtained permission to do so from the owner of the standard framework. To learn more about which standard
     * frameworks are eligible for sharing, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility"
     * >Framework sharing eligibility</a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * </important>
     *
     * @param startAssessmentFrameworkShareRequest
     * @return A Java Future containing the result of the StartAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.StartAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/StartAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartAssessmentFrameworkShareResponse> startAssessmentFrameworkShare(
            StartAssessmentFrameworkShareRequest startAssessmentFrameworkShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAssessmentFrameworkShareRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startAssessmentFrameworkShareRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAssessmentFrameworkShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAssessmentFrameworkShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAssessmentFrameworkShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartAssessmentFrameworkShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAssessmentFrameworkShareRequest, StartAssessmentFrameworkShareResponse>()
                            .withOperationName("StartAssessmentFrameworkShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartAssessmentFrameworkShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startAssessmentFrameworkShareRequest));
            CompletableFuture<StartAssessmentFrameworkShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tags the specified resource in Audit Manager.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from a resource in Audit Manager.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Edits an Audit Manager assessment.
     * </p>
     *
     * @param updateAssessmentRequest
     * @return A Java Future containing the result of the UpdateAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssessmentResponse> updateAssessment(UpdateAssessmentRequest updateAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssessmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssessmentRequest, UpdateAssessmentResponse>()
                            .withOperationName("UpdateAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAssessmentRequest));
            CompletableFuture<UpdateAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a control within an assessment in Audit Manager.
     * </p>
     *
     * @param updateAssessmentControlRequest
     * @return A Java Future containing the result of the UpdateAssessmentControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssessmentControlResponse> updateAssessmentControl(
            UpdateAssessmentControlRequest updateAssessmentControlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssessmentControlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssessmentControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssessmentControl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssessmentControlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssessmentControlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssessmentControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssessmentControlRequest, UpdateAssessmentControlResponse>()
                            .withOperationName("UpdateAssessmentControl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssessmentControlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAssessmentControlRequest));
            CompletableFuture<UpdateAssessmentControlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of a control set in an Audit Manager assessment.
     * </p>
     *
     * @param updateAssessmentControlSetStatusRequest
     * @return A Java Future containing the result of the UpdateAssessmentControlSetStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentControlSetStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentControlSetStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssessmentControlSetStatusResponse> updateAssessmentControlSetStatus(
            UpdateAssessmentControlSetStatusRequest updateAssessmentControlSetStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssessmentControlSetStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAssessmentControlSetStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssessmentControlSetStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssessmentControlSetStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateAssessmentControlSetStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssessmentControlSetStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssessmentControlSetStatusRequest, UpdateAssessmentControlSetStatusResponse>()
                            .withOperationName("UpdateAssessmentControlSetStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssessmentControlSetStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAssessmentControlSetStatusRequest));
            CompletableFuture<UpdateAssessmentControlSetStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a custom framework in Audit Manager.
     * </p>
     *
     * @param updateAssessmentFrameworkRequest
     * @return A Java Future containing the result of the UpdateAssessmentFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFramework"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssessmentFrameworkResponse> updateAssessmentFramework(
            UpdateAssessmentFrameworkRequest updateAssessmentFrameworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssessmentFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssessmentFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssessmentFramework");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssessmentFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssessmentFrameworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssessmentFrameworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssessmentFrameworkRequest, UpdateAssessmentFrameworkResponse>()
                            .withOperationName("UpdateAssessmentFramework").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssessmentFrameworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAssessmentFrameworkRequest));
            CompletableFuture<UpdateAssessmentFrameworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a share request for a custom framework in Audit Manager.
     * </p>
     *
     * @param updateAssessmentFrameworkShareRequest
     * @return A Java Future containing the result of the UpdateAssessmentFrameworkShare operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentFrameworkShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentFrameworkShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssessmentFrameworkShareResponse> updateAssessmentFrameworkShare(
            UpdateAssessmentFrameworkShareRequest updateAssessmentFrameworkShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssessmentFrameworkShareRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAssessmentFrameworkShareRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssessmentFrameworkShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssessmentFrameworkShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssessmentFrameworkShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssessmentFrameworkShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssessmentFrameworkShareRequest, UpdateAssessmentFrameworkShareResponse>()
                            .withOperationName("UpdateAssessmentFrameworkShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssessmentFrameworkShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAssessmentFrameworkShareRequest));
            CompletableFuture<UpdateAssessmentFrameworkShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of an assessment in Audit Manager.
     * </p>
     *
     * @param updateAssessmentStatusRequest
     * @return A Java Future containing the result of the UpdateAssessmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ServiceQuotaExceededException You've reached your account quota for this resource type. To perform
     *         the requested action, delete some existing resources or <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">request a quota increase</a>
     *         from the Service Quotas console. For a list of Audit Manager service quotas, see <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html">Quotas and
     *         restrictions for Audit Manager</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateAssessmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateAssessmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssessmentStatusResponse> updateAssessmentStatus(
            UpdateAssessmentStatusRequest updateAssessmentStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssessmentStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssessmentStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssessmentStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssessmentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssessmentStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAssessmentStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssessmentStatusRequest, UpdateAssessmentStatusResponse>()
                            .withOperationName("UpdateAssessmentStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssessmentStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAssessmentStatusRequest));
            CompletableFuture<UpdateAssessmentStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a custom control in Audit Manager.
     * </p>
     *
     * @param updateControlRequest
     * @return A Java Future containing the result of the UpdateControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateControl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateControlResponse> updateControl(UpdateControlRequest updateControlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateControlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateControl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateControlResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateControlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateControlRequest, UpdateControlResponse>()
                            .withOperationName("UpdateControl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateControlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateControlRequest));
            CompletableFuture<UpdateControlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates Audit Manager settings for the current account.
     * </p>
     *
     * @param updateSettingsRequest
     * @return A Java Future containing the result of the UpdateSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.UpdateSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/UpdateSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSettingsResponse> updateSettings(UpdateSettingsRequest updateSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSettingsRequest, UpdateSettingsResponse>()
                            .withOperationName("UpdateSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSettingsRequest));
            CompletableFuture<UpdateSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Validates the integrity of an assessment report in Audit Manager.
     * </p>
     *
     * @param validateAssessmentReportIntegrityRequest
     * @return A Java Future containing the result of the ValidateAssessmentReportIntegrity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>AccessDeniedException Your account isn't registered with Audit Manager. Check the delegated
     *         administrator setup on the Audit Manager settings page, and try again.</li>
     *         <li>InternalServerException An internal service error occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException The resource that's specified in the request can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AuditManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AuditManagerAsyncClient.ValidateAssessmentReportIntegrity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/ValidateAssessmentReportIntegrity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ValidateAssessmentReportIntegrityResponse> validateAssessmentReportIntegrity(
            ValidateAssessmentReportIntegrityRequest validateAssessmentReportIntegrityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(validateAssessmentReportIntegrityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                validateAssessmentReportIntegrityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AuditManager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ValidateAssessmentReportIntegrity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ValidateAssessmentReportIntegrityResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ValidateAssessmentReportIntegrityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ValidateAssessmentReportIntegrityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ValidateAssessmentReportIntegrityRequest, ValidateAssessmentReportIntegrityResponse>()
                            .withOperationName("ValidateAssessmentReportIntegrity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ValidateAssessmentReportIntegrityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(validateAssessmentReportIntegrityRequest));
            CompletableFuture<ValidateAssessmentReportIntegrityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final AuditManagerServiceClientConfiguration serviceClientConfiguration() {
        return new AuditManagerServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AuditManagerException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AuditManagerServiceClientConfigurationBuilder serviceConfigBuilder = new AuditManagerServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
