/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.ExecutorState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExecutorsRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, ListExecutorsRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(ListExecutorsRequest.getter(ListExecutorsRequest::sessionId)).setter(ListExecutorsRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> EXECUTOR_STATE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutorStateFilter").getter(ListExecutorsRequest.getter(ListExecutorsRequest::executorStateFilterAsString)).setter(ListExecutorsRequest.setter(Builder::executorStateFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutorStateFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListExecutorsRequest.getter(ListExecutorsRequest::maxResults)).setter(ListExecutorsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExecutorsRequest.getter(ListExecutorsRequest::nextToken)).setter(ListExecutorsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, EXECUTOR_STATE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String sessionId;
    private final String executorStateFilter;
    private final Integer maxResults;
    private final String nextToken;

    private ListExecutorsRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.executorStateFilter = builder.executorStateFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final ExecutorState executorStateFilter() {
        return ExecutorState.fromValue(this.executorStateFilter);
    }

    public final String executorStateFilterAsString() {
        return this.executorStateFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executorStateFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutorsRequest)) {
            return false;
        }
        ListExecutorsRequest other = (ListExecutorsRequest)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.executorStateFilterAsString(), other.executorStateFilterAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExecutorsRequest").add("SessionId", (Object)this.sessionId()).add("ExecutorStateFilter", (Object)this.executorStateFilterAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "ExecutorStateFilter": {
                return Optional.ofNullable(clazz.cast(this.executorStateFilterAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExecutorsRequest, T> g) {
        return obj -> g.apply((ListExecutorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String sessionId;
        private String executorStateFilter;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutorsRequest model) {
            super(model);
            this.sessionId(model.sessionId);
            this.executorStateFilter(model.executorStateFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getExecutorStateFilter() {
            return this.executorStateFilter;
        }

        public final void setExecutorStateFilter(String executorStateFilter) {
            this.executorStateFilter = executorStateFilter;
        }

        @Override
        public final Builder executorStateFilter(String executorStateFilter) {
            this.executorStateFilter = executorStateFilter;
            return this;
        }

        @Override
        public final Builder executorStateFilter(ExecutorState executorStateFilter) {
            this.executorStateFilter(executorStateFilter == null ? null : executorStateFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExecutorsRequest build() {
            return new ListExecutorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExecutorsRequest> {
        public Builder sessionId(String var1);

        public Builder executorStateFilter(String var1);

        public Builder executorStateFilter(ExecutorState var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

