/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModel;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceIntrospectionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceIntrospectionResult> {
    private static final SdkField<List<DataSourceIntrospectionModel>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("models").getter(DataSourceIntrospectionResult.getter(DataSourceIntrospectionResult::models)).setter(DataSourceIntrospectionResult.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceIntrospectionModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DataSourceIntrospectionResult.getter(DataSourceIntrospectionResult::nextToken)).setter(DataSourceIntrospectionResult.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODELS_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DataSourceIntrospectionModel> models;
    private final String nextToken;

    private DataSourceIntrospectionResult(BuilderImpl builder) {
        this.models = builder.models;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<DataSourceIntrospectionModel> models() {
        return this.models;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceIntrospectionResult)) {
            return false;
        }
        DataSourceIntrospectionResult other = (DataSourceIntrospectionResult)obj;
        return this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceIntrospectionResult").add("Models", this.hasModels() ? this.models() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceIntrospectionResult, T> g) {
        return obj -> g.apply((DataSourceIntrospectionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSourceIntrospectionModel> models = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceIntrospectionResult model) {
            this.models(model.models);
            this.nextToken(model.nextToken);
        }

        public final List<DataSourceIntrospectionModel.Builder> getModels() {
            List<DataSourceIntrospectionModel.Builder> result = DataSourceIntrospectionModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<DataSourceIntrospectionModel.BuilderImpl> models) {
            this.models = DataSourceIntrospectionModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<DataSourceIntrospectionModel> models) {
            this.models = DataSourceIntrospectionModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(DataSourceIntrospectionModel ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<DataSourceIntrospectionModel.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (DataSourceIntrospectionModel)((DataSourceIntrospectionModel.Builder)DataSourceIntrospectionModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public DataSourceIntrospectionResult build() {
            return new DataSourceIntrospectionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceIntrospectionResult> {
        public Builder models(Collection<DataSourceIntrospectionModel> var1);

        public Builder models(DataSourceIntrospectionModel ... var1);

        public Builder models(Consumer<DataSourceIntrospectionModel.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

