/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApiCachingBehavior {
    FULL_REQUEST_CACHING("FULL_REQUEST_CACHING"),
    PER_RESOLVER_CACHING("PER_RESOLVER_CACHING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApiCachingBehavior> VALUE_MAP;
    private final String value;

    private ApiCachingBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApiCachingBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApiCachingBehavior> knownValues() {
        EnumSet<ApiCachingBehavior> knownValues = EnumSet.allOf(ApiCachingBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApiCachingBehavior.class, ApiCachingBehavior::toString);
    }
}

